/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.AssertionBuilder;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.HttpsToken;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpsTokenBuilder
implements AssertionBuilder {
    private static final List<QName> KNOWN_ELEMENTS = Arrays.asList(SP11Constants.HTTPS_TOKEN, SP12Constants.HTTPS_TOKEN);
    PolicyBuilder builder;

    public HttpsTokenBuilder(PolicyBuilder b) {
        this.builder = b;
    }

    public PolicyAssertion build(Element element) {
        Element child;
        Element polEl;
        SPConstants consts = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        HttpsToken httpsToken = new HttpsToken(consts);
        httpsToken.setOptional(PolicyConstants.isOptional((Element)element));
        if (consts.getVersion() == SPConstants.Version.SP_V11) {
            String attr = DOMUtils.getAttribute((Element)element, (QName)SPConstants.REQUIRE_CLIENT_CERTIFICATE);
            if (attr != null) {
                httpsToken.setRequireClientCertificate("true".equals(attr));
            }
        } else if (consts.getVersion() == SPConstants.Version.SP_V11 && (polEl = PolicyConstants.findPolicyElement((Element)element)) != null && (child = DOMUtils.getFirstElement((Node)polEl)) != null) {
            if (SP12Constants.HTTP_BASIC_AUTHENTICATION.equals(DOMUtils.getElementQName((Element)child))) {
                httpsToken.setHttpBasicAuthentication(true);
            } else if (SP12Constants.HTTP_DIGEST_AUTHENTICATION.equals(DOMUtils.getElementQName((Element)child))) {
                httpsToken.setHttpDigestAuthentication(true);
            } else if (SP12Constants.REQUIRE_CLIENT_CERTIFICATE.equals(DOMUtils.getElementQName((Element)child))) {
                httpsToken.setRequireClientCertificate(true);
            }
        }
        return httpsToken;
    }

    public List<QName> getKnownElements() {
        return KNOWN_ELEMENTS;
    }

    public PolicyAssertion buildCompatible(PolicyAssertion a, PolicyAssertion b) {
        return null;
    }
}

