/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.Token;
import org.apache.cxf.ws.security.policy.model.TokenWrapper;

public class RecipientToken
extends TokenWrapper {
    public RecipientToken(SPConstants version) {
        super(version);
    }

    public Token getRecipientToken() {
        return this.getToken();
    }

    public void setRecipientToken(Token recipientToken) {
        this.setToken(recipientToken);
    }

    public QName getRealName() {
        return this.constants.getRecipientToken();
    }

    public QName getName() {
        return SP12Constants.INSTANCE.getRecipientToken();
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String localName = this.getRealName().getLocalPart();
        String namespaceURI = this.getRealName().getNamespaceURI();
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = this.getRealName().getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        }
        writer.writeStartElement(prefix, localName, namespaceURI);
        String pPrefix = writer.getPrefix(SPConstants.POLICY.getNamespaceURI());
        if (pPrefix == null) {
            pPrefix = SPConstants.POLICY.getPrefix();
            writer.setPrefix(pPrefix, SPConstants.POLICY.getNamespaceURI());
        }
        writer.writeStartElement(pPrefix, SPConstants.POLICY.getLocalPart(), SPConstants.POLICY.getNamespaceURI());
        Token token = this.getRecipientToken();
        if (token == null) {
            throw new RuntimeException("RecipientToken doesn't contain any token assertions");
        }
        token.serialize(writer);
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

