/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxfbc.interceptors;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.model.SoapBindingInfo;
import org.apache.cxf.binding.soap.model.SoapHeaderInfo;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.PartialXMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.servicemix.cxfbc.interceptors.CxfJbiConstants;
import org.apache.servicemix.cxfbc.interceptors.JbiOperationInterceptor;
import org.apache.servicemix.soap.util.DomUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JbiInWsdl1Interceptor
extends AbstractSoapInterceptor {
    private boolean useJBIWrapper = true;
    private boolean useSOAPEnvelope = true;

    public JbiInWsdl1Interceptor(boolean useJBIWrapper, boolean useSOAPEnvelope) {
        super("pre-invoke");
        this.addAfter(JbiOperationInterceptor.class.getName());
        this.useJBIWrapper = useJBIWrapper;
        this.useSOAPEnvelope = useSOAPEnvelope;
    }

    public void handleMessage(SoapMessage message) {
        Document document;
        block16: {
            Element body;
            block14: {
                block15: {
                    if (message.getContent(Exception.class) != null) {
                        return;
                    }
                    document = DomUtil.createDocument();
                    if (this.useJBIWrapper) break block14;
                    SoapVersion soapVersion = message.getVersion();
                    if (!this.useSOAPEnvelope) break block15;
                    Element soapEnv = DomUtil.createElement((Node)document, (QName)new QName(soapVersion.getEnvelope().getNamespaceURI(), soapVersion.getEnvelope().getLocalPart(), soapVersion.getPrefix()));
                    Element soapBody = DomUtil.createElement((Node)soapEnv, (QName)new QName(soapVersion.getBody().getNamespaceURI(), soapVersion.getBody().getLocalPart(), soapVersion.getPrefix()));
                    soapEnv.appendChild(soapBody);
                    Element body2 = this.getBodyElement(message);
                    if (body2 != null) {
                        soapBody.appendChild(soapBody.getOwnerDocument().importNode(body2, true));
                    }
                    break block16;
                }
                Element body3 = this.getBodyElement(message);
                if (body3 == null) break block16;
                document.appendChild(document.importNode(body3, true));
                break block16;
            }
            BindingOperationInfo wsdlOperation = this.getOperation((Message)message);
            BindingMessageInfo wsdlMessage = !this.isRequestor((Message)message) ? wsdlOperation.getInput() : wsdlOperation.getOutput();
            document = DomUtil.createDocument();
            Element root = DomUtil.createElement((Node)document, (QName)CxfJbiConstants.WSDL11_WRAPPER_MESSAGE);
            String typeNamespace = wsdlMessage.getMessageInfo().getName().getNamespaceURI();
            if (typeNamespace == null || typeNamespace.length() == 0) {
                throw new IllegalArgumentException("messageType namespace is null or empty");
            }
            root.setAttribute("xmlns:msg", typeNamespace);
            root.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            String typeLocalName = wsdlMessage.getMessageInfo().getName().getLocalPart();
            if (typeLocalName == null || typeLocalName.length() == 0) {
                throw new IllegalArgumentException("messageType local name is null or empty");
            }
            root.setAttribute("type", "msg:" + typeLocalName);
            String messageName = wsdlMessage.getMessageInfo().getName().getLocalPart();
            root.setAttribute("name", messageName);
            root.setAttribute("version", "1.0");
            SoapBindingInfo binding = (SoapBindingInfo)((Endpoint)message.getExchange().get(Endpoint.class)).getEndpointInfo().getBinding();
            String style = binding.getStyle(wsdlOperation.getOperationInfo());
            if (style == null) {
                style = binding.getStyle();
            }
            if ((body = this.getBodyElement(message)) == null) {
                return;
            }
            if (body.getLocalName().equals("Fault")) {
                this.handleJBIFault(message, body);
                return;
            }
            List headers = wsdlMessage.getExtensors(SoapHeaderInfo.class);
            List headerElement = message.getHeaders();
            ArrayList<Object> parts = new ArrayList<Object>();
            for (MessagePartInfo messagePartInfo : wsdlMessage.getMessageParts()) {
                if ("document".equals(style)) {
                    parts.add(body);
                    continue;
                }
                Element param = DomUtil.getFirstChildElement((Node)body);
                boolean found = false;
                while (param != null) {
                    if (messagePartInfo.getName().getLocalPart().equals(param.getLocalName())) {
                        found = true;
                        parts.add(this.wrapNodeList(param.getChildNodes()));
                        break;
                    }
                    param = DomUtil.getNextSiblingElement((Element)param);
                }
                if (found) continue;
                throw new Fault((Throwable)new Exception("Missing part '" + messagePartInfo.getName() + "'"));
            }
            this.processHeader(message, headers, headerElement, parts);
            for (Object e : parts) {
                if (e instanceof Node) {
                    JbiInWsdl1Interceptor.addPart(root, (Node)e);
                    continue;
                }
                if (e instanceof NodeList) {
                    JbiInWsdl1Interceptor.addPart(root, (NodeList)e);
                    continue;
                }
                if (!(e instanceof SoapHeader)) continue;
                JbiInWsdl1Interceptor.addPart(root, (Node)((SoapHeader)e).getObject());
            }
        }
        message.setContent(Source.class, (Object)new DOMSource(document));
    }

    private void processHeader(SoapMessage message, List<SoapHeaderInfo> headers, List<Header> headerElement, List<Object> parts) {
        if (headers != null) {
            for (SoapHeaderInfo header : headers) {
                MessagePartInfo part = header.getPart();
                Header param = JbiInWsdl1Interceptor.findHeader(headerElement, part);
                int idx = part.getIndex();
                if (idx > parts.size()) {
                    parts.add(param);
                    continue;
                }
                if (idx == -1) {
                    parts.add(0, param);
                    continue;
                }
                parts.add(idx, param);
            }
        }
    }

    private void handleJBIFault(SoapMessage message, Element soapFault) {
        NodeList nodeList;
        Document doc = DomUtil.createDocument();
        Element jbiFault = DomUtil.createElement((Node)doc, (QName)new QName("http://java.sun.com/xml/ns/jbi/wsdl-11-wrapper", "JBIFault"));
        Node jbiFaultDetail = null;
        if (message.getVersion() instanceof Soap11) {
            nodeList = soapFault.getElementsByTagName("faultcode");
            String faultCode = nodeList.item(0).getFirstChild().getTextContent();
            String prefix = faultCode.substring(0, faultCode.indexOf(":"));
            String localName = faultCode.substring(faultCode.indexOf(":") + 1);
            message.put("faultcode", (Object)new QName(prefix, localName));
            nodeList = soapFault.getElementsByTagName("faultstring");
            message.put("faultstring", (Object)nodeList.item(0).getFirstChild().getTextContent());
            nodeList = soapFault.getElementsByTagName("detail");
            if (nodeList != null && nodeList.getLength() > 0 && nodeList.item(0).getFirstChild() != null) {
                jbiFaultDetail = doc.importNode(nodeList.item(0).getFirstChild(), true);
            } else {
                message.put("hasdetail", (Object)false);
                nodeList = soapFault.getElementsByTagName("faultstring");
                jbiFaultDetail = doc.importNode(nodeList.item(0).getFirstChild(), true);
            }
        } else {
            nodeList = soapFault.getElementsByTagName("soap:Code");
            String faultCode = nodeList.item(0).getFirstChild().getTextContent();
            String prefix = faultCode.substring(0, faultCode.indexOf(":"));
            String localName = faultCode.substring(faultCode.indexOf(":") + 1);
            message.put("faultcode", (Object)new QName(prefix, localName));
            nodeList = soapFault.getElementsByTagName("soap:Reason");
            message.put("faultstring", (Object)nodeList.item(0).getFirstChild().getTextContent());
            nodeList = soapFault.getElementsByTagName("soap:Detail");
            if (nodeList != null && nodeList.getLength() > 0 && nodeList.item(0).getFirstChild() != null) {
                jbiFaultDetail = doc.importNode(nodeList.item(0).getFirstChild(), true);
            } else {
                message.put("hasdetail", (Object)false);
                nodeList = soapFault.getElementsByTagName("faultstring");
                jbiFaultDetail = doc.importNode(nodeList.item(0).getFirstChild(), true);
            }
        }
        SchemaInfo schemaInfo = this.getOperation((Message)message).getBinding().getService().getSchema(jbiFaultDetail.getNamespaceURI());
        if (schemaInfo != null && !schemaInfo.isElementFormQualified() && jbiFaultDetail instanceof Element) {
            jbiFaultDetail = this.addEmptyDefaultTns((Element)jbiFaultDetail);
        }
        jbiFault.appendChild(jbiFaultDetail);
        message.setContent(Source.class, (Object)new DOMSource(doc));
        message.put("jbiFault", (Object)true);
    }

    private Element addEmptyDefaultTns(Element ret) {
        if (!ret.hasAttribute("xmlns")) {
            ret.setAttribute("xmlns", "");
        }
        NodeList nodes = ret.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            if (!(nodes.item(i) instanceof Element)) continue;
            Element ele = (Element)nodes.item(i);
            ele = this.addEmptyDefaultTns(ele);
        }
        return ret;
    }

    private NodeList wrapNodeList(final NodeList childNodes) {
        return new NodeList(){

            public int getLength() {
                return childNodes.getLength();
            }

            public Node item(int index) {
                return childNodes.item(index);
            }
        };
    }

    protected BindingOperationInfo getOperation(Message message) {
        BindingOperationInfo operation = (BindingOperationInfo)message.getExchange().get(BindingOperationInfo.class);
        if (operation == null) {
            throw new Fault((Throwable)new Exception("Operation not bound on this message"));
        }
        return operation;
    }

    protected Element getBodyElement(SoapMessage message) {
        try {
            XMLStreamReader xmlReader = (XMLStreamReader)message.getContent(XMLStreamReader.class);
            PartialXMLStreamReader filteredReader = new PartialXMLStreamReader(xmlReader, message.getVersion().getBody());
            StaxUtils.toNextElement((DepthXMLStreamReader)((DepthXMLStreamReader)filteredReader));
            Document doc = DOMUtils.createDocument();
            StaxUtils.readDocElements((Node)doc, (XMLStreamReader)filteredReader, (boolean)false);
            return doc.getDocumentElement();
        }
        catch (XMLStreamException e) {
            throw new Fault((Throwable)e);
        }
    }

    protected Header getHeaderElement(SoapMessage message, QName name) {
        boolean client;
        BindingMessageInfo bmi;
        Exchange exchange = message.getExchange();
        BindingOperationInfo bop = (BindingOperationInfo)exchange.get(BindingOperationInfo.class);
        if (bop.isUnwrapped()) {
            bop = bop.getWrappedOperation();
        }
        BindingMessageInfo bindingMessageInfo = bmi = (client = this.isRequestor((Message)message)) ? bop.getOutput() : bop.getInput();
        if (bmi == null) {
            return null;
        }
        List headers = bmi.getExtensors(SoapHeaderInfo.class);
        if (headers == null || headers.size() == 0) {
            return null;
        }
        List headerElement = message.getHeaders();
        for (SoapHeaderInfo header : headers) {
            QName qname = header.getPart().isElement() ? header.getPart().getElementQName() : header.getPart().getTypeQName();
            if (!qname.equals(name)) continue;
            MessagePartInfo mpi = header.getPart();
            return JbiInWsdl1Interceptor.findHeader(headerElement, mpi);
        }
        return null;
    }

    private static void addPart(Element parent, Node partValue) {
        Element element = DomUtil.createElement((Node)parent, (QName)CxfJbiConstants.WSDL11_WRAPPER_PART);
        element.appendChild(element.getOwnerDocument().importNode(partValue, true));
    }

    private static void addPart(Element parent, NodeList nodes) {
        Element element = DomUtil.createElement((Node)parent, (QName)CxfJbiConstants.WSDL11_WRAPPER_PART);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            element.appendChild(element.getOwnerDocument().importNode(node, true));
        }
    }

    private static Header findHeader(List<Header> headerElement, MessagePartInfo mpi) {
        Header param = null;
        if (headerElement != null) {
            QName name = mpi.getConcreteName();
            for (Header header : headerElement) {
                if (mpi.isElement()) {
                    if (header.getName().getNamespaceURI() == null || !header.getName().getNamespaceURI().equals(name.getNamespaceURI()) || header.getName().getLocalPart() == null || !header.getName().getLocalPart().equals(name.getLocalPart())) continue;
                    param = header;
                    continue;
                }
                if (header.getName().getLocalPart() == null || !header.getName().getLocalPart().equals(name.getLocalPart())) continue;
                param = header;
            }
        }
        return param;
    }
}

