/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxfbc;

import com.ibm.wsdl.extensions.soap.SOAPAddressImpl;
import com.ibm.wsdl.extensions.soap.SOAPBindingImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.activation.DataHandler;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.transaction.TransactionManager;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.MustUnderstandInterceptor;
import org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor;
import org.apache.cxf.binding.soap.interceptor.SoapActionOutInterceptor;
import org.apache.cxf.binding.soap.interceptor.SoapOutInterceptor;
import org.apache.cxf.binding.soap.interceptor.SoapPreProtocolOutInterceptor;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.catalog.OASISCatalogManager;
import org.apache.cxf.continuations.Continuation;
import org.apache.cxf.continuations.ContinuationProvider;
import org.apache.cxf.continuations.SuspendedInvocationException;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointImpl;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerImpl;
import org.apache.cxf.endpoint.ServerRegistry;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.AttachmentInInterceptor;
import org.apache.cxf.interceptor.AttachmentOutInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.interceptor.OutgoingChainInterceptor;
import org.apache.cxf.interceptor.StaxInInterceptor;
import org.apache.cxf.interceptor.StaxOutInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.model.BindingFaultInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.ChainInitiationObserver;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.http_jetty.JettyHTTPDestination;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngine;
import org.apache.cxf.transport.jms.JMSConfiguration;
import org.apache.cxf.transport.jms.JMSDestination;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.rm.Servant;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.cxf.wsdl11.WSDLServiceFactory;
import org.apache.servicemix.common.endpoints.ConsumerEndpoint;
import org.apache.servicemix.common.security.AuthenticationService;
import org.apache.servicemix.cxfbc.CxfBcComponent;
import org.apache.servicemix.cxfbc.CxfBcEndpointWithInterceptor;
import org.apache.servicemix.cxfbc.ListServiceHandler;
import org.apache.servicemix.cxfbc.WSAUtils;
import org.apache.servicemix.cxfbc.interceptors.JbiFault;
import org.apache.servicemix.cxfbc.interceptors.JbiInInterceptor;
import org.apache.servicemix.cxfbc.interceptors.JbiInWsdl1Interceptor;
import org.apache.servicemix.cxfbc.interceptors.JbiJAASInterceptor;
import org.apache.servicemix.cxfbc.interceptors.JbiOperationInterceptor;
import org.apache.servicemix.cxfbc.interceptors.JbiOutWsdl1Interceptor;
import org.apache.servicemix.cxfbc.interceptors.MtomCheckInterceptor;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.soap.util.DomUtil;
import org.springframework.core.io.Resource;
import org.springframework.transaction.PlatformTransactionManager;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfBcConsumer
extends ConsumerEndpoint
implements CxfBcEndpointWithInterceptor {
    List<Interceptor> in = new CopyOnWriteArrayList<Interceptor>();
    List<Interceptor> out = new CopyOnWriteArrayList<Interceptor>();
    List<Interceptor> outFault = new CopyOnWriteArrayList<Interceptor>();
    List<Interceptor> inFault = new CopyOnWriteArrayList<Interceptor>();
    private Resource wsdl;
    private Endpoint ep;
    private ChainInitiationObserver chain;
    private Server server;
    private Map<String, Message> messages = new ConcurrentHashMap<String, Message>();
    private boolean synchronous = true;
    private boolean isOneway;
    private String busCfg;
    private BindingFaultInfo faultWanted;
    private Bus bus;
    private boolean mtomEnabled;
    private String locationURI;
    private long timeout = 0L;
    private boolean useJBIWrapper = true;
    private boolean useSOAPEnvelope = true;
    private EndpointInfo ei;
    private boolean started;
    private List<AbstractFeature> features = new CopyOnWriteArrayList<AbstractFeature>();
    private boolean transactionEnabled;
    private boolean isSTFlow;
    private ClassLoader suClassLoader;
    private boolean x509;

    public Resource getWsdl() {
        return this.wsdl;
    }

    public void setWsdl(Resource wsdl) {
        this.wsdl = wsdl;
    }

    @Override
    public List<Interceptor> getOutFaultInterceptors() {
        return this.outFault;
    }

    @Override
    public List<Interceptor> getInFaultInterceptors() {
        return this.inFault;
    }

    @Override
    public List<Interceptor> getInInterceptors() {
        return this.in;
    }

    @Override
    public List<Interceptor> getOutInterceptors() {
        return this.out;
    }

    @Override
    public void setInInterceptors(List<Interceptor> interceptors) {
        this.in.addAll(interceptors);
    }

    @Override
    public void setInFaultInterceptors(List<Interceptor> interceptors) {
        this.inFault.addAll(interceptors);
    }

    @Override
    public void setOutInterceptors(List<Interceptor> interceptors) {
        this.out.addAll(interceptors);
    }

    @Override
    public void setOutFaultInterceptors(List<Interceptor> interceptors) {
        this.outFault.addAll(interceptors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MessageExchange exchange) throws Exception {
        if (exchange.getStatus() != ExchangeStatus.ACTIVE) {
            return;
        }
        Message message = this.messages.remove(exchange.getExchangeId());
        InterceptorChain interceptorChain = message.getInterceptorChain();
        synchronized (interceptorChain) {
            boolean oneway = ((BindingOperationInfo)message.getExchange().get(BindingOperationInfo.class)).getOperationInfo().isOneWay();
            if (!this.isSynchronous() && !oneway) {
                ContinuationProvider continuationProvider = (ContinuationProvider)message.get((Object)ContinuationProvider.class.getName());
                Continuation continuation = continuationProvider.getContinuation();
                if (continuation.isPending()) {
                    continuation.resume();
                    this.isSTFlow = false;
                } else {
                    this.isSTFlow = true;
                }
            }
            if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
                exchange.setStatus(ExchangeStatus.DONE);
                ((ComponentContext)message.getExchange().get(ComponentContext.class)).getDeliveryChannel().send(exchange);
            }
        }
    }

    public void activate() throws Exception {
        super.activate();
        try {
            this.registerListServiceHandler();
            this.applyFeatures();
            this.checkJmsTransportTransaction();
            this.server.start();
        }
        catch (Exception ex) {
            super.deactivate();
            throw ex;
        }
    }

    private void checkJmsTransportTransaction() {
        JMSDestination jmsDestination;
        JMSConfiguration jmsConfig;
        Destination destination = this.server.getDestination();
        if (destination instanceof JMSDestination && (jmsConfig = (jmsDestination = (JMSDestination)destination).getJmsConfig()).isSessionTransacted()) {
            TransactionManager tm = (TransactionManager)this.getContext().getTransactionManager();
            if (tm == null) {
                throw new IllegalStateException("No TransactionManager available");
            }
            if (tm instanceof PlatformTransactionManager) {
                jmsConfig.setSessionTransacted(true);
                jmsConfig.setTransactionManager((PlatformTransactionManager)tm);
                jmsConfig.setUseJms11(false);
                this.setSynchronous(true);
                this.transactionEnabled = true;
            }
        }
    }

    private void applyFeatures() {
        if (this.getFeatures() != null) {
            for (AbstractFeature feature : this.getFeatures()) {
                feature.initialize(this.server, this.getBus());
            }
        }
    }

    private void registerListServiceHandler() {
        if (this.server.getDestination() instanceof JettyHTTPDestination) {
            JettyHTTPDestination jettyDest = (JettyHTTPDestination)this.server.getDestination();
            JettyHTTPServerEngine jettyEng = (JettyHTTPServerEngine)jettyDest.getEngine();
            ArrayList<ListServiceHandler> handlers = jettyEng.getHandlers();
            if (handlers == null) {
                handlers = new ArrayList<ListServiceHandler>();
                jettyEng.setHandlers(handlers);
            }
            handlers.add(new ListServiceHandler((ServerRegistry)this.getBus().getExtension(ServerRegistry.class)));
        }
    }

    public void start() throws Exception {
        super.start();
        this.started = true;
    }

    public void stop() throws Exception {
        this.started = false;
        super.stop();
    }

    public void deactivate() throws Exception {
        this.server.stop();
        if (!this.isComponentBus()) {
            this.bus.shutdown(true);
            this.bus = null;
        }
        super.deactivate();
    }

    public void validate() throws DeploymentException {
        try {
            this.suClassLoader = Thread.currentThread().getContextClassLoader();
            if (this.definition == null) {
                this.retrieveWSDL();
            }
            if (this.service == null) {
                this.service = this.definition.getServices().containsKey(this.getTargetService()) ? this.getTargetService() : (QName)this.definition.getServices().keySet().iterator().next();
            }
            WSDLServiceFactory factory = new WSDLServiceFactory(this.getBus(), this.definition, this.service);
            Service cxfService = factory.create();
            this.ei = (EndpointInfo)((ServiceInfo)cxfService.getServiceInfos().iterator().next()).getEndpoints().iterator().next();
            for (ServiceInfo serviceInfo : cxfService.getServiceInfos()) {
                if (!serviceInfo.getName().equals(this.service) || this.getEndpoint() == null || serviceInfo.getEndpoint(new QName(serviceInfo.getName().getNamespaceURI(), this.getEndpoint())) == null) continue;
                this.ei = serviceInfo.getEndpoint(new QName(serviceInfo.getName().getNamespaceURI(), this.getEndpoint()));
            }
            if (this.endpoint == null) {
                this.endpoint = this.ei.getName().getLocalPart();
            }
            if (this.locationURI != null) {
                this.ei.setAddress(this.locationURI);
            }
            cxfService.getInInterceptors().add(new AbstractPhaseInterceptor<Message>("pre-protocol"){

                public void handleMessage(Message message) throws Fault {
                    if (!CxfBcConsumer.this.started) {
                        throw new Fault((Throwable)new Exception("Endpoint is stopped"));
                    }
                }
            });
            cxfService.getInInterceptors().add(new MustUnderstandInterceptor());
            cxfService.getInInterceptors().add(new AttachmentInInterceptor());
            cxfService.getInInterceptors().add(new StaxInInterceptor());
            cxfService.getInInterceptors().add(new ReadHeadersInterceptor(this.getBus()));
            cxfService.getInInterceptors().add(new JbiOperationInterceptor());
            cxfService.getInInterceptors().add(new JbiInWsdl1Interceptor(this.isUseJBIWrapper(), this.isUseSOAPEnvelope()));
            cxfService.getInInterceptors().add(new JbiInInterceptor());
            cxfService.getInInterceptors().add(new JbiJAASInterceptor(AuthenticationService.Proxy.create((Object)((CxfBcComponent)this.getServiceUnit().getComponent()).getConfiguration().getAuthenticationService()), this.isX509()));
            cxfService.getInInterceptors().add(new JbiInvokerInterceptor());
            cxfService.getInInterceptors().add(new JbiPostInvokerInterceptor());
            cxfService.getInInterceptors().add(new OutgoingChainInterceptor());
            cxfService.getOutInterceptors().add(new JbiOutWsdl1Interceptor(this.isUseJBIWrapper(), this.isUseSOAPEnvelope()));
            cxfService.getOutInterceptors().add(new SoapActionOutInterceptor());
            cxfService.getOutInterceptors().add(new AttachmentOutInterceptor());
            cxfService.getOutInterceptors().add(new MtomCheckInterceptor(this.isMtomEnabled()));
            cxfService.getOutInterceptors().add(new StaxOutInterceptor());
            cxfService.getOutInterceptors().add(new SoapPreProtocolOutInterceptor());
            cxfService.getOutInterceptors().add(new SoapOutInterceptor(this.getBus()));
            cxfService.getOutFaultInterceptors().add(new SoapOutInterceptor(this.getBus()));
            this.ep = new EndpointImpl(this.getBus(), cxfService, this.ei);
            this.getInInterceptors().addAll(this.getBus().getInInterceptors());
            this.getInFaultInterceptors().addAll(this.getBus().getInFaultInterceptors());
            this.getOutInterceptors().addAll(this.getBus().getOutInterceptors());
            this.getOutFaultInterceptors().addAll(this.getBus().getOutFaultInterceptors());
            cxfService.getInInterceptors().addAll(this.getInInterceptors());
            cxfService.getInFaultInterceptors().addAll(this.getInFaultInterceptors());
            cxfService.getOutInterceptors().addAll(this.getOutInterceptors());
            cxfService.getOutFaultInterceptors().addAll(this.getOutFaultInterceptors());
            this.ep.getInInterceptors().addAll(this.getInInterceptors());
            this.ep.getInFaultInterceptors().addAll(this.getInFaultInterceptors());
            this.ep.getOutInterceptors().addAll(this.getOutInterceptors());
            this.ep.getOutFaultInterceptors().addAll(this.getOutFaultInterceptors());
            this.ep.getOutInterceptors().add(new SoapActionOutInterceptor());
            this.ep.getOutInterceptors().add(new AttachmentOutInterceptor());
            this.ep.getOutInterceptors().add(new StaxOutInterceptor());
            this.ep.getOutInterceptors().add(new SoapOutInterceptor(this.getBus()));
            cxfService.getInInterceptors().addAll(this.getBus().getInInterceptors());
            cxfService.getInFaultInterceptors().addAll(this.getBus().getInFaultInterceptors());
            cxfService.getOutInterceptors().addAll(this.getBus().getOutInterceptors());
            cxfService.getOutFaultInterceptors().addAll(this.getBus().getOutFaultInterceptors());
            this.chain = new JbiChainInitiationObserver(this.ep, this.getBus());
            this.removeDatabindingInterceptprs();
            this.server = new ServerImpl(this.getBus(), this.ep, null, (MessageObserver)this.chain);
            super.validate();
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    private void removeDatabindingInterceptprs() {
        for (Interceptor interceptor : this.ep.getBinding().getInInterceptors()) {
            if (!interceptor.getClass().getName().equals("org.apache.cxf.interceptor.DocLiteralInInterceptor") && !interceptor.getClass().getName().equals("org.apache.cxf.binding.soap.interceptor.SoapHeaderInterceptor") && !interceptor.getClass().getName().equals("org.apache.cxf.binding.soap.interceptor.RPCInInterceptor")) continue;
            this.ep.getBinding().getInInterceptors().remove(interceptor);
        }
        for (Interceptor interceptor : this.ep.getBinding().getOutInterceptors()) {
            if (!interceptor.getClass().getName().equals("org.apache.cxf.interceptor.WrappedOutInterceptor") && !interceptor.getClass().getName().equals("org.apache.cxf.interceptor.BareOutInterceptor")) continue;
            this.ep.getBinding().getOutInterceptors().remove(interceptor);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void retrieveWSDL() throws JBIException, WSDLException, DeploymentException, IOException {
        if (this.wsdl == null) {
            List binding;
            if (this.getTargetService() == null || this.getTargetEndpoint() == null) throw new DeploymentException("can't get wsdl");
            ServiceEndpoint serviceEndpoint = this.getServiceUnit().getComponent().getComponentContext().getEndpoint(this.getTargetService(), this.getTargetEndpoint());
            if (serviceEndpoint == null) return;
            this.description = this.getServiceUnit().getComponent().getComponentContext().getEndpointDescriptor(serviceEndpoint);
            this.definition = ((WSDLManager)this.getBus().getExtension(WSDLManager.class)).getDefinition((Element)this.description.getFirstChild());
            List address = this.definition.getService(this.getTargetService()).getPort(this.getTargetEndpoint()).getExtensibilityElements();
            if (address == null || address.size() == 0) {
                SOAPAddressImpl soapAddress = new SOAPAddressImpl();
                soapAddress.setLocationURI("http://localhost");
                this.definition.getService(this.getTargetService()).getPort(this.getTargetEndpoint()).addExtensibilityElement((ExtensibilityElement)soapAddress);
            }
            if ((binding = this.definition.getService(this.getTargetService()).getPort(this.getTargetEndpoint()).getBinding().getExtensibilityElements()) != null && binding.size() != 0) return;
            SOAPBindingImpl soapBinding = new SOAPBindingImpl();
            soapBinding.setTransportURI("http://schemas.xmlsoap.org/soap/http");
            soapBinding.setStyle("document");
            this.definition.getService(this.getTargetService()).getPort(this.getTargetEndpoint()).getBinding().addExtensibilityElement((ExtensibilityElement)soapBinding);
            return;
        }
        this.description = DomUtil.parse((InputStream)this.wsdl.getInputStream());
        try {
            OASISCatalogManager.getCatalogManager((Bus)this.getBus()).loadContextCatalogs();
            this.definition = ((WSDLManager)this.getBus().getExtension(WSDLManager.class)).getDefinition(this.wsdl.getURL());
            return;
        }
        catch (WSDLException wSDLException) {
            // empty catch block
        }
    }

    protected Bus getBus() {
        if (this.getBusCfg() != null) {
            if (this.bus == null) {
                SpringBusFactory bf = new SpringBusFactory();
                this.bus = bf.createBus(this.getBusCfg());
                if (this.locationURI != null && this.locationURI.startsWith("/")) {
                    BusFactory.setDefaultBus((Bus)this.bus);
                }
            }
            return this.bus;
        }
        this.bus = ((CxfBcComponent)this.getServiceUnit().getComponent()).getBus();
        return this.bus;
    }

    private boolean isComponentBus() {
        return this.getBus() == ((CxfBcComponent)this.getServiceUnit().getComponent()).getBus();
    }

    public void setLocationURI(String locationURI) {
        this.locationURI = locationURI;
    }

    public String getLocationURI() {
        return this.locationURI;
    }

    private static Element toElement(Source src) throws Fault {
        try {
            SourceTransformer transformer = new SourceTransformer();
            Element ret = transformer.toDOMElement(src);
            ret = CxfBcConsumer.removeEmptyDefaultTns(ret);
            return ret;
        }
        catch (Exception e) {
            throw new Fault((Throwable)e);
        }
    }

    private static Element removeEmptyDefaultTns(Element ret) {
        if (ret.hasAttribute("xmlns") && ret.getAttribute("xmlns").length() == 0) {
            ret.removeAttribute("xmlns");
        }
        NodeList nodes = ret.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            if (!(nodes.item(i) instanceof Element)) continue;
            Element ele = (Element)nodes.item(i);
            Element element = CxfBcConsumer.removeEmptyDefaultTns(ele);
        }
        return ret;
    }

    public void setBusCfg(String busCfg) {
        this.busCfg = busCfg;
    }

    public String getBusCfg() {
        return this.busCfg;
    }

    public void setMtomEnabled(boolean mtomEnabled) {
        this.mtomEnabled = mtomEnabled;
    }

    public boolean isMtomEnabled() {
        return this.mtomEnabled;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setUseJBIWrapper(boolean useJBIWrapper) {
        this.useJBIWrapper = useJBIWrapper;
    }

    public boolean isUseJBIWrapper() {
        return this.useJBIWrapper;
    }

    public void setUseSOAPEnvelope(boolean useSOAPEnvelope) {
        this.useSOAPEnvelope = useSOAPEnvelope;
    }

    public boolean isUseSOAPEnvelope() {
        return this.useSOAPEnvelope;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setFeatures(List<AbstractFeature> features) {
        this.features = features;
    }

    public List<AbstractFeature> getFeatures() {
        return this.features;
    }

    public void setX509(boolean x509) {
        this.x509 = x509;
    }

    public boolean isX509() {
        return this.x509;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class JbiPostInvokerInterceptor
    extends AbstractPhaseInterceptor<Message> {
        public JbiPostInvokerInterceptor() {
            super("post-invoke");
            this.addBefore(OutgoingChainInterceptor.class.getName());
        }

        public void handleMessage(Message message) throws Fault {
            MessageExchange exchange = (MessageExchange)message.getContent(MessageExchange.class);
            Exchange ex = message.getExchange();
            if (exchange.getStatus() == ExchangeStatus.ERROR) {
                throw new Fault((Throwable)exchange.getError());
            }
            if (!ex.isOneWay()) {
                if (exchange.getFault() != null) {
                    JbiFault f = null;
                    if (CxfBcConsumer.this.isUseJBIWrapper()) {
                        f = new JbiFault(new org.apache.cxf.common.i18n.Message("Fault occured", (ResourceBundle)null, new Object[0]));
                        if (exchange.getProperty("faultstring") != null) {
                            f.setMessage((String)exchange.getProperty("faultstring"));
                        }
                        if (exchange.getProperty("faultcode") != null) {
                            f.setFaultCode((QName)exchange.getProperty("faultcode"));
                        }
                        if (exchange.getProperty("hasdetail") == null) {
                            Element details = CxfBcConsumer.toElement(exchange.getFault().getContent());
                            f.setDetail(details);
                        }
                    } else {
                        Element details = CxfBcConsumer.toElement(exchange.getFault().getContent());
                        if (CxfBcConsumer.this.isUseSOAPEnvelope()) {
                            details = (Element)details.getElementsByTagNameNS(details.getNamespaceURI(), "Body").item(0);
                            assert (details != null);
                            details = (Element)details.getElementsByTagNameNS(details.getNamespaceURI(), "Fault").item(0);
                        }
                        assert (details != null);
                        if (exchange.getProperty("faultstring") != null) {
                            details = (Element)details.getElementsByTagName("faultstring").item(0);
                        } else {
                            Element element = details = (Element)details.getElementsByTagName("detail").item(0) == null ? (Element)details.getElementsByTagName("soap:Detail").item(0) : (Element)details.getElementsByTagName("detail").item(0);
                        }
                        assert (details != null);
                        f = new SoapFault(new org.apache.cxf.common.i18n.Message("Fault occured", (ResourceBundle)null, new Object[0]), new QName(details.getNamespaceURI(), "detail"));
                        f.setDetail(details);
                        if (exchange.getProperty("faultstring") != null) {
                            f.setMessage((String)exchange.getProperty("faultstring"));
                        }
                    }
                    this.processFaultDetail(f, message);
                    message.put(BindingFaultInfo.class, (Object)CxfBcConsumer.this.faultWanted);
                    throw f;
                }
                if (exchange.getMessage("out") != null) {
                    Endpoint endpoint = (Endpoint)ex.get(Endpoint.class);
                    Message outMessage = ex.getOutMessage();
                    if (outMessage == null) {
                        outMessage = endpoint.getBinding().createMessage();
                        ex.setOutMessage(outMessage);
                    }
                    NormalizedMessage norMessage = exchange.getMessage("out");
                    if (outMessage instanceof SoapMessage) {
                        AddressingProperties addressingProperties = WSAUtils.getCXFAddressingPropertiesFromMap((Map)norMessage.getProperty("javax.xml.ws.addressing.context.outbound"));
                        outMessage.put((Object)"javax.xml.ws.addressing.context.outbound", (Object)addressingProperties);
                    }
                    ArrayList<AttachmentImpl> attachmentList = new ArrayList<AttachmentImpl>();
                    outMessage.setContent(Source.class, (Object)exchange.getMessage("out").getContent());
                    Set attachmentNames = norMessage.getAttachmentNames();
                    for (String id : attachmentNames) {
                        DataHandler dh = norMessage.getAttachment(id);
                        attachmentList.add(new AttachmentImpl(id, dh));
                    }
                    outMessage.setAttachments(attachmentList);
                }
            }
        }

        public void handleFault(Message message) {
            if (CxfBcConsumer.this.transactionEnabled) {
                Exchange ex = message.getExchange();
                BindingOperationInfo boi = (BindingOperationInfo)ex.get(BindingOperationInfo.class);
                for (BindingFaultInfo bfi : boi.getFaults()) {
                    Fault fault;
                    Element detail;
                    FaultInfo fi = bfi.getFaultInfo();
                    MessagePartInfo mpi = (MessagePartInfo)fi.getMessageParts().get(0);
                    if (mpi == null || (detail = (fault = (Fault)((Object)message.getContent(Exception.class))).getDetail()) == null || !detail.getFirstChild().getLocalName().equals(mpi.getName().getLocalPart())) continue;
                    return;
                }
                throw new Error("rollback");
            }
        }

        protected void processFaultDetail(Fault fault, Message msg) {
            if (fault.getDetail() == null) {
                return;
            }
            Element exDetail = (Element)DOMUtils.getChild((Node)fault.getDetail(), (int)1);
            if (exDetail == null) {
                return;
            }
            QName qname = new QName(exDetail.getNamespaceURI(), exDetail.getLocalName());
            CxfBcConsumer.this.faultWanted = null;
            BindingOperationInfo boi = (BindingOperationInfo)msg.getExchange().get(BindingOperationInfo.class);
            if (boi.isUnwrapped()) {
                boi = boi.getWrappedOperation();
            }
            for (BindingFaultInfo bfi : boi.getFaults()) {
                for (MessagePartInfo mpi : bfi.getFaultInfo().getMessageParts()) {
                    if (!qname.equals(mpi.getConcreteName())) continue;
                    CxfBcConsumer.this.faultWanted = bfi;
                    msg.put(BindingFaultInfo.class, (Object)CxfBcConsumer.this.faultWanted);
                    break;
                }
                if (CxfBcConsumer.this.faultWanted == null) continue;
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class JbiInvokerInterceptor
    extends AbstractPhaseInterceptor<Message> {
        public JbiInvokerInterceptor() {
            super("invoke");
        }

        private Object getInvokee(Message message) {
            Object invokee = message.getContent(List.class);
            if (invokee == null) {
                invokee = message.getContent(Object.class);
            }
            return invokee;
        }

        private void copyJaxwsProperties(Message inMsg, Message outMsg) {
            outMsg.put((Object)"javax.xml.ws.wsdl.operation", inMsg.get((Object)"javax.xml.ws.wsdl.operation"));
            outMsg.put((Object)"javax.xml.ws.wsdl.service", inMsg.get((Object)"javax.xml.ws.wsdl.service"));
            outMsg.put((Object)"javax.xml.ws.wsdl.interface", inMsg.get((Object)"javax.xml.ws.wsdl.interface"));
            outMsg.put((Object)"javax.xml.ws.wsdl.port", inMsg.get((Object)"javax.xml.ws.wsdl.port"));
            outMsg.put((Object)"javax.xml.ws.wsdl.description", inMsg.get((Object)"javax.xml.ws.wsdl.description"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message message) throws Fault {
            block23: {
                Exchange cxfExchange = message.getExchange();
                Endpoint endpoint = (Endpoint)cxfExchange.get(Endpoint.class);
                Service service = endpoint.getService();
                Invoker invoker = service.getInvoker();
                if (invoker instanceof Servant) {
                    Exchange runableEx = message.getExchange();
                    Object result = invoker.invoke(runableEx, this.getInvokee(message));
                    if (!cxfExchange.isOneWay()) {
                        Endpoint end = (Endpoint)cxfExchange.get(Endpoint.class);
                        Message outMessage = runableEx.getOutMessage();
                        if (outMessage == null) {
                            outMessage = end.getBinding().createMessage();
                            cxfExchange.setOutMessage(outMessage);
                        }
                        this.copyJaxwsProperties(message, outMessage);
                        if (result != null) {
                            MessageContentsList resList = null;
                            if (result instanceof MessageContentsList) {
                                resList = (MessageContentsList)result;
                            } else if (result instanceof List) {
                                resList = new MessageContentsList((List)result);
                            } else if (result.getClass().isArray()) {
                                resList = new MessageContentsList((Object[])result);
                            } else {
                                outMessage.setContent(Object.class, result);
                            }
                            if (resList != null) {
                                outMessage.setContent(List.class, (Object)resList);
                            }
                        }
                    }
                    return;
                }
                MessageExchange exchange = (MessageExchange)message.getContent(MessageExchange.class);
                ComponentContext context = (ComponentContext)message.getExchange().get(ComponentContext.class);
                CxfBcConsumer.this.configureExchangeTarget(exchange);
                CxfBcConsumer.this.isOneway = ((BindingOperationInfo)message.getExchange().get(BindingOperationInfo.class)).getOperationInfo().isOneWay();
                message.getExchange().setOneWay(CxfBcConsumer.this.isOneway);
                try {
                    if (CxfBcConsumer.this.isOneway) {
                        CxfBcConsumer.this.messages.put(exchange.getExchangeId(), message);
                        context.getDeliveryChannel().send(exchange);
                        break block23;
                    }
                    if (CxfBcConsumer.this.isSynchronous() && !CxfBcConsumer.this.isOneway) {
                        CxfBcConsumer.this.messages.put(exchange.getExchangeId(), message);
                        context.getDeliveryChannel().sendSync(exchange, CxfBcConsumer.this.timeout * 1000L);
                        CxfBcConsumer.this.process(exchange);
                        break block23;
                    }
                    Continuation end = ((ContinuationProvider)message.get((Object)ContinuationProvider.class.getName())).getContinuation();
                    synchronized (end) {
                        ContinuationProvider continuationProvider = (ContinuationProvider)message.get((Object)ContinuationProvider.class.getName());
                        Continuation continuation = continuationProvider.getContinuation();
                        if (!continuation.isPending()) {
                            CxfBcConsumer.this.messages.put(exchange.getExchangeId(), message);
                            context.getDeliveryChannel().send(exchange);
                            if (!CxfBcConsumer.this.isSTFlow) {
                                continuation.suspend(CxfBcConsumer.this.timeout * 1000L);
                            }
                        } else if (!continuation.isResumed()) {
                            CxfBcConsumer.this.messages.remove(exchange.getExchangeId());
                            throw new Exception("Exchange timed out: " + exchange.getExchangeId());
                        }
                    }
                }
                catch (SuspendedInvocationException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new Fault((Throwable)e);
                }
            }
        }
    }

    protected class JbiChainInitiationObserver
    extends ChainInitiationObserver {
        public JbiChainInitiationObserver(Endpoint endpoint, Bus bus) {
            super(endpoint, bus);
        }

        protected void setExchangeProperties(Exchange exchange, Message m) {
            super.setExchangeProperties(exchange, m);
            exchange.put(ComponentContext.class, (Object)CxfBcConsumer.this.getContext());
            exchange.put(CxfBcConsumer.class, (Object)CxfBcConsumer.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(Message m) {
            m.put((Object)"suClassloader", (Object)CxfBcConsumer.this.suClassLoader);
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            if (oldCl != CxfBcConsumer.this.suClassLoader) {
                try {
                    Thread.currentThread().setContextClassLoader(CxfBcConsumer.this.suClassLoader);
                    super.onMessage(m);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldCl);
                }
            } else {
                super.onMessage(m);
            }
        }
    }
}

