/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxfbc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOptionalOut;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Source;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.MustUnderstandInterceptor;
import org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.AttachmentInInterceptor;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.interceptor.StaxInInterceptor;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseChainCache;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.phase.PhaseManager;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.transport.MessageObserver;
import org.apache.servicemix.cxfbc.CxfBcProvider;
import org.apache.servicemix.cxfbc.interceptors.JbiInWsdl1Interceptor;
import org.apache.servicemix.cxfbc.interceptors.SchemaValidationInInterceptor;

public class CxfBcProviderMessageObserver
implements MessageObserver {
    ByteArrayOutputStream response = new ByteArrayOutputStream();
    boolean written;
    String contentType;
    private CxfBcProvider providerEndpoint;

    public CxfBcProviderMessageObserver(CxfBcProvider providerEndpoint) {
        this.providerEndpoint = providerEndpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayOutputStream getResponseStream() throws Exception {
        CxfBcProviderMessageObserver cxfBcProviderMessageObserver = this;
        synchronized (cxfBcProviderMessageObserver) {
            if (!this.written) {
                this.wait(1000000000L);
            }
        }
        return this.response;
    }

    public String getResponseContentType() {
        return this.contentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        try {
            boolean txSync;
            NormalizedMessage msg;
            MessageObserver messageObserver;
            Object messageExchange = (MessageExchange)message.getExchange().get(MessageExchange.class);
            if (messageExchange == null && (messageObserver = (MessageObserver)message.getExchange().get(MessageObserver.class)) != null) {
                messageObserver.onMessage(message);
                return;
            }
            if (messageExchange != null && messageExchange.getStatus() != ExchangeStatus.ACTIVE) {
                return;
            }
            this.contentType = (String)message.get((Object)"Content-Type");
            SoapMessage soapMessage = (SoapMessage)this.providerEndpoint.getCxfEndpoint().getBinding().createMessage(message);
            soapMessage.put("org.apache.cxf.client", (Object)true);
            PhaseChainCache inboundChainCache = new PhaseChainCache();
            PhaseManager pm = (PhaseManager)this.providerEndpoint.getBus().getExtension(PhaseManager.class);
            ArrayList<Object> inList = new ArrayList<Object>();
            inList.add(new ReadHeadersInterceptor(this.providerEndpoint.getBus()));
            inList.add(new MustUnderstandInterceptor());
            inList.add(new StaxInInterceptor());
            inList.add((Object)new JbiInWsdl1Interceptor(this.providerEndpoint.isUseJBIWrapper(), this.providerEndpoint.isUseSOAPEnvelope()));
            if (this.providerEndpoint.isSchemaValidationEnabled()) {
                inList.add((Object)new SchemaValidationInInterceptor(this.providerEndpoint.isUseJBIWrapper(), this.providerEndpoint.isUseSOAPEnvelope()));
            }
            inList.add(new AttachmentInInterceptor());
            PhaseInterceptorChain inChain = inboundChainCache.get(pm.getInPhases(), inList);
            inChain.add(this.providerEndpoint.getInInterceptors());
            soapMessage.setInterceptorChain((InterceptorChain)inChain);
            inChain.doIntercept((Message)soapMessage);
            this.closeConnectionStream(soapMessage);
            if (soapMessage.getContent(Exception.class) != null || soapMessage.getContent(Source.class) == null) {
                Exception ex = (Exception)soapMessage.getContent(Exception.class);
                if (!(soapMessage.getExchange().get(MessageExchange.class) instanceof InOnly) && ex != null) {
                    messageExchange.setStatus(ExchangeStatus.ERROR);
                    messageExchange.setError(ex);
                    this.providerEndpoint.getContext().getDeliveryChannel().send(messageExchange);
                }
                return;
            }
            messageExchange = (MessageExchange)soapMessage.getExchange().get(MessageExchange.class);
            if (((BindingOperationInfo)soapMessage.getExchange().get(BindingOperationInfo.class)).getOperationInfo().isOneWay()) {
                messageExchange.setStatus(ExchangeStatus.DONE);
            } else if (soapMessage.get((Object)"jbiFault") != null && soapMessage.get((Object)"jbiFault").equals(true)) {
                Fault fault = messageExchange.createFault();
                fault.setContent((Source)soapMessage.getContent(Source.class));
                messageExchange.setFault(fault);
                if (soapMessage.get((Object)"faultstring") != null) {
                    messageExchange.setProperty("faultstring", soapMessage.get((Object)"faultstring"));
                }
                if (soapMessage.get((Object)"faultcode") != null) {
                    messageExchange.setProperty("faultcode", soapMessage.get((Object)"faultcode"));
                }
                if (soapMessage.get((Object)"hasdetail") != null) {
                    messageExchange.setProperty("hasdetail", soapMessage.get((Object)"hasdetail"));
                }
            } else if (messageExchange instanceof InOut) {
                msg = messageExchange.createMessage();
                msg.setContent((Source)soapMessage.getContent(Source.class));
                this.toNMSAttachments(msg, (Message)soapMessage);
                messageExchange.setMessage(msg, "out");
            } else if (messageExchange instanceof InOptionalOut) {
                if (soapMessage.getContent(Source.class) != null) {
                    msg = messageExchange.createMessage();
                    msg.setContent((Source)soapMessage.getContent(Source.class));
                    this.toNMSAttachments(msg, (Message)soapMessage);
                    messageExchange.setMessage(msg, "out");
                } else {
                    messageExchange.setStatus(ExchangeStatus.DONE);
                }
            } else {
                messageExchange.setStatus(ExchangeStatus.DONE);
            }
            boolean bl = txSync = messageExchange.getStatus() == ExchangeStatus.ACTIVE && messageExchange.isTransacted() && Boolean.TRUE.equals(messageExchange.getProperty("javax.jbi.messaging.sendSync"));
            if (txSync) {
                this.providerEndpoint.getContext().getDeliveryChannel().sendSync(messageExchange);
            } else {
                this.providerEndpoint.getContext().getDeliveryChannel().send(messageExchange);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            CxfBcProviderMessageObserver cxfBcProviderMessageObserver = this;
            synchronized (cxfBcProviderMessageObserver) {
                this.written = true;
                this.notifyAll();
            }
        }
    }

    private void closeConnectionStream(SoapMessage soapMessage) throws IOException {
        InputStream is = (InputStream)soapMessage.getContent(InputStream.class);
        if (is != null) {
            CachedOutputStream bos = new CachedOutputStream();
            IOUtils.copy((InputStream)is, (OutputStream)bos);
            bos.flush();
            is.close();
            soapMessage.setContent(InputStream.class, (Object)bos.getInputStream());
            bos.close();
        }
    }

    private void toNMSAttachments(NormalizedMessage normalizedMessage, Message soapMessage) throws MessagingException {
        if (soapMessage.getAttachments() != null) {
            for (Attachment att : soapMessage.getAttachments()) {
                normalizedMessage.addAttachment(att.getId(), att.getDataHandler());
            }
        }
    }
}

