/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxfbc.interceptors;

import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Vector;
import javax.security.auth.Subject;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.servicemix.common.security.AuthenticationService;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.apache.ws.security.handler.WSHandlerResult;

public class JbiJAASInterceptor
extends AbstractWSS4JInterceptor {
    private String domain = "servicemix-domain";
    private AuthenticationService authenticationService;
    private ThreadLocal<Subject> currentSubject = new ThreadLocal();
    private boolean x509;

    public JbiJAASInterceptor(AuthenticationService authenticationService, boolean x509) {
        this.setPhase("pre-protocol");
        this.getAfter().add(WSS4JInInterceptor.class.getName());
        this.authenticationService = authenticationService;
        this.x509 = x509;
    }

    public void handleMessage(SoapMessage message) throws Fault {
        try {
            Vector results;
            Subject subject = this.currentSubject.get();
            if (subject == null) {
                subject = new Subject();
                this.currentSubject.set(subject);
            }
            if ((results = (Vector)message.get((Object)"RECV_RESULTS")) == null) {
                return;
            }
            for (WSHandlerResult hr : results) {
                if (hr == null || hr.getResults() == null) {
                    return;
                }
                boolean authenticated = false;
                for (WSSecurityEngineResult er : hr.getResults()) {
                    if (er == null || !(er.getPrincipal() instanceof WSUsernameTokenPrincipal)) continue;
                    WSUsernameTokenPrincipal p = (WSUsernameTokenPrincipal)er.getPrincipal();
                    subject.getPrincipals().add((Principal)p);
                    this.authenticationService.authenticate(subject, this.domain, p.getName(), (Object)p.getPassword());
                    authenticated = true;
                }
                if (authenticated || !this.x509) continue;
                for (WSSecurityEngineResult er : hr.getResults()) {
                    if (er == null || !(er.getCertificate() instanceof X509Certificate)) continue;
                    X509Certificate cert = er.getCertificate();
                    this.authenticationService.authenticate(subject, this.domain, cert.getIssuerX500Principal().getName(), (Object)cert);
                }
            }
            message.put(Subject.class, (Object)subject);
        }
        catch (GeneralSecurityException e) {
            throw new Fault((Throwable)e);
        }
        finally {
            this.currentSubject.set(null);
        }
    }
}

