/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.RPCInInterceptor;
import org.apache.cxf.binding.soap.model.SoapHeaderInfo;
import org.apache.cxf.headers.Header;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.BareInInterceptor;
import org.apache.cxf.interceptor.DocLiteralInInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.W3CDOMStreamReader;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SoapHeaderInterceptor
extends AbstractInDatabindingInterceptor {
    public SoapHeaderInterceptor() {
        super("unmarshal");
        this.addAfter(BareInInterceptor.class.getName());
        this.addAfter(RPCInInterceptor.class.getName());
        this.addAfter(DocLiteralInInterceptor.class.getName());
    }

    public void handleMessage(Message m) throws Fault {
        boolean client;
        BindingMessageInfo bmi;
        BindingOperationInfo bop;
        SoapMessage message = (SoapMessage)m;
        Exchange exchange = message.getExchange();
        MessageContentsList parameters = MessageContentsList.getContentsList((Message)message);
        if (null == parameters) {
            parameters = new MessageContentsList();
        }
        if (null == (bop = (BindingOperationInfo)exchange.get(BindingOperationInfo.class))) {
            return;
        }
        if (bop.isUnwrapped()) {
            bop = bop.getWrappedOperation();
        }
        BindingMessageInfo bindingMessageInfo = bmi = (client = this.isRequestor((Message)message)) ? bop.getOutput() : bop.getInput();
        if (bmi == null) {
            return;
        }
        List headers = bmi.getExtensors(SoapHeaderInfo.class);
        if (headers == null || headers.size() == 0) {
            return;
        }
        boolean supportsNode = this.supportsDataReader((Message)message, Node.class);
        for (SoapHeaderInfo header : headers) {
            MessagePartInfo mpi = header.getPart();
            if (mpi.getTypeClass() == null) continue;
            Header param = this.findHeader(message, mpi);
            Object object = null;
            if (param != null) {
                message.getHeaders().remove(param);
                if (param.getDataBinding() == null) {
                    Node source = (Node)param.getObject();
                    if (supportsNode) {
                        object = this.getNodeDataReader((Message)message).read(mpi, (Object)source);
                    } else {
                        W3CDOMStreamReader reader = new W3CDOMStreamReader((Element)source);
                        try {
                            reader.nextTag();
                        }
                        catch (XMLStreamException e) {
                            // empty catch block
                        }
                        object = this.getDataReader((Message)message, XMLStreamReader.class).read(mpi, (Object)reader);
                    }
                } else {
                    object = param.getObject();
                }
            }
            parameters.put(mpi, object);
        }
        if (parameters.size() > 0) {
            message.setContent(List.class, parameters);
        }
    }

    private Header findHeader(SoapMessage message, MessagePartInfo mpi) {
        return message.getHeader(mpi.getConcreteName());
    }
}

