/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.endpoint;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.ServiceContractResolver;
import org.apache.cxf.endpoint.ServiceContractResolverRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceContractResolverRegistryImpl
implements ServiceContractResolverRegistry {
    private Bus bus;
    private List<ServiceContractResolver> resolvers;

    @PostConstruct
    public void init() {
        this.resolvers = new ArrayList<ServiceContractResolver>();
        if (this.bus != null) {
            this.bus.setExtension((Object)this, ServiceContractResolverRegistry.class);
        }
    }

    public URI getContractLocation(QName qname) {
        for (ServiceContractResolver resolver : this.resolvers) {
            URI contractLocation = resolver.getContractLocation(qname);
            if (null == contractLocation) continue;
            return contractLocation;
        }
        return null;
    }

    public boolean isRegistered(ServiceContractResolver resolver) {
        return this.resolvers.contains(resolver);
    }

    public synchronized void register(ServiceContractResolver resolver) {
        this.resolvers.add(resolver);
    }

    public synchronized void unregister(ServiceContractResolver resolver) {
        this.resolvers.remove(resolver);
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    protected List<ServiceContractResolver> getResolvers() {
        return this.resolvers;
    }
}

