/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.util.Collection;
import java.util.SortedSet;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.AbstractFaultChainInitiatorObserver;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.Phase;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.phase.PhaseManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutFaultChainInitiatorObserver
extends AbstractFaultChainInitiatorObserver {
    public OutFaultChainInitiatorObserver(Bus bus) {
        super(bus);
    }

    @Override
    protected void initializeInterceptors(Exchange ex, PhaseInterceptorChain chain) {
        Endpoint e = (Endpoint)ex.get(Endpoint.class);
        Client c = (Client)ex.get(Client.class);
        chain.add((Collection)this.getBus().getOutFaultInterceptors());
        if (c != null) {
            chain.add((Collection)c.getOutFaultInterceptors());
        }
        chain.add((Collection)e.getService().getOutFaultInterceptors());
        chain.add((Collection)e.getOutFaultInterceptors());
        chain.add((Collection)e.getBinding().getOutFaultInterceptors());
        if (e.getService().getDataBinding() instanceof InterceptorProvider) {
            chain.add((Collection)((InterceptorProvider)e.getService().getDataBinding()).getOutFaultInterceptors());
        }
        this.addToChain(chain, ex.getInMessage());
        this.addToChain(chain, ex.getOutFaultMessage());
    }

    private void addToChain(PhaseInterceptorChain chain, Message m) {
        Collection is;
        Collection providers = CastUtils.cast((Collection)((Collection)m.get((Object)Message.INTERCEPTOR_PROVIDERS)));
        if (providers != null) {
            for (InterceptorProvider p : providers) {
                chain.add((Collection)p.getOutFaultInterceptors());
            }
        }
        if ((is = CastUtils.cast((Collection)((Collection)m.get((Object)Message.FAULT_OUT_INTERCEPTORS)))) != null) {
            chain.add(is);
        }
        if (m.getDestination() instanceof InterceptorProvider) {
            chain.add((Collection)((InterceptorProvider)m.getDestination()).getOutFaultInterceptors());
        }
    }

    @Override
    protected SortedSet<Phase> getPhases() {
        return ((PhaseManager)this.getBus().getExtension(PhaseManager.class)).getOutPhases();
    }

    @Override
    protected boolean isOutboundObserver() {
        return true;
    }
}

