/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.staxutils;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.Location;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.StreamWriterContentHandler;
import org.apache.cxf.staxutils.W3CDOMStreamReader;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public final class StaxUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(StaxUtils.class);
    private static final BlockingQueue<XMLInputFactory> NS_AWARE_INPUT_FACTORY_POOL;
    private static final BlockingQueue<XMLOutputFactory> OUTPUT_FACTORY_POOL;
    private static final String XML_NS = "http://www.w3.org/2000/xmlns/";
    private static final String[] DEF_PREFIXES;

    private StaxUtils() {
    }

    public static boolean isWoodstox() {
        try {
            ClassLoaderUtils.loadClass("org.codehaus.stax2.XMLStreamReader2", StaxUtils.class);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    private static XMLInputFactory getXMLInputFactory() {
        XMLInputFactory f = (XMLInputFactory)NS_AWARE_INPUT_FACTORY_POOL.poll();
        if (f == null) {
            f = XMLInputFactory.newInstance();
            f.setProperty("javax.xml.stream.isNamespaceAware", true);
        }
        return f;
    }

    private static void returnXMLInputFactory(XMLInputFactory factory) {
        NS_AWARE_INPUT_FACTORY_POOL.offer(factory);
    }

    private static XMLOutputFactory getXMLOutputFactory() {
        XMLOutputFactory f = (XMLOutputFactory)OUTPUT_FACTORY_POOL.poll();
        if (f == null) {
            f = XMLOutputFactory.newInstance();
        }
        return f;
    }

    private static void returnXMLOutputFactory(XMLOutputFactory factory) {
        OUTPUT_FACTORY_POOL.offer(factory);
    }

    public static XMLInputFactory createXMLInputFactory(boolean nsAware) {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isNamespaceAware", nsAware);
        return factory;
    }

    public static XMLStreamWriter createXMLStreamWriter(Writer out) {
        XMLOutputFactory factory = StaxUtils.getXMLOutputFactory();
        try {
            XMLStreamWriter xMLStreamWriter = factory.createXMLStreamWriter(out);
            return xMLStreamWriter;
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Cant' create XMLStreamWriter", e);
        }
        finally {
            StaxUtils.returnXMLOutputFactory(factory);
        }
    }

    public static XMLStreamWriter createXMLStreamWriter(OutputStream out) {
        return StaxUtils.createXMLStreamWriter(out, null);
    }

    public static XMLStreamWriter createXMLStreamWriter(OutputStream out, String encoding) {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        XMLOutputFactory factory = StaxUtils.getXMLOutputFactory();
        try {
            XMLStreamWriter xMLStreamWriter = factory.createXMLStreamWriter(out, encoding);
            return xMLStreamWriter;
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Cant' create XMLStreamWriter", e);
        }
        finally {
            StaxUtils.returnXMLOutputFactory(factory);
        }
    }

    public static XMLStreamWriter createXMLStreamWriter(Result r) {
        XMLOutputFactory factory = StaxUtils.getXMLOutputFactory();
        try {
            XMLStreamWriter xMLStreamWriter = factory.createXMLStreamWriter(r);
            return xMLStreamWriter;
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Cant' create XMLStreamWriter", e);
        }
        finally {
            StaxUtils.returnXMLOutputFactory(factory);
        }
    }

    public static XMLStreamReader createFilteredReader(XMLStreamReader reader, StreamFilter filter) {
        XMLInputFactory factory = StaxUtils.getXMLInputFactory();
        try {
            XMLStreamReader xMLStreamReader = factory.createFilteredReader(reader, filter);
            return xMLStreamReader;
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Cant' create XMLStreamReader", e);
        }
        finally {
            StaxUtils.returnXMLInputFactory(factory);
        }
    }

    public static void nextEvent(XMLStreamReader dr) {
        try {
            dr.next();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Couldn't parse stream.", e);
        }
    }

    public static boolean toNextText(DepthXMLStreamReader reader) {
        if (reader.getEventType() == 4) {
            return true;
        }
        try {
            int depth = reader.getDepth();
            int event = reader.getEventType();
            while (reader.getDepth() >= depth && reader.hasNext()) {
                if (event == 4 && reader.getDepth() == depth + 1) {
                    return true;
                }
                event = reader.next();
            }
            return false;
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Couldn't parse stream.", e);
        }
    }

    public static boolean toNextTag(XMLStreamReader reader) {
        try {
            int x = reader.getEventType();
            while (x != 1 && x != 2 && reader.hasNext()) {
                x = reader.next();
            }
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Couldn't parse stream.", e);
        }
        return true;
    }

    public static boolean toNextTag(DepthXMLStreamReader reader, QName endTag) {
        try {
            int depth = reader.getDepth();
            int event = reader.getEventType();
            while (reader.getDepth() >= depth && reader.hasNext()) {
                if (event == 1 && reader.getName().equals(endTag) && reader.getDepth() == depth + 1) {
                    return true;
                }
                event = reader.next();
            }
            return false;
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Couldn't parse stream.", e);
        }
    }

    public static void writeStartElement(XMLStreamWriter writer, String prefix, String name, String namespace) throws XMLStreamException {
        if (prefix == null) {
            prefix = "";
        }
        if (namespace.length() > 0) {
            writer.writeStartElement(prefix, name, namespace);
            if (prefix.length() > 0) {
                writer.writeNamespace(prefix, namespace);
            } else {
                writer.writeDefaultNamespace(namespace);
            }
        } else {
            writer.writeStartElement(name);
            writer.writeDefaultNamespace("");
        }
    }

    public static boolean skipToStartOfElement(XMLStreamReader in) throws XMLStreamException {
        int code = in.getEventType();
        while (code != 8) {
            if (code == 1) {
                return true;
            }
            code = in.next();
        }
        return false;
    }

    public static boolean toNextElement(DepthXMLStreamReader dr) {
        if (dr.getEventType() == 1) {
            return true;
        }
        if (dr.getEventType() == 2) {
            return false;
        }
        try {
            int depth = dr.getDepth();
            int event = dr.getEventType();
            while (dr.getDepth() >= depth && dr.hasNext()) {
                if (event == 1 && dr.getDepth() == depth + 1) {
                    return true;
                }
                if (event == 2) {
                    --depth;
                }
                event = dr.next();
            }
            return false;
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Couldn't parse stream.", e);
        }
    }

    public static boolean skipToStartOfElement(DepthXMLStreamReader in) throws XMLStreamException {
        int code = in.getEventType();
        while (code != 8) {
            if (code == 1) {
                return true;
            }
            code = in.next();
        }
        return false;
    }

    public static void copy(Source source, XMLStreamWriter writer) throws XMLStreamException {
        InputSource src;
        if (source instanceof SAXSource && (src = ((SAXSource)source).getInputSource()).getSystemId() == null && src.getPublicId() == null && ((SAXSource)source).getXMLReader() != null) {
            StreamWriterContentHandler ch = new StreamWriterContentHandler(writer);
            XMLReader reader = ((SAXSource)source).getXMLReader();
            reader.setContentHandler(ch);
            try {
                try {
                    reader.setFeature("http://xml.org/sax/features/namespaces", true);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                reader.parse(((SAXSource)source).getInputSource());
                return;
            }
            catch (Exception e) {
                throw new XMLStreamException(e);
            }
        }
        XMLStreamReader reader = StaxUtils.createXMLStreamReader(source);
        StaxUtils.copy(reader, writer);
        reader.close();
    }

    public static Document copy(Document doc) throws XMLStreamException, ParserConfigurationException {
        XMLStreamReader reader = StaxUtils.createXMLStreamReader(doc);
        W3CDOMStreamWriter writer = new W3CDOMStreamWriter();
        StaxUtils.copy(reader, (XMLStreamWriter)writer);
        Document d = writer.getDocument();
        try {
            d.setDocumentURI(doc.getDocumentURI());
        }
        catch (Exception ex) {
            // empty catch block
        }
        return d;
    }

    public static void copy(Document doc, XMLStreamWriter writer) throws XMLStreamException {
        XMLStreamReader reader = StaxUtils.createXMLStreamReader(doc);
        StaxUtils.copy(reader, writer);
    }

    public static void copy(Element node, XMLStreamWriter writer) throws XMLStreamException {
        XMLStreamReader reader = StaxUtils.createXMLStreamReader(node);
        StaxUtils.copy(reader, writer);
    }

    public static void copy(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        StaxUtils.copy(reader, writer, false);
    }

    public static void copy(XMLStreamReader reader, XMLStreamWriter writer, boolean fragment) throws XMLStreamException {
        int read = 0;
        int event = reader.getEventType();
        while (reader.hasNext()) {
            switch (event) {
                case 1: {
                    ++read;
                    StaxUtils.writeStartElement(reader, writer);
                    break;
                }
                case 2: {
                    writer.writeEndElement();
                    if (--read > 0 || fragment) break;
                    return;
                }
                case 4: {
                    writer.writeCharacters(reader.getText());
                    break;
                }
                case 5: {
                    writer.writeComment(reader.getText());
                    break;
                }
                case 12: {
                    writer.writeCData(reader.getText());
                    break;
                }
                case 7: 
                case 8: 
                case 10: 
                case 13: {
                    break;
                }
            }
            event = reader.next();
        }
    }

    private static void writeStartElement(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        String nsPrefix;
        int i;
        String local = reader.getLocalName();
        String uri = reader.getNamespaceURI();
        String prefix = reader.getPrefix();
        if (prefix == null) {
            prefix = "";
        }
        boolean writeElementNS = false;
        if (uri != null) {
            writeElementNS = true;
            Iterator it = CastUtils.cast(writer.getNamespaceContext().getPrefixes(uri));
            while (it != null && it.hasNext()) {
                String s = (String)it.next();
                if (s == null) {
                    s = "";
                }
                if (!s.equals(prefix)) continue;
                writeElementNS = false;
            }
        }
        if (uri != null) {
            if (prefix.length() == 0 && StringUtils.isEmpty(uri)) {
                writer.writeStartElement(local);
                writer.setDefaultNamespace(uri);
            } else {
                writer.writeStartElement(prefix, local, uri);
                writer.setPrefix(prefix, uri);
            }
        } else {
            writer.writeStartElement(local);
        }
        for (i = 0; i < reader.getNamespaceCount(); ++i) {
            String nsURI = reader.getNamespaceURI(i);
            nsPrefix = reader.getNamespacePrefix(i);
            if (nsPrefix == null) {
                nsPrefix = "";
            }
            if (nsPrefix.length() == 0) {
                writer.writeDefaultNamespace(nsURI);
            } else {
                writer.writeNamespace(nsPrefix, nsURI);
            }
            if (!nsURI.equals(uri) || !nsPrefix.equals(prefix)) continue;
            writeElementNS = false;
        }
        if (writeElementNS) {
            if (prefix == null || prefix.length() == 0) {
                writer.writeDefaultNamespace(uri);
            } else {
                writer.writeNamespace(prefix, uri);
            }
        }
        for (i = 0; i < reader.getAttributeCount(); ++i) {
            String ns = reader.getAttributeNamespace(i);
            nsPrefix = reader.getAttributePrefix(i);
            if (ns == null || ns.length() == 0) {
                writer.writeAttribute(reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                continue;
            }
            if (nsPrefix == null || nsPrefix.length() == 0) {
                writer.writeAttribute(reader.getAttributeNamespace(i), reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                continue;
            }
            Iterator it = CastUtils.cast(writer.getNamespaceContext().getPrefixes(ns));
            boolean writeNs = true;
            while (it != null && it.hasNext()) {
                String s = (String)it.next();
                if (s == null) {
                    s = "";
                }
                if (!s.equals(nsPrefix)) continue;
                writeNs = false;
            }
            if (writeNs) {
                writer.writeNamespace(nsPrefix, ns);
            }
            writer.writeAttribute(reader.getAttributePrefix(i), reader.getAttributeNamespace(i), reader.getAttributeLocalName(i), reader.getAttributeValue(i));
        }
    }

    public static void writeDocument(Document d, XMLStreamWriter writer, boolean repairing) throws XMLStreamException {
        StaxUtils.writeDocument(d, writer, true, repairing);
    }

    public static void writeDocument(Document d, XMLStreamWriter writer, boolean writeProlog, boolean repairing) throws XMLStreamException {
        if (writeProlog) {
            writer.writeStartDocument();
        }
        for (Node node = d.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!writeProlog && node.getNodeType() != 1) continue;
            StaxUtils.writeNode(node, writer, repairing);
        }
        if (writeProlog) {
            writer.writeEndDocument();
        }
    }

    public static void writeElement(Element e, XMLStreamWriter writer, boolean repairing) throws XMLStreamException {
        StaxUtils.writeElement(e, writer, repairing, true);
    }

    public static void writeElement(Element e, XMLStreamWriter writer, boolean repairing, boolean endElement) throws XMLStreamException {
        boolean declareNamespace;
        String prefix = e.getPrefix();
        String ns = e.getNamespaceURI();
        String localName = e.getLocalName();
        if (prefix == null) {
            prefix = "";
        }
        if (localName == null && (localName = e.getNodeName()) == null) {
            throw new IllegalStateException("Element's local name cannot be null!");
        }
        String decUri = writer.getNamespaceContext().getNamespaceURI(prefix);
        boolean bl = declareNamespace = decUri == null || !decUri.equals(ns);
        if (ns == null || ns.length() == 0) {
            writer.writeStartElement(localName);
            if (StringUtils.isEmpty(decUri)) {
                declareNamespace = false;
            }
        } else {
            writer.writeStartElement(prefix, localName, ns);
        }
        NamedNodeMap attrs = e.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String name = attr.getLocalName();
            String attrPrefix = attr.getPrefix();
            if (attrPrefix == null) {
                attrPrefix = "";
            }
            if (name == null) {
                name = attr.getNodeName();
            }
            if ("xmlns".equals(attrPrefix)) {
                writer.writeNamespace(name, attr.getNodeValue());
                if (!name.equals(prefix) || !attr.getNodeValue().equals(ns)) continue;
                declareNamespace = false;
                continue;
            }
            if ("xmlns".equals(name) && "".equals(attrPrefix)) {
                writer.writeNamespace("", attr.getNodeValue());
                if (attr.getNodeValue().equals(ns)) {
                    declareNamespace = false;
                    continue;
                }
                if (!StringUtils.isEmpty(attr.getNodeValue()) || !StringUtils.isEmpty(ns)) continue;
                declareNamespace = false;
                continue;
            }
            String attns = attr.getNamespaceURI();
            String value = attr.getNodeValue();
            if (attns == null || attns.length() == 0) {
                writer.writeAttribute(name, value);
                continue;
            }
            if (attrPrefix == null || attrPrefix.length() == 0) {
                writer.writeAttribute(attns, name, value);
                continue;
            }
            writer.writeAttribute(attrPrefix, attns, name, value);
        }
        if (declareNamespace && repairing) {
            if (ns == null) {
                writer.writeNamespace(prefix, "");
            } else {
                writer.writeNamespace(prefix, ns);
            }
        }
        for (Node nd = e.getFirstChild(); nd != null; nd = nd.getNextSibling()) {
            StaxUtils.writeNode(nd, writer, repairing);
        }
        if (endElement) {
            writer.writeEndElement();
        }
    }

    public static void writeNode(Node n, XMLStreamWriter writer, boolean repairing) throws XMLStreamException {
        switch (n.getNodeType()) {
            case 1: {
                StaxUtils.writeElement((Element)n, writer, repairing);
                break;
            }
            case 3: {
                writer.writeCharacters(((Text)n).getNodeValue());
                break;
            }
            case 8: {
                writer.writeComment(((Comment)n).getData());
                break;
            }
            case 4: {
                writer.writeCData(((CDATASection)n).getData());
                break;
            }
            case 5: {
                writer.writeEntityRef(((org.w3c.dom.EntityReference)n).getNodeValue());
                break;
            }
            case 7: {
                ProcessingInstruction pi = (ProcessingInstruction)n;
                writer.writeProcessingInstruction(pi.getTarget(), pi.getData());
                break;
            }
            case 9: {
                StaxUtils.writeDocument((Document)n, writer, repairing);
                break;
            }
            case 11: {
                DocumentFragment frag = (DocumentFragment)n;
                for (Node child = frag.getFirstChild(); child != null; child = child.getNextSibling()) {
                    StaxUtils.writeNode(child, writer, repairing);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Found type: " + n.getClass().getName());
            }
        }
    }

    public static Document read(XMLStreamReader reader) throws XMLStreamException {
        return StaxUtils.read(reader, false);
    }

    public static Document read(XMLStreamReader reader, boolean recordLoc) throws XMLStreamException {
        Document doc = DOMUtils.createDocument();
        if (reader.getLocation().getSystemId() != null) {
            try {
                doc.setDocumentURI(new String(reader.getLocation().getSystemId()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        StaxUtils.readDocElements(doc, doc, reader, true, recordLoc);
        return doc;
    }

    public static Document read(DocumentBuilder builder, XMLStreamReader reader, boolean repairing) throws XMLStreamException {
        Document doc = builder.newDocument();
        if (reader.getLocation().getSystemId() != null) {
            try {
                doc.setDocumentURI(new String(reader.getLocation().getSystemId()));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        StaxUtils.readDocElements(doc, reader, repairing);
        return doc;
    }

    private static Document getDocument(Node parent) {
        return parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
    }

    private static Element startElement(Document doc, Node parent, XMLStreamReader reader, boolean repairing, boolean recordLocation) throws XMLStreamException {
        String prefix;
        Element e = doc.createElementNS(reader.getNamespaceURI(), reader.getLocalName());
        if (reader.getPrefix() != null) {
            e.setPrefix(reader.getPrefix());
        }
        e = (Element)parent.appendChild(e);
        recordLocation = StaxUtils.addLocation(doc, e, reader, recordLocation);
        for (int ns = 0; ns < reader.getNamespaceCount(); ++ns) {
            String uri = reader.getNamespaceURI(ns);
            prefix = reader.getNamespacePrefix(ns);
            StaxUtils.declare(e, uri, prefix);
        }
        for (int att = 0; att < reader.getAttributeCount(); ++att) {
            String name = reader.getAttributeLocalName(att);
            prefix = reader.getAttributePrefix(att);
            if (prefix != null && prefix.length() > 0) {
                name = prefix + ":" + name;
            }
            Attr attr = doc.createAttributeNS(reader.getAttributeNamespace(att), name);
            attr.setValue(reader.getAttributeValue(att));
            e.setAttributeNode(attr);
        }
        if (repairing && !StaxUtils.isDeclared(e, reader.getNamespaceURI(), reader.getPrefix())) {
            StaxUtils.declare(e, reader.getNamespaceURI(), reader.getPrefix());
        }
        reader.next();
        StaxUtils.readDocElements(doc, e, reader, repairing, recordLocation);
        return e;
    }

    private static boolean isDeclared(Element e, String namespaceURI, String prefix) {
        Attr att = prefix != null && prefix.length() > 0 ? e.getAttributeNodeNS(XML_NS, prefix) : e.getAttributeNode("xmlns");
        if (att != null && att.getNodeValue().equals(namespaceURI)) {
            return true;
        }
        if (e.getParentNode() instanceof Element) {
            return StaxUtils.isDeclared((Element)e.getParentNode(), namespaceURI, prefix);
        }
        return false;
    }

    public static void readDocElements(Node parent, XMLStreamReader reader, boolean repairing) throws XMLStreamException {
        Document doc = StaxUtils.getDocument(parent);
        StaxUtils.readDocElements(doc, parent, reader, repairing, false);
    }

    public static void readDocElements(Document doc, Node parent, XMLStreamReader reader, boolean repairing, boolean recordLoc) throws XMLStreamException {
        int event = reader.getEventType();
        while (reader.hasNext()) {
            switch (event) {
                case 1: {
                    StaxUtils.startElement(doc, parent, reader, repairing, recordLoc);
                    if (!(parent instanceof Document)) break;
                    return;
                }
                case 2: {
                    return;
                }
                case 13: {
                    break;
                }
                case 10: {
                    break;
                }
                case 4: {
                    if (parent == null) break;
                    recordLoc = StaxUtils.addLocation(doc, parent.appendChild(doc.createTextNode(reader.getText())), reader, recordLoc);
                    break;
                }
                case 5: {
                    if (parent == null) break;
                    parent.appendChild(doc.createComment(reader.getText()));
                    break;
                }
                case 12: {
                    recordLoc = StaxUtils.addLocation(doc, parent.appendChild(doc.createCDATASection(reader.getText())), reader, recordLoc);
                    break;
                }
                case 3: {
                    parent.appendChild(doc.createProcessingInstruction(reader.getPITarget(), reader.getPIData()));
                    break;
                }
                case 9: {
                    parent.appendChild(doc.createProcessingInstruction(reader.getPITarget(), reader.getPIData()));
                    break;
                }
            }
            if (!reader.hasNext()) continue;
            event = reader.next();
        }
    }

    private static boolean addLocation(Document doc, Node node, XMLStreamReader reader, boolean recordLoc) {
        Location loc;
        if (recordLoc && (loc = reader.getLocation()) != null && (loc.getColumnNumber() != 0 || loc.getLineNumber() != 0)) {
            try {
                final int charOffset = loc.getCharacterOffset();
                final int colNum = loc.getColumnNumber();
                final int linNum = loc.getLineNumber();
                final String pubId = loc.getPublicId() == null ? doc.getDocumentURI() : loc.getPublicId();
                final String sysId = loc.getSystemId() == null ? doc.getDocumentURI() : loc.getSystemId();
                Location loc2 = new Location(){

                    public int getCharacterOffset() {
                        return charOffset;
                    }

                    public int getColumnNumber() {
                        return colNum;
                    }

                    public int getLineNumber() {
                        return linNum;
                    }

                    public String getPublicId() {
                        return pubId;
                    }

                    public String getSystemId() {
                        return sysId;
                    }
                };
                node.setUserData("location", loc2, new UserDataHandler(){

                    public void handle(short operation, String key, Object data, Node src, Node dst) {
                        if (operation == 1) {
                            dst.setUserData(key, data, this);
                        }
                    }
                });
            }
            catch (Exception ex) {
                return false;
            }
        }
        return recordLoc;
    }

    private static void declare(Element node, String uri, String prefix) {
        String qualname = prefix != null && prefix.length() > 0 ? "xmlns:" + prefix : "xmlns";
        Attr attr = node.getOwnerDocument().createAttributeNS(XML_NS, qualname);
        attr.setValue(uri);
        node.setAttributeNodeNS(attr);
    }

    public static XMLStreamReader createXMLStreamReader(InputSource src) {
        String pubId;
        String sysId = src.getSystemId() == null ? null : new String(src.getSystemId());
        String string = pubId = src.getPublicId() == null ? null : new String(src.getPublicId());
        if (src.getByteStream() != null) {
            if (src.getEncoding() == null) {
                StreamSource ss = new StreamSource(src.getByteStream(), sysId);
                ss.setPublicId(pubId);
                return StaxUtils.createXMLStreamReader(ss);
            }
            return StaxUtils.createXMLStreamReader(src.getByteStream(), src.getEncoding());
        }
        if (src.getCharacterStream() != null) {
            StreamSource ss = new StreamSource(src.getCharacterStream(), sysId);
            ss.setPublicId(pubId);
            return StaxUtils.createXMLStreamReader(ss);
        }
        throw new IllegalArgumentException("InputSource must have a ByteStream or CharacterStream");
    }

    public static XMLStreamReader createXMLStreamReader(InputStream in, String encoding) {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        XMLInputFactory factory = StaxUtils.getXMLInputFactory();
        try {
            XMLStreamReader xMLStreamReader = factory.createXMLStreamReader(in, encoding);
            return xMLStreamReader;
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Couldn't parse stream.", e);
        }
        finally {
            StaxUtils.returnXMLInputFactory(factory);
        }
    }

    public static XMLStreamReader createXMLStreamReader(InputStream in) {
        XMLInputFactory factory = StaxUtils.getXMLInputFactory();
        try {
            XMLStreamReader xMLStreamReader = factory.createXMLStreamReader(in);
            return xMLStreamReader;
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Couldn't parse stream.", e);
        }
        finally {
            StaxUtils.returnXMLInputFactory(factory);
        }
    }

    public static XMLStreamReader createXMLStreamReader(String systemId, InputStream in) {
        XMLInputFactory factory = StaxUtils.getXMLInputFactory();
        try {
            XMLStreamReader xMLStreamReader = factory.createXMLStreamReader(systemId, in);
            return xMLStreamReader;
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Couldn't parse stream.", e);
        }
        finally {
            StaxUtils.returnXMLInputFactory(factory);
        }
    }

    public static XMLStreamReader createXMLStreamReader(Element el) {
        return new W3CDOMStreamReader(el);
    }

    public static XMLStreamReader createXMLStreamReader(Document doc) {
        return new W3CDOMStreamReader(doc.getDocumentElement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLStreamReader createXMLStreamReader(Source source) {
        XMLStreamReader xMLStreamReader;
        if (source instanceof DOMSource) {
            DOMSource ds = (DOMSource)source;
            Node nd = ds.getNode();
            Element el = null;
            if (nd instanceof Document) {
                el = ((Document)nd).getDocumentElement();
            } else if (nd instanceof Element) {
                el = (Element)nd;
            }
            if (null != el) {
                return new W3CDOMStreamReader(el, source.getSystemId());
            }
        } else if ("javax.xml.transform.stax.StAXSource".equals(source.getClass().getName())) {
            try {
                return (XMLStreamReader)source.getClass().getMethod("getXMLStreamReader", new Class[0]).invoke((Object)source, new Object[0]);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        XMLInputFactory factory = StaxUtils.getXMLInputFactory();
        try {
            XMLStreamReader reader = factory.createXMLStreamReader(source);
            if (reader == null && source instanceof StreamSource) {
                StreamSource ss = (StreamSource)source;
                reader = ss.getInputStream() != null ? factory.createXMLStreamReader(ss.getSystemId(), ss.getInputStream()) : factory.createXMLStreamReader(ss.getSystemId(), ss.getReader());
            }
            xMLStreamReader = reader;
        }
        catch (Throwable throwable) {
            try {
                StaxUtils.returnXMLInputFactory(factory);
                throw throwable;
            }
            catch (XMLStreamException e) {
                throw new RuntimeException("Couldn't parse stream.", e);
            }
        }
        StaxUtils.returnXMLInputFactory(factory);
        return xMLStreamReader;
    }

    public static XMLStreamReader createXMLStreamReader(Reader reader) {
        XMLInputFactory factory = StaxUtils.getXMLInputFactory();
        try {
            XMLStreamReader xMLStreamReader = factory.createXMLStreamReader(reader);
            return xMLStreamReader;
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Couldn't parse stream.", e);
        }
        finally {
            StaxUtils.returnXMLInputFactory(factory);
        }
    }

    public static QName readQName(XMLStreamReader reader) throws XMLStreamException {
        String value = reader.getElementText();
        if (value == null) {
            return null;
        }
        int index = value.indexOf(":");
        if (index == -1) {
            return new QName(value);
        }
        String prefix = value.substring(0, index);
        String localName = value.substring(index + 1);
        String ns = reader.getNamespaceURI(prefix);
        if (prefix != null && ns == null || localName == null) {
            throw new RuntimeException("Invalid QName in mapping: " + value);
        }
        if (ns == null) {
            return new QName(localName);
        }
        return new QName(ns, localName, prefix);
    }

    public static String getUniquePrefix(XMLStreamWriter writer, String namespaceURI, boolean declare) throws XMLStreamException {
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = StaxUtils.getUniquePrefix(writer);
            if (declare) {
                writer.setPrefix(prefix, namespaceURI);
                writer.writeNamespace(prefix, namespaceURI);
            }
        }
        return prefix;
    }

    public static String getUniquePrefix(XMLStreamWriter writer, String namespaceURI) throws XMLStreamException {
        return StaxUtils.getUniquePrefix(writer, namespaceURI, false);
    }

    public static String getUniquePrefix(XMLStreamWriter writer) {
        NamespaceContext nc = writer.getNamespaceContext();
        if (nc == null) {
            return DEF_PREFIXES[0];
        }
        for (String t : DEF_PREFIXES) {
            String uri = nc.getNamespaceURI(t);
            if (!StringUtils.isEmpty(uri)) continue;
            return t;
        }
        int n = 10;
        String nsPrefix;
        String uri;
        while (!StringUtils.isEmpty(uri = nc.getNamespaceURI(nsPrefix = "ns" + n))) {
            ++n;
        }
        return nsPrefix;
    }

    public static void printXmlFragment(XMLStreamReader reader) {
        try {
            LOG.info(XMLUtils.toString(StaxUtils.read(reader), 4));
        }
        catch (XMLStreamException e) {
            LOG.severe(e.getMessage());
        }
    }

    private static void writeStartElementEvent(XMLEvent event, XMLStreamWriter writer) throws XMLStreamException {
        StartElement start = event.asStartElement();
        QName name = start.getName();
        String nsURI = name.getNamespaceURI();
        String localName = name.getLocalPart();
        String prefix = name.getPrefix();
        if (prefix != null) {
            writer.writeStartElement(prefix, localName, nsURI);
        } else if (nsURI != null) {
            writer.writeStartElement(localName, nsURI);
        } else {
            writer.writeStartElement(localName);
        }
        Iterator<Attribute> it = start.getNamespaces();
        while (it != null && it.hasNext()) {
            StaxUtils.writeEvent(it.next(), writer);
        }
        it = start.getAttributes();
        while (it != null && it.hasNext()) {
            StaxUtils.writeAttributeEvent(it.next(), writer);
        }
    }

    private static void writeAttributeEvent(XMLEvent event, XMLStreamWriter writer) throws XMLStreamException {
        Attribute attr = (Attribute)event;
        QName name = attr.getName();
        String nsURI = name.getNamespaceURI();
        String localName = name.getLocalPart();
        String prefix = name.getPrefix();
        String value = attr.getValue();
        if (prefix != null) {
            writer.writeAttribute(prefix, nsURI, localName, value);
        } else if (nsURI != null) {
            writer.writeAttribute(nsURI, localName, value);
        } else {
            writer.writeAttribute(localName, value);
        }
    }

    public static void writeEvent(XMLEvent event, XMLStreamWriter writer) throws XMLStreamException {
        switch (event.getEventType()) {
            case 1: {
                StaxUtils.writeStartElementEvent(event, writer);
                break;
            }
            case 2: {
                writer.writeEndElement();
                break;
            }
            case 10: {
                StaxUtils.writeAttributeEvent(event, writer);
                break;
            }
            case 9: {
                writer.writeEntityRef(((EntityReference)event).getName());
                break;
            }
            case 11: {
                writer.writeDTD(((DTD)event).getDocumentTypeDeclaration());
                break;
            }
            case 3: {
                if (((javax.xml.stream.events.ProcessingInstruction)event).getData() != null) {
                    writer.writeProcessingInstruction(((javax.xml.stream.events.ProcessingInstruction)event).getTarget(), ((javax.xml.stream.events.ProcessingInstruction)event).getData());
                    break;
                }
                writer.writeProcessingInstruction(((javax.xml.stream.events.ProcessingInstruction)event).getTarget());
                break;
            }
            case 13: {
                if (((Namespace)event).isDefaultNamespaceDeclaration()) {
                    writer.writeDefaultNamespace(((Namespace)event).getNamespaceURI());
                    break;
                }
                writer.writeNamespace(((Namespace)event).getPrefix(), ((Namespace)event).getNamespaceURI());
                break;
            }
            case 5: {
                writer.writeComment(((javax.xml.stream.events.Comment)event).getText());
                break;
            }
            case 4: 
            case 6: {
                writer.writeCharacters(event.asCharacters().getData());
                break;
            }
            case 12: {
                writer.writeCData(event.asCharacters().getData());
                break;
            }
            case 7: {
                if (((StartDocument)event).encodingSet()) {
                    writer.writeStartDocument(((StartDocument)event).getCharacterEncodingScheme(), ((StartDocument)event).getVersion());
                    break;
                }
                writer.writeStartDocument(((StartDocument)event).getVersion());
                break;
            }
            case 8: {
                writer.writeEndDocument();
                break;
            }
        }
    }

    public static String toString(Document doc) throws XMLStreamException {
        StringWriter sw = new StringWriter(1024);
        XMLStreamWriter writer = StaxUtils.createXMLStreamWriter(sw);
        StaxUtils.copy(doc, writer);
        writer.flush();
        return sw.toString();
    }

    public static String toString(Element el) throws XMLStreamException {
        StringWriter sw = new StringWriter(1024);
        XMLStreamWriter writer = StaxUtils.createXMLStreamWriter(sw);
        StaxUtils.copy(el, writer);
        writer.flush();
        return sw.toString();
    }

    static {
        DEF_PREFIXES = new String[]{"ns1".intern(), "ns2".intern(), "ns3".intern(), "ns4".intern(), "ns5".intern(), "ns6".intern(), "ns7".intern(), "ns8".intern(), "ns9".intern()};
        int i = 20;
        try {
            String s = System.getProperty("org.apache.cxf.staxutils.pool-size", "-1");
            i = Integer.parseInt(s);
        }
        catch (Throwable t) {
            i = 20;
        }
        if (i <= 0) {
            i = 20;
        }
        NS_AWARE_INPUT_FACTORY_POOL = new LinkedBlockingQueue<XMLInputFactory>(i);
        OUTPUT_FACTORY_POOL = new LinkedBlockingQueue<XMLOutputFactory>(i);
    }
}

