/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.configuration.jsse.spring;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.GeneralSecurityException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.jsse.spring.TLSParameterJaxBUtils;
import org.apache.cxf.configuration.security.TLSClientParametersType;
import org.apache.cxf.staxutils.StaxUtils;

public final class TLSClientParametersConfig {
    static JAXBContext context;

    private TLSClientParametersConfig() {
    }

    private static synchronized JAXBContext getContext() throws JAXBException {
        if (context == null) {
            context = JAXBContext.newInstance((String)PackageUtils.getPackageName(TLSClientParametersType.class), (ClassLoader)TLSClientParametersConfig.class.getClassLoader());
        }
        return context;
    }

    static TLSClientParameters createTLSClientParametersFromType(TLSClientParametersType params) throws GeneralSecurityException, IOException {
        TLSClientParameters ret = new TLSClientParameters();
        if (params.isDisableCNCheck()) {
            ret.setDisableCNCheck(true);
        }
        if (params.isSetCipherSuitesFilter()) {
            ret.setCipherSuitesFilter(params.getCipherSuitesFilter());
        }
        if (params.isSetCipherSuites()) {
            ret.setCipherSuites(params.getCipherSuites().getCipherSuite());
        }
        if (params.isSetJsseProvider()) {
            ret.setJsseProvider(params.getJsseProvider());
        }
        if (params.isSetSecureRandomParameters()) {
            ret.setSecureRandom(TLSParameterJaxBUtils.getSecureRandom(params.getSecureRandomParameters()));
        }
        if (params.isSetKeyManagers()) {
            ret.setKeyManagers(TLSParameterJaxBUtils.getKeyManagers(params.getKeyManagers()));
        }
        if (params.isSetTrustManagers()) {
            ret.setTrustManagers(TLSParameterJaxBUtils.getTrustManagers(params.getTrustManagers()));
        }
        if (params.isSetCertConstraints()) {
            ret.setCertConstraints(params.getCertConstraints());
        }
        return ret;
    }

    public static Object createTLSClientParameters(String s) {
        StringReader reader = new StringReader(s);
        XMLStreamReader data = StaxUtils.createXMLStreamReader((Reader)reader);
        try {
            Unmarshaller u = TLSClientParametersConfig.getContext().createUnmarshaller();
            Object obj = u.unmarshal(data, TLSClientParametersType.class);
            if (obj instanceof JAXBElement) {
                JAXBElement el = obj;
                obj = el.getValue();
            }
            TLSClientParametersType cpt = (TLSClientParametersType)obj;
            return TLSClientParametersConfig.createTLSClientParametersFromType(cpt);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

