/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.PolicyException;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssertionInfoMap
extends HashMap<QName, Collection<AssertionInfo>> {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(AssertionInfoMap.class, (String)"APIMessages");

    public AssertionInfoMap(Policy p) {
        this(AssertionInfoMap.getAssertions((PolicyOperator)p));
    }

    public AssertionInfoMap(Collection<PolicyAssertion> assertions) {
        super(assertions.size() < 6 ? 6 : assertions.size());
        for (PolicyAssertion a : assertions) {
            this.putAssertionInfo(a);
        }
    }

    private void putAssertionInfo(PolicyAssertion a) {
        Policy p = a.getPolicy();
        if (p != null) {
            ArrayList<PolicyAssertion> pcs = new ArrayList<PolicyAssertion>();
            AssertionInfoMap.getAssertions((PolicyOperator)p, pcs);
            for (PolicyAssertion na : pcs) {
                this.putAssertionInfo(na);
            }
        }
        AssertionInfo ai = new AssertionInfo(a);
        ArrayList<AssertionInfo> ail = (ArrayList<AssertionInfo>)this.get(a.getName());
        if (ail == null) {
            ail = new ArrayList<AssertionInfo>();
            this.put(a.getName(), ail);
        }
        ail.add(ai);
    }

    public Collection<AssertionInfo> getAssertionInfo(QName name) {
        Collection ail = (Collection)this.get(name);
        return ail != null ? ail : CastUtils.cast((List)Collections.EMPTY_LIST, AssertionInfo.class);
    }

    public boolean supportsAlternative(PolicyAssertion assertion, List<QName> errors) {
        Policy p;
        boolean pass = true;
        PolicyAssertion a = assertion;
        if (!a.isAsserted(this) && !a.isOptional()) {
            errors.add(a.getName());
            pass = false;
        }
        if ((p = a.getPolicy()) != null) {
            Iterator it = p.getAlternatives();
            while (it.hasNext()) {
                List lst = CastUtils.cast((List)((List)it.next()));
                for (PolicyAssertion p2 : lst) {
                    pass &= this.supportsAlternative(p2, errors);
                }
            }
        }
        return pass || a.isOptional();
    }

    public boolean supportsAlternative(Collection<PolicyAssertion> alternative, List<QName> errors) {
        boolean pass = true;
        for (PolicyAssertion a : alternative) {
            pass &= this.supportsAlternative(a, errors);
        }
        return pass;
    }

    public void checkEffectivePolicy(Policy policy) {
        ArrayList<QName> errors = new ArrayList<QName>();
        Iterator alternatives = policy.getAlternatives();
        while (alternatives.hasNext()) {
            List alternative = CastUtils.cast((List)((List)alternatives.next()), PolicyAssertion.class);
            if (!this.supportsAlternative(alternative, errors)) continue;
            return;
        }
        LinkedHashSet<String> msgs = new LinkedHashSet<String>();
        for (QName name : errors) {
            Collection<AssertionInfo> ais = this.getAssertionInfo(name);
            for (AssertionInfo ai : ais) {
                if (ai.isAsserted()) continue;
                String s = name.toString();
                if (ai.getErrorMessage() != null) {
                    s = s + ": " + ai.getErrorMessage();
                }
                msgs.add(s);
            }
        }
        StringBuilder error = new StringBuilder("\n");
        for (String msg : msgs) {
            error.append("\n").append(msg);
        }
        throw new PolicyException(new Message("NO_ALTERNATIVE_EXC", BUNDLE, new Object[]{error.toString()}));
    }

    public void check() {
        for (Collection ais : this.values()) {
            for (AssertionInfo ai : ais) {
                if (ai.isAsserted()) continue;
                throw new PolicyException(new Message("NOT_ASSERTED_EXC", BUNDLE, new Object[]{ai.getAssertion().getName()}));
            }
        }
    }

    private static Collection<PolicyAssertion> getAssertions(PolicyOperator p) {
        ArrayList<PolicyAssertion> assertions = new ArrayList<PolicyAssertion>();
        AssertionInfoMap.getAssertions(p, assertions);
        return assertions;
    }

    private static void getAssertions(PolicyOperator p, Collection<PolicyAssertion> assertions) {
        List pcs = CastUtils.cast((List)p.getPolicyComponents(), PolicyComponent.class);
        for (PolicyComponent pc : pcs) {
            if (pc instanceof PolicyAssertion) {
                assertions.add((PolicyAssertion)pc);
                continue;
            }
            AssertionInfoMap.getAssertions((PolicyOperator)pc, assertions);
        }
    }
}

