/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import com.sun.xml.fastinfoset.stax.factory.StAXInputFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.StaxInInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FIStaxInInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final String FI_GET_SUPPORTED = "org.apache.cxf.fastinfoset.get.supported";
    XMLInputFactory factory = new StAXInputFactory();

    public FIStaxInInterceptor() {
        this("post-stream");
    }

    public FIStaxInInterceptor(String phase) {
        super(phase);
        this.addBefore(StaxInInterceptor.class.getName());
    }

    protected boolean isRequestor(Message message) {
        return Boolean.TRUE.equals(message.containsKey((Object)"org.apache.cxf.client"));
    }

    public void handleMessage(Message message) {
        if (message.getContentFormats().contains(XMLStreamReader.class) || !this.isHttpVerbSupported(message)) {
            return;
        }
        String ct = (String)message.get((Object)"Content-Type");
        if (ct != null && ct.indexOf("fastinfoset") != -1) {
            message.put((Object)XMLInputFactory.class.getName(), (Object)this.factory);
            ct = ct.replace("fastinfoset", "xml");
            if (ct.contains("application/xml")) {
                ct = ct.replace("application/xml", "text/xml");
            }
            message.put((Object)"Content-Type", (Object)ct);
            message.getExchange().put((Object)"org.apache.cxf.fastinfoset.enabled", (Object)Boolean.TRUE);
            if (this.isRequestor(message)) {
                Endpoint ep = (Endpoint)message.getExchange().get(Endpoint.class);
                ep.put((Object)"org.apache.cxf.fastinfoset.enabled", (Object)Boolean.TRUE);
            }
        }
    }

    protected boolean isHttpVerbSupported(Message message) {
        if (this.isGET(message)) {
            return this.isRequestor(message) && MessageUtils.isTrue((Object)message.getContextualProperty(FI_GET_SUPPORTED));
        }
        return true;
    }
}

