/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.AbstractWrappedMessage;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapMessage
extends AbstractWrappedMessage {
    private SoapVersion version = Soap11.getInstance();

    public SoapMessage(Message message) {
        super(message);
    }

    public SoapVersion getVersion() {
        return this.version;
    }

    public void setVersion(SoapVersion v) {
        this.version = v;
    }

    public List<Header> getHeaders() {
        ArrayList heads = CastUtils.cast((List)((List)this.get(Header.HEADER_LIST)));
        if (heads == null) {
            heads = new ArrayList();
            this.put(Header.HEADER_LIST, heads);
        }
        return heads;
    }

    public boolean hasHeader(QName qn) {
        for (Header head : this.getHeaders()) {
            if (!head.getName().equals(qn)) continue;
            return true;
        }
        return false;
    }

    public Header getHeader(QName qn) {
        for (Header head : this.getHeaders()) {
            if (!head.getName().equals(qn)) continue;
            return head;
        }
        return null;
    }

    public boolean hasHeaders() {
        return this.containsKey(Header.HEADER_LIST) && this.getHeaders().size() > 0;
    }

    public Map<String, String> getEnvelopeNs() {
        return CastUtils.cast((Map)((Map)this.get("soap.env.ns.map")));
    }

    public boolean hasAdditionalEnvNs() {
        Map<String, String> ns = this.getEnvelopeNs();
        return ns != null && !ns.isEmpty();
    }
}

