/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_jetty.continuations;

import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.continuations.ContinuationInfo;
import org.apache.cxf.continuations.SuspendedInvocationException;
import org.apache.cxf.message.Message;
import org.mortbay.jetty.RetryRequest;
import org.mortbay.util.ajax.Continuation;
import org.mortbay.util.ajax.ContinuationSupport;

public class JettyContinuationWrapper
implements org.apache.cxf.continuations.Continuation {
    private Continuation continuation;
    private Message message;

    public JettyContinuationWrapper(HttpServletRequest request, Message m) {
        this.continuation = ContinuationSupport.getContinuation((HttpServletRequest)request, null);
        this.message = m;
    }

    public Object getObject() {
        Object o = this.continuation.getObject();
        if (o instanceof ContinuationInfo) {
            return ((ContinuationInfo)o).getUserObject();
        }
        return o;
    }

    public boolean isNew() {
        return this.continuation.isNew() || !this.continuation.isPending() && !this.continuation.isResumed();
    }

    public boolean isPending() {
        return this.continuation.isPending();
    }

    public boolean isResumed() {
        return this.continuation.isResumed();
    }

    public void reset() {
        this.continuation.reset();
    }

    public void resume() {
        this.continuation.resume();
    }

    public void setObject(Object userObject) {
        ContinuationInfo ci = null;
        Object obj = this.continuation.getObject();
        if (obj instanceof ContinuationInfo) {
            ci = (ContinuationInfo)obj;
        } else {
            ci = new ContinuationInfo(this.message);
            ci.setUserObject(obj);
        }
        if (this.message != userObject) {
            ci.setUserObject(userObject);
        }
        this.continuation.setObject((Object)ci);
    }

    public boolean suspend(long timeout) {
        Object obj = this.continuation.getObject();
        if (obj == null) {
            this.continuation.setObject((Object)new ContinuationInfo(this.message));
        }
        try {
            return this.continuation.suspend(timeout);
        }
        catch (RetryRequest ex) {
            throw new SuspendedInvocationException((Throwable)ex);
        }
    }

    public void done() {
        ContinuationInfo ci = null;
        Object obj = this.continuation.getObject();
        if (obj instanceof ContinuationInfo) {
            ci = (ContinuationInfo)obj;
            this.continuation.setObject(ci.getUserObject());
        }
        this.continuation.reset();
    }

    protected Message getMessage() {
        return this.message;
    }

    public Continuation getContinuation() {
        return this.continuation;
    }
}

