/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.catalog;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.xml.resolver.Catalog;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;

public class OASISCatalogManager {
    public static final String DEFAULT_CATALOG_NAME = "META-INF/jax-ws-catalog.xml";
    public static final String CATALOG_DEBUG_KEY = "OASISCatalogManager.catalog.debug.level";
    private static final Logger LOG = LogUtils.getL7dLogger(OASISCatalogManager.class);
    private static final String DEBUG_LEVEL = System.getProperty("OASISCatalogManager.catalog.debug.level");
    private Object resolver;
    private Set<URL> loadedCatalogs = Collections.synchronizedSet(new HashSet());
    private Bus bus;

    public OASISCatalogManager() {
        this.resolver = OASISCatalogManager.getResolver();
    }

    private static Object getResolver() {
        try {
            CatalogManager catalogManager = new CatalogManager();
            if (DEBUG_LEVEL != null) {
                catalogManager.debug.setDebug(Integer.parseInt(DEBUG_LEVEL));
            }
            catalogManager.setUseStaticCatalog(false);
            catalogManager.setIgnoreMissingProperties(true);
            CatalogResolver catalogResolver = new CatalogResolver(catalogManager);
            return catalogResolver.getCatalog();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public Bus getBus() {
        return this.bus;
    }

    @Resource
    public void setBus(Bus bus) {
        this.bus = bus;
    }

    @PostConstruct
    public void register() {
        if (null != this.bus) {
            this.bus.setExtension((Object)this, OASISCatalogManager.class);
        }
        this.loadContextCatalogs();
    }

    public void loadContextCatalogs() {
        this.loadContextCatalogs(DEFAULT_CATALOG_NAME);
    }

    public void loadContextCatalogs(String name) {
        try {
            this.loadCatalogs(Thread.currentThread().getContextClassLoader(), name);
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Error loading " + name + " catalog files", e);
        }
    }

    public void loadCatalogs(ClassLoader classLoader, String name) throws IOException {
        if (classLoader == null || this.resolver == null) {
            return;
        }
        Enumeration<URL> catalogs = classLoader.getResources(name);
        while (catalogs.hasMoreElements()) {
            URL catalogURL = catalogs.nextElement();
            if (this.loadedCatalogs.contains(catalogURL)) continue;
            ((Catalog)this.resolver).parseCatalog(catalogURL);
            this.loadedCatalogs.add(catalogURL);
        }
    }

    public void loadCatalog(URL catalogURL) throws IOException {
        if (!this.loadedCatalogs.contains(catalogURL) && this.resolver != null) {
            if ("file".equals(catalogURL.getProtocol())) {
                try {
                    File file = new File(catalogURL.toURI());
                    if (!file.exists()) {
                        throw new FileNotFoundException(file.getAbsolutePath());
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            ((Catalog)this.resolver).parseCatalog(catalogURL);
            this.loadedCatalogs.add(catalogURL);
        }
    }

    private static OASISCatalogManager getContextCatalog() {
        try {
            OASISCatalogManager oasisCatalog = new OASISCatalogManager();
            oasisCatalog.loadContextCatalogs();
            return oasisCatalog;
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static OASISCatalogManager getCatalogManager(Bus bus) {
        if (bus == null) {
            return OASISCatalogManager.getContextCatalog();
        }
        OASISCatalogManager catalog = (OASISCatalogManager)bus.getExtension(OASISCatalogManager.class);
        if (catalog == null && (catalog = OASISCatalogManager.getContextCatalog()) != null) {
            bus.setExtension((Object)catalog, OASISCatalogManager.class);
        }
        return catalog;
    }

    public String resolveSystem(String sys) throws MalformedURLException, IOException {
        if (this.resolver == null) {
            return null;
        }
        return ((Catalog)this.resolver).resolveSystem(sys);
    }

    public String resolveURI(String uri) throws MalformedURLException, IOException {
        if (this.resolver == null) {
            return null;
        }
        return ((Catalog)this.resolver).resolveURI(uri);
    }

    public String resolvePublic(String uri, String parent) throws MalformedURLException, IOException {
        if (this.resolver == null) {
            return null;
        }
        return ((Catalog)this.resolver).resolvePublic(uri, parent);
    }
}

