/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.interceptors;

import java.util.Arrays;
import java.util.Collection;
import java.util.Vector;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.policy.AbstractPolicyInterceptorProvider;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.IssuedToken;
import org.apache.cxf.ws.security.policy.model.Trust10;
import org.apache.cxf.ws.security.policy.model.Trust13;
import org.apache.cxf.ws.security.tokenstore.MemoryTokenStore;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.cxf.ws.security.trust.STSClient;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.ws.security.handler.WSHandlerResult;

public class IssuedTokenInterceptorProvider
extends AbstractPolicyInterceptorProvider {
    public IssuedTokenInterceptorProvider() {
        super(Arrays.asList(SP11Constants.ISSUED_TOKEN, SP12Constants.ISSUED_TOKEN));
        this.getOutInterceptors().add(new IssuedTokenOutInterceptor());
        this.getOutFaultInterceptors().add(new IssuedTokenOutInterceptor());
        this.getInInterceptors().add(new IssuedTokenInInterceptor());
        this.getInFaultInterceptors().add(new IssuedTokenInInterceptor());
    }

    static final TokenStore getTokenStore(Message message) {
        TokenStore tokenStore = (TokenStore)message.getContextualProperty(TokenStore.class.getName());
        if (tokenStore == null) {
            tokenStore = new MemoryTokenStore();
            ((Endpoint)message.getExchange().get(Endpoint.class)).getEndpointInfo().setProperty(TokenStore.class.getName(), (Object)tokenStore);
        }
        return tokenStore;
    }

    static STSClient getClient(Message message) {
        STSClient client = (STSClient)message.getContextualProperty("ws-security.sts.client");
        if (client == null) {
            client = new STSClient((Bus)message.getExchange().get(Bus.class));
            Endpoint ep = (Endpoint)message.getExchange().get(Endpoint.class);
            client.setEndpointName(ep.getEndpointInfo().getName().toString() + ".sts-client");
            client.setBeanName(ep.getEndpointInfo().getName().toString() + ".sts-client");
        }
        client.setActAs(message.getContextualProperty("ws-security.sts.token.act-as"));
        return client;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IssuedTokenInInterceptor
    extends AbstractPhaseInterceptor<Message> {
        public IssuedTokenInInterceptor() {
            super("pre-protocol");
            this.addAfter(WSS4JInInterceptor.class.getName());
        }

        public void handleMessage(Message message) throws Fault {
            block8: {
                AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
                if (aim == null) break block8;
                Collection ais = (Collection)aim.get((Object)SP12Constants.ISSUED_TOKEN);
                if (ais == null) {
                    return;
                }
                if (!this.isRequestor(message)) {
                    boolean found = false;
                    Vector results = (Vector)message.get((Object)"RECV_RESULTS");
                    if (results != null) {
                        for (int i = 0; i < results.size(); ++i) {
                            WSHandlerResult rResult = (WSHandlerResult)results.get(i);
                            Vector wsSecEngineResults = rResult.getResults();
                            for (int j = 0; j < wsSecEngineResults.size(); ++j) {
                                found = true;
                            }
                        }
                    }
                    for (AssertionInfo inf : ais) {
                        inf.setAsserted(found);
                    }
                } else {
                    for (AssertionInfo ai : ais) {
                        ai.setAsserted(true);
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IssuedTokenOutInterceptor
    extends AbstractPhaseInterceptor<Message> {
        public IssuedTokenOutInterceptor() {
            super("prepare-send");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message message) throws Fault {
            AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
            if (aim != null) {
                Collection ais = (Collection)aim.get((Object)SP12Constants.ISSUED_TOKEN);
                if (ais == null || ais.isEmpty()) {
                    return;
                }
                if (this.isRequestor(message)) {
                    String tokId;
                    IssuedToken itok = (IssuedToken)((AssertionInfo)ais.iterator().next()).getAssertion();
                    SecurityToken tok = (SecurityToken)message.getContextualProperty("ws-security.token");
                    if (tok == null && (tokId = (String)message.getContextualProperty("ws-security.token.id")) != null) {
                        tok = IssuedTokenInterceptorProvider.getTokenStore(message).getToken(tokId);
                    }
                    if (tok == null) {
                        STSClient client = IssuedTokenInterceptorProvider.getClient(message);
                        AddressingProperties maps = (AddressingProperties)message.get((Object)"javax.xml.ws.addressing.context.outbound");
                        if (maps == null) {
                            maps = (AddressingProperties)message.get((Object)"javax.xml.ws.addressing.context");
                        }
                        STSClient sTSClient = client;
                        synchronized (sTSClient) {
                            try {
                                client.setTrust(this.getTrust10(aim));
                                client.setTrust(this.getTrust13(aim));
                                client.setTemplate(itok.getRstTemplate());
                                if (maps == null) {
                                    tok = client.requestSecurityToken();
                                } else {
                                    Object o = message.getContextualProperty("ws-security.sts.applies-to");
                                    String s = o == null ? null : o.toString();
                                    s = s == null ? message.getContextualProperty(Message.ENDPOINT_ADDRESS).toString() : s;
                                    client.setAddressingNamespace(maps.getNamespaceURI());
                                    tok = client.requestSecurityToken(s);
                                }
                            }
                            catch (RuntimeException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                throw new Fault((Throwable)e);
                            }
                            finally {
                                client.setTrust((Trust10)null);
                                client.setTrust((Trust13)null);
                                client.setTemplate(null);
                                client.setAddressingNamespace(null);
                            }
                        }
                    }
                    if (tok != null) {
                        for (AssertionInfo ai : ais) {
                            ai.setAsserted(true);
                        }
                        ((Endpoint)message.getExchange().get(Endpoint.class)).put((Object)"ws-security.token.id", (Object)tok.getId());
                        message.getExchange().put((Object)"ws-security.token.id", (Object)tok.getId());
                        IssuedTokenInterceptorProvider.getTokenStore(message).add(tok);
                    }
                } else {
                    for (AssertionInfo ai : ais) {
                        ai.setAsserted(true);
                    }
                }
            }
        }

        private Trust10 getTrust10(AssertionInfoMap aim) {
            Collection ais = (Collection)aim.get((Object)SP11Constants.TRUST_10);
            if (ais == null || ais.isEmpty()) {
                return null;
            }
            return (Trust10)((AssertionInfo)ais.iterator().next()).getAssertion();
        }

        private Trust13 getTrust13(AssertionInfoMap aim) {
            Collection ais = (Collection)aim.get((Object)SP12Constants.TRUST_13);
            if (ais == null || ais.isEmpty()) {
                return null;
            }
            return (Trust13)((AssertionInfo)ais.iterator().next()).getAssertion();
        }
    }
}

