/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxfbc.interceptors;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.attachment.LazyAttachmentCollection;
import org.apache.cxf.binding.soap.model.SoapBindingInfo;
import org.apache.cxf.binding.soap.model.SoapBodyInfo;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.URIMappingInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceModelUtil;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JbiOperationInterceptor
extends AbstractPhaseInterceptor<Message> {
    public JbiOperationInterceptor() {
        super("unmarshal");
        this.addAfter(URIMappingInterceptor.class.getName());
    }

    public void handleMessage(Message message) {
        this.loadAttachments(message);
        if (this.isGET(message)) {
            return;
        }
        if (message.getExchange().get(BindingOperationInfo.class) != null) {
            return;
        }
        DepthXMLStreamReader xmlReader = this.getXMLStreamReader(message);
        BindingOperationInfo operation = null;
        if (!StaxUtils.toNextElement((DepthXMLStreamReader)xmlReader)) {
            message.setContent(Exception.class, (Object)new RuntimeException("There must be a method name element."));
        }
        String opName = xmlReader.getLocalName();
        if (this.isRequestor(message) && opName.endsWith("Response")) {
            opName = opName.substring(0, opName.length() - 8);
        }
        QName opQName = new QName(xmlReader.getNamespaceURI(), opName);
        SoapBindingInfo binding = (SoapBindingInfo)((Endpoint)message.getExchange().get(Endpoint.class)).getEndpointInfo().getBinding();
        for (BindingOperationInfo op : binding.getOperations()) {
            String style = binding.getStyle(op.getOperationInfo());
            if (style == null) {
                style = binding.getStyle();
            }
            if ("document".equals(style)) {
                BindingMessageInfo msg = !this.isRequestor(message) ? op.getInput() : op.getOutput();
                if (!((MessagePartInfo)((SoapBodyInfo)msg.getExtensor(SoapBodyInfo.class)).getParts().get(0)).getElementQName().equals(opQName)) continue;
                operation = op;
                break;
            }
            if (!opQName.equals(op.getName())) continue;
            operation = op;
            break;
        }
        if (operation != null) {
            message.getExchange().put(BindingOperationInfo.class, operation);
            message.getExchange().put(OperationInfo.class, (Object)operation.getOperationInfo());
            message.getExchange().setOneWay(operation.getOperationInfo().isOneWay());
        }
    }

    private void loadAttachments(Message message) {
        if (message.getAttachments() != null) {
            LazyAttachmentCollection attachments = (LazyAttachmentCollection)message.getAttachments();
            attachments.size();
        }
    }

    protected DepthXMLStreamReader getXMLStreamReader(Message message) {
        XMLStreamReader xr = (XMLStreamReader)message.getContent(XMLStreamReader.class);
        if (xr instanceof DepthXMLStreamReader) {
            return (DepthXMLStreamReader)xr;
        }
        DepthXMLStreamReader dr = new DepthXMLStreamReader(xr);
        message.setContent(XMLStreamReader.class, (Object)dr);
        return dr;
    }

    protected BindingOperationInfo getOperation(Message message, QName opName) {
        BindingOperationInfo op = ServiceModelUtil.getOperation((Exchange)message.getExchange(), (QName)opName);
        if (op == null) {
            throw new Fault((Throwable)new Exception("Unrecognized operation"));
        }
        return op;
    }

    protected boolean isRequestor(Message message) {
        return Boolean.TRUE.equals(message.get((Object)"org.apache.cxf.client"));
    }
}

