/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.servicemix.cxfbc.interceptors;

import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;

import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.phase.Phase;

public class SetStatusInterceptor  extends AbstractPhaseInterceptor<Message> {
    
    
    public SetStatusInterceptor() {
        super(Phase.MARSHAL);
        addAfter(JbiOutWsdl1Interceptor.class.getName());
    }

    public void handleMessage(Message message) throws Fault {
        MessageExchange exchange = message
            .getContent(MessageExchange.class);
        try {
            if (message.get("needSetDone") != null 
                    && message.get("needSetDone").equals(Boolean.TRUE) 
                    && exchange.getStatus() == ExchangeStatus.ACTIVE) {
                exchange.setStatus(ExchangeStatus.DONE);
                message.getExchange().get(ComponentContext.class)
                    .getDeliveryChannel().send(exchange);
            }
        } catch (Exception e) {
            throw new Fault(e);
        }
    }

}
