/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxfbc.interceptors;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.model.SoapBindingInfo;
import org.apache.cxf.binding.soap.model.SoapHeaderInfo;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.headers.Header;
import org.apache.cxf.interceptor.AttachmentOutInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.servicemix.cxfbc.WSAUtils;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.soap.util.DomUtil;
import org.apache.servicemix.soap.util.QNameUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JbiOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    public JbiOutInterceptor() {
        super("pre-stream");
    }

    public void handleMessage(Message message) {
        MessageExchange me = (MessageExchange)message.get(MessageExchange.class);
        if (me == null) {
            me = (MessageExchange)message.getContent(MessageExchange.class);
        }
        NormalizedMessage nm = me.getMessage("in");
        this.fromNMSAttachments(message, nm);
        this.fromNMSHeaders(message, nm);
        this.extractHeaderFromMessagePart(message);
    }

    private void extractHeaderFromMessagePart(Message message) {
        Element element;
        Source source = (Source)message.getContent(Source.class);
        if (source == null) {
            return;
        }
        try {
            element = new SourceTransformer().toDOMElement(source);
        }
        catch (Exception e) {
            throw new Fault((Throwable)e);
        }
        if (!"http://java.sun.com/xml/ns/jbi/wsdl-11-wrapper".equals(element.getNamespaceURI()) || !"message".equals(element.getLocalName())) {
            message.setContent(Source.class, (Object)new DOMSource(element));
            return;
        }
        BindingOperationInfo bop = (BindingOperationInfo)message.getExchange().get(BindingOperationInfo.class);
        if (bop == null) {
            throw new Fault((Throwable)new Exception("Operation not bound on this message"));
        }
        BindingMessageInfo msg = this.isRequestor(message) ? bop.getInput() : bop.getOutput();
        SoapBindingInfo binding = (SoapBindingInfo)((Endpoint)message.getExchange().get(Endpoint.class)).getEndpointInfo().getBinding();
        String style = binding.getStyle(bop.getOperationInfo());
        if (style == null) {
            style = binding.getStyle();
        }
        Element partWrapper = DomUtil.getFirstChildElement((Node)element);
        while (partWrapper != null) {
            this.extractHeaderParts((SoapMessage)message, element, partWrapper, msg);
            partWrapper = DomUtil.getNextSiblingElement((Element)partWrapper);
        }
        message.setContent(Source.class, (Object)new DOMSource(element));
    }

    private void extractHeaderParts(SoapMessage message, Element element, Element partWrapper, BindingMessageInfo msg) {
        ArrayList<NodeList> partsContent = new ArrayList<NodeList>();
        if (partWrapper != null) {
            if (!"http://java.sun.com/xml/ns/jbi/wsdl-11-wrapper".equals(element.getNamespaceURI()) || !"part".equals(partWrapper.getLocalName())) {
                throw new Fault((Throwable)new Exception("Unexpected part wrapper element '" + QNameUtil.toString((Element)element) + "' expected '{" + "http://java.sun.com/xml/ns/jbi/wsdl-11-wrapper" + "}part'"));
            }
            NodeList nodes = partWrapper.getChildNodes();
            partsContent.add(nodes);
        }
        List headerList = message.getHeaders();
        List headers = msg.getExtensors(SoapHeaderInfo.class);
        for (SoapHeaderInfo header : headers) {
            if (partsContent.size() == 0) break;
            NodeList nl = (NodeList)partsContent.get(0);
            if (!header.getPart().getConcreteName().getNamespaceURI().equals(nl.item(0).getNamespaceURI()) || !header.getPart().getConcreteName().getLocalPart().equals(nl.item(0).getLocalName())) continue;
            headerList.add(new Header(header.getPart().getConcreteName(), (Object)nl.item(0)));
            partsContent.remove(0);
        }
    }

    private void fromNMSAttachments(Message message, NormalizedMessage normalizedMessage) {
        Set attachmentNames = normalizedMessage.getAttachmentNames();
        ArrayList<AttachmentImpl> attachmentList = new ArrayList<AttachmentImpl>();
        for (String id : attachmentNames) {
            DataHandler handler = normalizedMessage.getAttachment(id);
            AttachmentImpl attachment = new AttachmentImpl(id, handler);
            attachmentList.add(attachment);
        }
        message.setAttachments(attachmentList);
        if (message instanceof SoapMessage) {
            SoapMessage soapMessage = (SoapMessage)message;
            SoapVersion soapVersion = soapMessage.getVersion();
            message.put((Object)"Content-Type", (Object)soapVersion.getContentType());
        }
        if (attachmentList.size() > 0) {
            message.put((Object)"mtom-enabled", (Object)true);
            message.put((Object)"write.attachments", (Object)true);
            message.getInterceptorChain().add((Interceptor)new AttachmentOutInterceptor());
        }
    }

    private void fromNMSHeaders(Message message, NormalizedMessage normalizedMessage) {
        Map map;
        if (message instanceof SoapMessage && (map = (Map)normalizedMessage.getProperty("javax.xml.ws.addressing.context.outbound")) != null) {
            AddressingProperties addressingProperties = WSAUtils.getCXFAddressingPropertiesFromMap(map);
            ((SoapMessage)message).put("javax.xml.ws.addressing.context.outbound", (Object)addressingProperties);
        }
        if (normalizedMessage.getProperty("javax.jbi.messaging.protocol.headers") != null) {
            Map headers = (Map)normalizedMessage.getProperty("javax.jbi.messaging.protocol.headers");
            for (Map.Entry entry : headers.entrySet()) {
                QName name = QNameUtil.parse((String)((String)entry.getKey()));
                if (name == null) continue;
                Header header = new Header(name, entry.getValue());
                if (!(message instanceof SoapMessage)) continue;
                List headerList = ((SoapMessage)message).getHeaders();
                headerList.add(header);
            }
        }
    }
}

