/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxfbc;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.cxfbc.CxfBcConfiguration;
import org.apache.servicemix.cxfbc.CxfBcConsumer;
import org.apache.servicemix.cxfbc.CxfBcEndpointType;
import org.apache.servicemix.cxfbc.CxfBcProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfBcComponent
extends DefaultComponent {
    private CxfBcEndpointType[] endpoints;
    private Bus bus;
    private Map<String, Bus> allBuses = new ConcurrentHashMap<String, Bus>();
    private String busCfg;
    private CxfBcConfiguration configuration = new CxfBcConfiguration();

    public CxfBcEndpointType[] getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(CxfBcEndpointType[] endpoints) {
        this.endpoints = endpoints;
    }

    protected List getConfiguredEndpoints() {
        return CxfBcComponent.asList((Object[])this.endpoints);
    }

    protected Class[] getEndpointClasses() {
        return new Class[]{CxfBcProvider.class, CxfBcConsumer.class};
    }

    protected void doInit() throws Exception {
        this.configuration.setRootDir(this.context.getWorkspaceRoot());
        this.configuration.setComponentName(this.context.getComponentName());
        this.configuration.load();
        if (this.configuration.getBusCfg() != null && this.configuration.getBusCfg().length() > 0) {
            SpringBusFactory bf = new SpringBusFactory();
            this.bus = bf.createBus(this.configuration.getBusCfg());
        } else {
            this.bus = BusFactory.newInstance().createBus();
        }
        if (this.getConfiguration().getAuthenticationService() == null) {
            try {
                String name = this.getConfiguration().getAuthenticationServiceName();
                Object as = this.context.getNamingContext().lookup(name);
                this.getConfiguration().setAuthenticationService(as);
            }
            catch (Throwable e) {
                try {
                    Class<?> cl = Class.forName("org.apache.servicemix.jbi.security.auth.impl.JAASAuthenticationService");
                    this.getConfiguration().setAuthenticationService(cl.newInstance());
                }
                catch (Throwable t) {
                    this.logger.warn("Unable to retrieve or create the authentication service");
                }
            }
        }
        super.doInit();
    }

    protected void doShutDown() throws Exception {
        if (this.bus != null) {
            BusFactory.setThreadDefaultBus(null);
        }
        super.doShutDown();
    }

    public Bus getBus() {
        while (this.bus == null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.bus;
    }

    public Map<String, Bus> getAllBuses() {
        return this.allBuses;
    }

    public void setBusConfig(String busConfig) {
        this.busCfg = busConfig;
    }

    public String getBusConfig() {
        return this.busCfg;
    }

    public void setConfiguration(CxfBcConfiguration configuration) {
        this.configuration = configuration;
    }

    public CxfBcConfiguration getConfiguration() {
        return this.configuration;
    }

    public Object getAuthenticationService() {
        return this.configuration.getAuthenticationService();
    }

    public void setAuthenticationService(Object authenticationService) {
        this.configuration.setAuthenticationService(authenticationService);
    }
}

