/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxfbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor;
import org.apache.cxf.binding.soap.interceptor.SoapOutInterceptor;
import org.apache.cxf.binding.soap.interceptor.SoapPreProtocolOutInterceptor;
import org.apache.cxf.binding.soap.model.SoapBindingInfo;
import org.apache.cxf.binding.soap.model.SoapBodyInfo;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.catalog.OASISCatalogManager;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientImpl;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointImpl;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.AttachmentOutInterceptor;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.interceptor.StaxInInterceptor;
import org.apache.cxf.interceptor.StaxOutInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseChainCache;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.phase.PhaseManager;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.cxf.wsdl11.ServiceWSDLBuilder;
import org.apache.cxf.wsdl11.WSDLServiceBuilder;
import org.apache.cxf.wsdl11.WSDLServiceFactory;
import org.apache.servicemix.common.endpoints.ProviderEndpoint;
import org.apache.servicemix.cxfbc.CxfBcComponent;
import org.apache.servicemix.cxfbc.CxfBcEndpointWithInterceptor;
import org.apache.servicemix.cxfbc.CxfBcProviderMessageObserver;
import org.apache.servicemix.cxfbc.SchemaUtil;
import org.apache.servicemix.cxfbc.interceptors.JbiOutInterceptor;
import org.apache.servicemix.cxfbc.interceptors.JbiOutWsdl1Interceptor;
import org.apache.servicemix.cxfbc.interceptors.MtomCheckInterceptor;
import org.apache.servicemix.cxfbc.interceptors.SchemaValidationOutInterceptor;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.soap.util.DomUtil;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfBcProvider
extends ProviderEndpoint
implements CxfBcEndpointWithInterceptor {
    List<Interceptor<? extends Message>> in = new CopyOnWriteArrayList<Interceptor<? extends Message>>();
    List<Interceptor<? extends Message>> out = new CopyOnWriteArrayList<Interceptor<? extends Message>>();
    List<Interceptor<? extends Message>> outFault = new CopyOnWriteArrayList<Interceptor<? extends Message>>();
    List<Interceptor<? extends Message>> inFault = new CopyOnWriteArrayList<Interceptor<? extends Message>>();
    private Resource wsdl;
    private String busCfg;
    private Bus bus;
    private Bus providedBus;
    private ConduitInitiator conduitInit;
    private Conduit conduit;
    private URI locationURI;
    private EndpointInfo ei;
    private Endpoint ep;
    private Service cxfService;
    private boolean mtomEnabled;
    private boolean useJBIWrapper = true;
    private boolean useSOAPEnvelope = true;
    private boolean synchronous = true;
    private boolean schemaValidationEnabled;
    private List<AbstractFeature> features = new CopyOnWriteArrayList<AbstractFeature>();
    private Map<String, Object> properties = new ConcurrentHashMap<String, Object>();
    private List<Interceptor<? extends Message>> outList;
    private PhaseChainCache cache = new PhaseChainCache();

    public void activate() throws Exception {
        super.activate();
        this.outList = new ArrayList<Interceptor<? extends Message>>();
        if (this.isMtomEnabled()) {
            this.outList.add((Interceptor<? extends Message>)new JbiOutInterceptor());
            this.outList.add((Interceptor<? extends Message>)new MtomCheckInterceptor(true));
            this.outList.add((Interceptor<? extends Message>)new AttachmentOutInterceptor());
        }
        this.outList.add((Interceptor<? extends Message>)new JbiOutInterceptor());
        if (this.isSchemaValidationEnabled()) {
            this.outList.add((Interceptor<? extends Message>)new SchemaValidationOutInterceptor(this.isUseJBIWrapper(), this.isUseSOAPEnvelope()));
        }
        this.outList.add((Interceptor<? extends Message>)new JbiOutWsdl1Interceptor(this.isUseJBIWrapper(), this.isUseSOAPEnvelope()));
        this.outList.add((Interceptor<? extends Message>)new SoapPreProtocolOutInterceptor());
        this.outList.add((Interceptor<? extends Message>)new SoapOutInterceptor(this.getBus()));
        this.outList.add((Interceptor<? extends Message>)new StaxOutInterceptor());
    }

    public void processExchange(MessageExchange exchange) {
    }

    public void process(MessageExchange exchange) throws Exception {
        BindingOperationInfo boi;
        block11: {
            if (exchange.getStatus() != ExchangeStatus.ACTIVE) {
                return;
            }
            NormalizedMessage nm = exchange.getMessage("in");
            Object newDestinationURI = nm.getProperty("org.apache.servicemix.http.destination.uri");
            Message message = this.ep.getBinding().createMessage();
            if (newDestinationURI != null) {
                this.ei.setAddress((String)newDestinationURI);
                message.put((Object)Message.ENDPOINT_ADDRESS, newDestinationURI);
            }
            message.put(MessageExchange.class, (Object)exchange);
            ExchangeImpl cxfExchange = new ExchangeImpl();
            cxfExchange.setConduit(this.conduit);
            cxfExchange.setSynchronous(this.isSynchronous());
            cxfExchange.put(MessageExchange.class, (Object)exchange);
            message.setExchange((Exchange)cxfExchange);
            cxfExchange.setOutMessage(message);
            cxfExchange.put(CxfBcProvider.class, (Object)this);
            QName opeName = exchange.getOperation();
            boi = null;
            if (opeName == null) {
                if (this.ei.getBinding().getOperations().size() == 1) {
                    boi = (BindingOperationInfo)this.ei.getBinding().getOperations().iterator().next();
                } else {
                    boi = this.findOperation(nm, message, boi, exchange);
                    cxfExchange.put(MessageExchange.class, (Object)exchange);
                }
            } else {
                boi = this.ei.getBinding().getOperation(exchange.getOperation());
            }
            cxfExchange.setOneWay(boi.getOperationInfo().isOneWay());
            cxfExchange.put(BindingOperationInfo.class, (Object)boi);
            cxfExchange.put(Endpoint.class, (Object)this.ep);
            cxfExchange.put(Service.class, (Object)this.cxfService);
            cxfExchange.put(Bus.class, (Object)this.getBus());
            PhaseManager pm = (PhaseManager)this.getBus().getExtension(PhaseManager.class);
            PhaseInterceptorChain outChain = this.cache.get(pm.getOutPhases(), this.outList, this.getBus().getOutInterceptors(), this.getBus().getOutFaultInterceptors(), this.getOutInterceptors(), this.getOutFaultInterceptors());
            message.setInterceptorChain((InterceptorChain)outChain);
            message.setContent(Source.class, (Object)nm.getContent());
            this.conduit.prepare(message);
            message.put((Object)"org.apache.cxf.client", (Object)true);
            try {
                outChain.doIntercept(message);
                Exception ex = (Exception)message.getContent(Exception.class);
                if (ex != null) {
                    throw ex;
                }
                ex = (Exception)message.getExchange().get(Exception.class);
                if (ex != null) {
                    throw ex;
                }
                OutputStream os = (OutputStream)message.getContent(OutputStream.class);
                os.flush();
                os.close();
            }
            catch (Exception e) {
                if (exchange instanceof InOnly) break block11;
                this.faultProcess(exchange, message, e);
            }
        }
        if (boi.getOperationInfo().isOneWay()) {
            exchange.setStatus(ExchangeStatus.DONE);
            this.getChannel().send(exchange);
        }
    }

    private void faultProcess(MessageExchange exchange, Message message, Exception e) throws MessagingException {
        boolean txSync;
        Fault fault = exchange.createFault();
        if (e.getCause() != null) {
            this.handleJBIFault(message, e.getCause().getMessage());
        } else {
            this.handleJBIFault(message, e.getMessage());
        }
        fault.setContent((Source)message.getContent(Source.class));
        exchange.setFault(fault);
        boolean bl = txSync = exchange.getStatus() == ExchangeStatus.ACTIVE && exchange.isTransacted() && Boolean.TRUE.equals(exchange.getProperty("javax.jbi.messaging.sendSync"));
        if (txSync) {
            this.getContext().getDeliveryChannel().sendSync(exchange);
        } else {
            this.getContext().getDeliveryChannel().send(exchange);
        }
    }

    private void handleJBIFault(Message message, String detail) {
        Document doc = DomUtil.createDocument();
        Element jbiFault = DomUtil.createElement((Node)doc, (QName)new QName("http://java.sun.com/xml/ns/jbi/wsdl-11-wrapper", "JBIFault"));
        Element jbiFaultDetail = DomUtil.createElement((Node)jbiFault, (QName)new QName("", "detail"));
        jbiFaultDetail.setTextContent(detail);
        jbiFault.appendChild(jbiFaultDetail);
        message.setContent(Source.class, (Object)new DOMSource(doc));
        message.put((Object)"jbiFault", (Object)true);
    }

    @Override
    public List<Interceptor<? extends Message>> getOutFaultInterceptors() {
        return this.outFault;
    }

    @Override
    public List<Interceptor<? extends Message>> getInFaultInterceptors() {
        return this.inFault;
    }

    @Override
    public List<Interceptor<? extends Message>> getInInterceptors() {
        return this.in;
    }

    @Override
    public List<Interceptor<? extends Message>> getOutInterceptors() {
        return this.out;
    }

    @Override
    public void setInInterceptors(List<Interceptor<? extends Message>> interceptors) {
        this.in.addAll(interceptors);
    }

    @Override
    public void setInFaultInterceptors(List<Interceptor<? extends Message>> interceptors) {
        this.inFault.addAll(interceptors);
    }

    @Override
    public void setOutInterceptors(List<Interceptor<? extends Message>> interceptors) {
        this.out.addAll(interceptors);
    }

    @Override
    public void setOutFaultInterceptors(List<Interceptor<? extends Message>> interceptors) {
        this.outFault.addAll(interceptors);
    }

    public void setWsdl(Resource wsdl) {
        this.wsdl = wsdl;
    }

    public Resource getWsdl() {
        return this.wsdl;
    }

    public void validate() throws DeploymentException {
        block10: {
            try {
                if (this.definition != null) break block10;
                if (this.wsdl == null) {
                    throw new DeploymentException("wsdl property must be set");
                }
                this.description = DomUtil.parse((InputStream)this.wsdl.getInputStream());
                WSDLFactory wsdlFactory = WSDLFactory.newInstance();
                WSDLReader reader = wsdlFactory.newWSDLReader();
                reader.setFeature("javax.wsdl.verbose", false);
                try {
                    OASISCatalogManager.getCatalogManager((Bus)this.getBus()).loadContextCatalogs();
                    this.definition = ((WSDLManager)this.getBus().getExtension(WSDLManager.class)).getDefinition(this.wsdl.getURL());
                }
                catch (WSDLException ex) {
                    // empty catch block
                }
                WSDLServiceFactory factory = new WSDLServiceFactory(this.getBus(), this.definition, this.service);
                this.cxfService = factory.create();
                this.ei = (EndpointInfo)((ServiceInfo)this.cxfService.getServiceInfos().iterator().next()).getEndpoints().iterator().next();
                for (ServiceInfo serviceInfo : this.cxfService.getServiceInfos()) {
                    if (!serviceInfo.getName().equals(this.service) || this.getEndpoint() == null || serviceInfo.getEndpoint(new QName(serviceInfo.getName().getNamespaceURI(), this.getEndpoint())) == null) continue;
                    this.ei = serviceInfo.getEndpoint(new QName(serviceInfo.getName().getNamespaceURI(), this.getEndpoint()));
                }
                ServiceInfo serInfo = new ServiceInfo();
                HashMap<String, Element> schemaList = new HashMap<String, Element>();
                SchemaUtil schemaUtil = new SchemaUtil(this.bus, schemaList);
                schemaUtil.getSchemas(this.definition, serInfo);
                serInfo = this.ei.getService();
                ArrayList<ServiceInfo> serviceInfos = new ArrayList<ServiceInfo>();
                serviceInfos.add(serInfo);
                ServiceWSDLBuilder swBuilder = new ServiceWSDLBuilder(this.getBus(), serviceInfos);
                serInfo.setProperty(WSDLServiceBuilder.WSDL_DEFINITION, null);
                serInfo.getInterface().setProperty(WSDLServiceBuilder.WSDL_PORTTYPE, null);
                for (OperationInfo opInfo : serInfo.getInterface().getOperations()) {
                    opInfo.setProperty(WSDLServiceBuilder.WSDL_OPERATION, null);
                }
                this.description = WSDLFactory.newInstance().newWSDLWriter().getDocument(swBuilder.build());
                if (this.endpoint == null) {
                    this.endpoint = this.ei.getName().getLocalPart();
                }
                this.ep = new EndpointImpl(this.getBus(), this.cxfService, this.ei);
                this.ep.putAll(this.getProperties());
                if (this.locationURI != null) {
                    this.ei.setAddress(this.locationURI.toString());
                }
                ConduitInitiatorManager conduitMgr = (ConduitInitiatorManager)this.getBus().getExtension(ConduitInitiatorManager.class);
                this.conduitInit = conduitMgr.getConduitInitiator(this.ei.getTransportId());
                this.conduit = this.conduitInit.getConduit(this.ei);
                CxfBcProviderMessageObserver obs = new CxfBcProviderMessageObserver(this);
                this.conduit.setMessageObserver((MessageObserver)obs);
                this.checkWSRMInterceptors();
                super.validate();
            }
            catch (DeploymentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DeploymentException((Throwable)e);
            }
        }
    }

    private void checkWSRMInterceptors() {
        for (Interceptor interceptor : this.getBus().getOutInterceptors()) {
            if (!interceptor.getClass().getName().equals("org.apache.cxf.ws.rm.RMOutInterceptor")) continue;
            this.ep.getOutInterceptors().add(new SoapOutInterceptor(this.getBus()));
            this.ep.getOutInterceptors().add(new StaxOutInterceptor());
            this.ep.getInInterceptors().add(new StaxInInterceptor());
            this.ep.getInInterceptors().add(new ReadHeadersInterceptor(this.getBus()));
            break;
        }
    }

    private BindingOperationInfo findOperation(NormalizedMessage nm, Message message, BindingOperationInfo boi, MessageExchange exchange) throws TransformerException, ParserConfigurationException, IOException, SAXException {
        Element element = new SourceTransformer().toDOMElement(nm.getContent());
        if (!this.useJBIWrapper) {
            Element bodyElement;
            SoapVersion soapVersion = ((SoapMessage)message).getVersion();
            if (element != null && (bodyElement = (Element)element.getElementsByTagNameNS(element.getNamespaceURI(), soapVersion.getBody().getLocalPart()).item(0)) != null) {
                element = DomUtil.getFirstChildElement((Node)bodyElement);
            }
        } else {
            element = DomUtil.getFirstChildElement((Node)DomUtil.getFirstChildElement((Node)element));
        }
        QName opeName = new QName(element.getNamespaceURI(), element.getLocalName());
        SoapBindingInfo binding = (SoapBindingInfo)this.ei.getBinding();
        for (BindingOperationInfo op : binding.getOperations()) {
            String style = binding.getStyle(op.getOperationInfo());
            if (style == null) {
                style = binding.getStyle();
            }
            if ("document".equals(style)) {
                BindingMessageInfo msg = op.getInput();
                if (!((MessagePartInfo)((SoapBodyInfo)msg.getExtensor(SoapBodyInfo.class)).getParts().get(0)).getElementQName().equals(opeName)) continue;
                boi = op;
                exchange.setOperation(new QName(boi.getName().getNamespaceURI(), opeName.getLocalPart()));
                break;
            }
            throw new org.apache.cxf.interceptor.Fault((Throwable)new Exception("Operation must bound on this MessageExchange if use rpc mode"));
        }
        if (boi == null) {
            throw new org.apache.cxf.interceptor.Fault((Throwable)new Exception("Operation not bound on this MessageExchange"));
        }
        return boi;
    }

    public void start() throws Exception {
        this.applyFeatures();
        super.start();
    }

    private void applyFeatures() {
        ClientImpl client = new ClientImpl(this.getBus(), this.ep, this.conduit);
        if (this.getFeatures() != null) {
            for (AbstractFeature feature : this.getFeatures()) {
                feature.initialize((Client)client, this.getBus());
            }
        }
    }

    protected Bus getBus() {
        if (this.providedBus != null) {
            return this.providedBus;
        }
        if (this.getBusCfg() != null) {
            if (this.bus == null) {
                SpringBusFactory bf = new SpringBusFactory();
                this.bus = bf.createBus(this.getBusCfg());
            }
            return this.bus;
        }
        return ((CxfBcComponent)this.getServiceUnit().getComponent()).getBus();
    }

    public void setBusCfg(String busCfg) {
        this.busCfg = busCfg;
    }

    public String getBusCfg() {
        return this.busCfg;
    }

    public void setLocationURI(URI locationURI) {
        this.locationURI = locationURI;
    }

    public URI getLocationURI() {
        return this.locationURI;
    }

    Endpoint getCxfEndpoint() {
        return this.ep;
    }

    EndpointInfo getEndpointInfo() {
        return this.ei;
    }

    public void setMtomEnabled(boolean mtomEnabled) {
        this.mtomEnabled = mtomEnabled;
    }

    public boolean isMtomEnabled() {
        return this.mtomEnabled;
    }

    public void setUseJBIWrapper(boolean useJBIWrapper) {
        this.useJBIWrapper = useJBIWrapper;
    }

    public boolean isUseJBIWrapper() {
        return this.useJBIWrapper;
    }

    public void setUseSOAPEnvelope(boolean useSOAPEnvelope) {
        this.useSOAPEnvelope = useSOAPEnvelope;
    }

    public boolean isUseSOAPEnvelope() {
        return this.useSOAPEnvelope;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setFeatures(List<AbstractFeature> features) {
        this.features = features;
    }

    public List<AbstractFeature> getFeatures() {
        return this.features;
    }

    public boolean isSchemaValidationEnabled() {
        return this.schemaValidationEnabled;
    }

    public void setSchemaValidationEnabled(boolean schemaValidationEnabled) {
        this.schemaValidationEnabled = schemaValidationEnabled;
    }

    public void setProvidedBus(Bus providedBus) {
        this.providedBus = providedBus;
    }

    public Bus getProvidedBus() {
        return this.providedBus;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }
}

