/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxfbc.interceptors;

import javax.jbi.messaging.MessageExchange;
import javax.xml.namespace.QName;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.addressing.AddressingPropertiesImpl;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.servicemix.common.util.URIResolver;
import org.apache.servicemix.cxfbc.CxfBcConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JbiAddressingInterceptor
extends AbstractPhaseInterceptor<Message> {
    public JbiAddressingInterceptor() {
        super("invoke");
        this.getBefore().add(CxfBcConsumer.JbiInvokerInterceptor.class.getName());
    }

    public void handleMessage(Message message) throws Fault {
        String toAddress;
        AttributedURIType to;
        String value;
        AddressingPropertiesImpl maps = ContextUtils.retrieveMAPs((Message)message, (boolean)false, (boolean)false);
        if (null == maps) {
            return;
        }
        AttributedURIType action = maps.getAction();
        if (action != null && (value = action.getValue()) != null && value.endsWith("JBIADDRESS")) {
            value = value.substring(0, value.indexOf("JBIADDRESS") - 1);
            String[] parts = URIResolver.split3((String)value);
            MessageExchange exchange = (MessageExchange)message.getContent(MessageExchange.class);
            exchange.setOperation(new QName(parts[0], parts[2]));
            exchange.setInterfaceName(new QName(parts[0], parts[1]));
        }
        if ((to = maps.getTo()) != null && (toAddress = to.getValue()) != null && toAddress.endsWith("JBIADDRESS")) {
            toAddress = toAddress.substring(0, toAddress.indexOf("JBIADDRESS") - 1);
            String[] parts = URIResolver.split3((String)toAddress);
            MessageExchange exchange = (MessageExchange)message.getContent(MessageExchange.class);
            exchange.setService(new QName(parts[0], parts[1]));
        }
    }
}

