/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxfbc.interceptors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.model.SoapBindingInfo;
import org.apache.cxf.binding.soap.model.SoapHeaderInfo;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.servicemix.cxfbc.interceptors.CxfJbiConstants;
import org.apache.servicemix.soap.util.stax.ExtendedXMLStreamReader;
import org.apache.servicemix.soap.util.stax.FragmentStreamReader;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class StaxJbiWrapper
implements XMLStreamReader {
    public static final int STATE_START_DOC = 0;
    public static final int STATE_START_ELEMENT_WRAPPER = 1;
    public static final int STATE_START_ELEMENT_PART = 2;
    public static final int STATE_RUN_PART = 3;
    public static final int STATE_END_ELEMENT_PART = 4;
    public static final int STATE_END_ELEMENT_WRAPPER = 5;
    public static final int STATE_END_DOC = 6;
    private BindingMessageInfo wsdlMessage;
    private int state = 0;
    private int part = -1;
    private int reader = -1;
    private int event = 7;
    private List<List<XMLStreamReader>> parts = new ArrayList<List<XMLStreamReader>>();
    private List<QName> extraPrefixes = new ArrayList<QName>();

    public StaxJbiWrapper(Message message) {
        this.setExtraPrefix((SoapMessage)message);
        BindingOperationInfo wsdlOperation = this.getOperation(message);
        this.wsdlMessage = !this.isRequestor(message) ? wsdlOperation.getInput() : wsdlOperation.getOutput();
        XMLStreamReader xmlReader = (XMLStreamReader)message.getContent(XMLStreamReader.class);
        if (this.isRequestor(message)) {
            throw new UnsupportedOperationException();
        }
        List headers = this.wsdlMessage.getExtensors(SoapHeaderInfo.class);
        if (headers != null && headers.size() > 0) {
            throw new UnsupportedOperationException();
        }
        SoapBindingInfo binding = (SoapBindingInfo)((Endpoint)message.getExchange().get(Endpoint.class)).getEndpointInfo().getBinding();
        String style = binding.getStyle(wsdlOperation.getOperationInfo());
        if (style == null) {
            style = binding.getStyle();
        }
        int nbBodyParts = 0;
        for (MessagePartInfo part : this.wsdlMessage.getMessageParts()) {
            if (nbBodyParts++ > 0) {
                throw new UnsupportedOperationException();
            }
            if ("document".equals(style)) {
                this.parts.add(Collections.singletonList(new FragmentStreamReader(xmlReader)));
                continue;
            }
            throw new UnsupportedOperationException();
        }
    }

    private void setExtraPrefix(SoapMessage message) {
        Document savedEnv = (Document)message.getContent(Node.class);
        if (savedEnv != null) {
            NamedNodeMap attrs = savedEnv.getFirstChild().getAttributes();
            HashMap<String, String> nsMap = message.getEnvelopeNs();
            if (nsMap == null) {
                nsMap = new HashMap<String, String>();
            }
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node node = attrs.item(i);
                if (node.getNodeValue().equals("http://schemas.xmlsoap.org/soap/envelope/") || node.getNodeValue().equals("http://www.w3.org/2003/05/soap-envelope")) continue;
                nsMap.put(node.getLocalName(), node.getNodeValue());
                if (node.getNodeValue().equals("http://www.w3.org/2001/XMLSchema-instance") || node.getNodeValue().equals("http://www.w3.org/2001/XMLSchema")) continue;
                this.extraPrefixes.add(new QName(node.getNodeValue(), "", node.getLocalName()));
            }
            if (nsMap.size() > 0) {
                message.put("soap.env.ns.map", nsMap);
            }
        }
    }

    public int getEventType() {
        return this.event;
    }

    public int next() throws XMLStreamException {
        switch (this.state) {
            case 0: {
                this.state = 1;
                this.event = 1;
                break;
            }
            case 1: {
                if (this.parts.size() > 0) {
                    this.state = 2;
                    this.event = 1;
                    this.part = 0;
                    this.reader = 0;
                    break;
                }
                this.state = 5;
                this.event = 2;
                break;
            }
            case 2: {
                if (this.reader >= this.parts.get(this.part).size()) {
                    this.state = 4;
                    this.event = 2;
                    break;
                }
                this.state = 3;
                this.event = this.parts.get(this.part).get(this.reader).next();
                if (this.event != 7) break;
                this.event = this.parts.get(this.part).get(this.reader).next();
                break;
            }
            case 3: {
                this.event = this.parts.get(this.part).get(this.reader).next();
                if (this.event != 8) break;
                if (++this.reader >= this.parts.get(this.part).size()) {
                    this.state = 4;
                    this.event = 2;
                    break;
                }
                this.event = this.parts.get(this.part).get(this.reader).next();
                if (this.event != 7) break;
                this.event = this.parts.get(this.part).get(this.reader).next();
                break;
            }
            case 4: {
                if (++this.part >= this.parts.size()) {
                    this.state = 5;
                    this.event = 2;
                    break;
                }
                this.state = 2;
                this.event = 1;
                this.reader = 0;
                break;
            }
            case 5: 
            case 6: {
                this.state = 6;
                this.event = 8;
            }
        }
        return this.event;
    }

    public QName getName() {
        switch (this.state) {
            case 1: 
            case 5: {
                return CxfJbiConstants.WSDL11_WRAPPER_MESSAGE;
            }
            case 2: 
            case 4: {
                return CxfJbiConstants.WSDL11_WRAPPER_PART;
            }
            case 3: {
                return this.parts.get(this.part).get(this.reader).getName();
            }
        }
        throw new IllegalStateException();
    }

    public String getLocalName() {
        switch (this.state) {
            case 1: 
            case 5: {
                return "message";
            }
            case 2: 
            case 4: {
                return "part";
            }
            case 3: {
                return this.parts.get(this.part).get(this.reader).getLocalName();
            }
        }
        throw new IllegalStateException();
    }

    public String getNamespaceURI() {
        switch (this.state) {
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                return "http://java.sun.com/xml/ns/jbi/wsdl-11-wrapper";
            }
            case 3: {
                return this.parts.get(this.part).get(this.reader).getNamespaceURI();
            }
        }
        throw new IllegalStateException();
    }

    public String getPrefix() {
        switch (this.state) {
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                return "jbi";
            }
            case 3: {
                String namespaceURI;
                String prefix = this.parts.get(this.part).get(this.reader).getPrefix();
                if (prefix != null && prefix.length() == 0 && (namespaceURI = this.parts.get(this.part).get(this.reader).getNamespaceURI()) != null && namespaceURI.length() > 0) {
                    return "part";
                }
                return prefix;
            }
        }
        throw new IllegalStateException();
    }

    public boolean hasName() {
        return this.state == 3 ? this.parts.get(this.part).get(this.reader).isStartElement() : this.event == 1 || this.event == 2;
    }

    public Object getProperty(String s) throws IllegalArgumentException {
        return null;
    }

    public void require(int i, String s, String s1) throws XMLStreamException {
    }

    public String getElementText() throws XMLStreamException {
        return null;
    }

    public int nextTag() throws XMLStreamException {
        while (this.hasNext()) {
            int e = this.next();
            if (e != 1 && e != 2) continue;
            return e;
        }
        return this.event;
    }

    public boolean hasNext() throws XMLStreamException {
        return this.event != 8;
    }

    public void close() throws XMLStreamException {
    }

    public String getNamespaceURI(String s) {
        return null;
    }

    public boolean isStartElement() {
        return this.state == 3 ? this.parts.get(this.part).get(this.reader).isStartElement() : this.event == 1;
    }

    public boolean isEndElement() {
        return this.state == 3 ? this.parts.get(this.part).get(this.reader).isEndElement() : this.event == 2;
    }

    public boolean isCharacters() {
        return this.state == 3 ? this.parts.get(this.part).get(this.reader).isCharacters() : this.event == 4;
    }

    public boolean isWhiteSpace() {
        return this.state == 3 ? this.parts.get(this.part).get(this.reader).isWhiteSpace() : this.event == 6;
    }

    public String getAttributeValue(String s, String s1) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int getAttributeCount() {
        switch (this.state) {
            case 1: {
                return 7 + this.extraPrefixes.size();
            }
            case 2: {
                return 0;
            }
            case 3: {
                return this.parts.get(this.part).get(this.reader).getAttributeCount();
            }
        }
        throw new IllegalStateException();
    }

    public QName getAttributeName(int i) {
        switch (this.state) {
            case 1: {
                switch (i) {
                    case 0: {
                        return new QName("http://www.w3.org/2000/xmlns/", "jbi", "xmlns");
                    }
                    case 1: {
                        return new QName("http://www.w3.org/2000/xmlns/", "msg", "xmlns");
                    }
                    case 2: {
                        return new QName("type");
                    }
                    case 3: {
                        return new QName("name");
                    }
                    case 4: {
                        return new QName("version");
                    }
                    case 5: {
                        return new QName("http://www.w3.org/2000/xmlns/", "xsi", "xmlns");
                    }
                    case 6: {
                        return new QName("http://www.w3.org/2000/xmlns/", "xsd", "xmlns");
                    }
                }
                if (i < this.getAttributeCount()) {
                    return new QName("http://www.w3.org/2000/xmlns/", this.extraPrefixes.get(i - 7).getPrefix(), "xmlns");
                }
                throw new IllegalStateException();
            }
            case 3: {
                return this.parts.get(this.part).get(this.reader).getAttributeName(i);
            }
        }
        throw new IllegalStateException();
    }

    public String getAttributeNamespace(int i) {
        switch (this.state) {
            case 1: {
                switch (i) {
                    case 0: 
                    case 1: {
                        return "http://www.w3.org/2000/xmlns/";
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        return "";
                    }
                    case 5: {
                        return "http://www.w3.org/2000/xmlns/";
                    }
                    case 6: {
                        return "http://www.w3.org/2000/xmlns/";
                    }
                }
                if (i < this.getAttributeCount()) {
                    return "http://www.w3.org/2000/xmlns/";
                }
                throw new IllegalStateException();
            }
            case 3: {
                return this.parts.get(this.part).get(this.reader).getAttributeNamespace(i);
            }
        }
        throw new IllegalStateException();
    }

    public String getAttributeLocalName(int i) {
        switch (this.state) {
            case 1: {
                switch (i) {
                    case 0: {
                        return "jbi";
                    }
                    case 1: {
                        return "msg";
                    }
                    case 2: {
                        return "type";
                    }
                    case 3: {
                        return "name";
                    }
                    case 4: {
                        return "version";
                    }
                    case 5: {
                        return "xsi";
                    }
                    case 6: {
                        return "xsd";
                    }
                }
                if (i < this.getAttributeCount()) {
                    return this.extraPrefixes.get(i - 7).getPrefix();
                }
                throw new IllegalStateException();
            }
            case 3: {
                return this.parts.get(this.part).get(this.reader).getAttributeLocalName(i);
            }
        }
        throw new IllegalStateException();
    }

    public String getAttributePrefix(int i) {
        switch (this.state) {
            case 1: {
                switch (i) {
                    case 0: {
                        return "xmlns";
                    }
                    case 1: {
                        return "xmlns";
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        return "";
                    }
                    case 5: {
                        return "xmlns";
                    }
                    case 6: {
                        return "xmlns";
                    }
                }
                if (i < this.getAttributeCount()) {
                    return "xmlns";
                }
                throw new IllegalStateException();
            }
            case 3: {
                return this.parts.get(this.part).get(this.reader).getAttributePrefix(i);
            }
        }
        throw new IllegalStateException();
    }

    public String getAttributeType(int i) {
        return "CDATA";
    }

    public String getAttributeValue(int i) {
        switch (this.state) {
            case 1: {
                switch (i) {
                    case 0: {
                        return "http://java.sun.com/xml/ns/jbi/wsdl-11-wrapper";
                    }
                    case 1: {
                        String typeNamespace = this.wsdlMessage.getMessageInfo().getName().getNamespaceURI();
                        if (typeNamespace == null || typeNamespace.length() == 0) {
                            throw new IllegalArgumentException("messageType namespace is null or empty");
                        }
                        return typeNamespace;
                    }
                    case 2: {
                        String typeLocalName = this.wsdlMessage.getMessageInfo().getName().getLocalPart();
                        if (typeLocalName == null || typeLocalName.length() == 0) {
                            throw new IllegalArgumentException("messageType local name is null or empty");
                        }
                        return "msg:" + typeLocalName;
                    }
                    case 3: {
                        return this.wsdlMessage.getMessageInfo().getName().getLocalPart().toString();
                    }
                    case 4: {
                        return "1.0";
                    }
                    case 5: {
                        return "http://www.w3.org/2001/XMLSchema-instance";
                    }
                    case 6: {
                        return "http://www.w3.org/2001/XMLSchema";
                    }
                }
                if (i < this.getAttributeCount()) {
                    return this.extraPrefixes.get(i - 7).getNamespaceURI();
                }
                throw new IllegalStateException();
            }
            case 3: {
                return this.parts.get(this.part).get(this.reader).getAttributeValue(i);
            }
        }
        throw new IllegalStateException();
    }

    public boolean isAttributeSpecified(int i) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int getNamespaceCount() {
        switch (this.state) {
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                return 0;
            }
            case 3: {
                return this.parts.get(this.part).get(this.reader).getNamespaceCount();
            }
        }
        throw new IllegalStateException();
    }

    public String getNamespacePrefix(int i) {
        String prefix = this.parts.get(this.part).get(this.reader).getNamespacePrefix(i);
        if (prefix != null && prefix.length() == 0 && this.parts.get(this.part).get(this.reader).getNamespaceURI().length() > 0) {
            return "part";
        }
        return prefix;
    }

    public String getNamespaceURI(int i) {
        return this.parts.get(this.part).get(this.reader).getNamespaceURI(i);
    }

    public NamespaceContext getNamespaceContext() {
        if (this.state == 3) {
            return this.parts.get(this.part).get(this.reader).getNamespaceContext();
        }
        return new ExtendedXMLStreamReader.SimpleNamespaceContext();
    }

    public String getText() {
        if (this.state == 3) {
            return this.parts.get(this.part).get(this.reader).getText();
        }
        throw new IllegalStateException();
    }

    public char[] getTextCharacters() {
        if (this.state == 3) {
            return this.parts.get(this.part).get(this.reader).getTextCharacters();
        }
        throw new IllegalStateException();
    }

    public int getTextCharacters(int i, char[] chars, int i1, int i2) throws XMLStreamException {
        if (this.state == 3) {
            return this.parts.get(this.part).get(this.reader).getTextCharacters(i, chars, i1, i2);
        }
        throw new IllegalStateException();
    }

    public int getTextStart() {
        if (this.state == 3) {
            return this.parts.get(this.part).get(this.reader).getTextStart();
        }
        throw new IllegalStateException();
    }

    public int getTextLength() {
        if (this.state == 3) {
            return this.parts.get(this.part).get(this.reader).getTextLength();
        }
        throw new IllegalStateException();
    }

    public String getEncoding() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean hasText() {
        if (this.state == 3) {
            return this.parts.get(this.part).get(this.reader).hasText();
        }
        return false;
    }

    public Location getLocation() {
        return new Location(){

            public int getCharacterOffset() {
                return 0;
            }

            public int getColumnNumber() {
                return 0;
            }

            public int getLineNumber() {
                return 0;
            }

            public String getPublicId() {
                return null;
            }

            public String getSystemId() {
                return null;
            }
        };
    }

    public String getVersion() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isStandalone() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean standaloneSet() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getCharacterEncodingScheme() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getPITarget() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getPIData() {
        throw new UnsupportedOperationException("Not implemented");
    }

    private BindingOperationInfo getOperation(Message message) {
        BindingOperationInfo operation = (BindingOperationInfo)message.getExchange().get(BindingOperationInfo.class);
        if (operation == null) {
            throw new Fault((Throwable)new Exception("Operation not bound on this message"));
        }
        return operation;
    }

    private boolean isRequestor(Message message) {
        return Boolean.TRUE.equals(message.get((Object)"org.apache.cxf.client"));
    }
}

