/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.SecureConversationToken;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.Constants;
import org.apache.neethi.Policy;
import org.apache.neethi.builders.AssertionBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecureConversationTokenBuilder
implements AssertionBuilder<Element> {
    private static final QName[] KNOWN_ELEMENTS = new QName[]{SP11Constants.SECURE_CONVERSATION_TOKEN, SP12Constants.SECURE_CONVERSATION_TOKEN};
    PolicyBuilder builder;

    public SecureConversationTokenBuilder(PolicyBuilder b) {
        this.builder = b;
    }

    public QName[] getKnownElements() {
        return KNOWN_ELEMENTS;
    }

    public Assertion build(Element element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        SPConstants consts = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        SecureConversationToken conversationToken = new SecureConversationToken(consts);
        conversationToken.setOptional(PolicyConstants.isOptional((Element)element));
        conversationToken.setIgnorable(PolicyConstants.isIgnorable((Element)element));
        String attribute = DOMUtils.getAttribute((Element)element, (QName)consts.getIncludeToken());
        if (attribute == null) {
            throw new IllegalArgumentException("SecurityContextToken doesn't contain any sp:IncludeToken attribute");
        }
        String inclusionValue = attribute.trim();
        conversationToken.setInclusion(consts.getInclusionFromAttributeValue(inclusionValue));
        Element elem = DOMUtils.getFirstElement((Node)element);
        while (elem != null) {
            QName qn = DOMUtils.getElementQName((Element)elem);
            if (Constants.isPolicyElement((QName)qn)) {
                Element bootstrapPolicyElement;
                if (DOMUtils.getFirstChildWithName((Element)elem, (String)consts.getNamespace(), (String)"RequireDerivedKeys") != null) {
                    conversationToken.setDerivedKeys(true);
                } else if (DOMUtils.getFirstChildWithName((Element)elem, (QName)SP12Constants.REQUIRE_IMPLIED_DERIVED_KEYS) != null) {
                    conversationToken.setImpliedDerivedKeys(true);
                } else if (DOMUtils.getFirstChildWithName((Element)elem, (QName)SP12Constants.REQUIRE_EXPLICIT_DERIVED_KEYS) != null) {
                    conversationToken.setExplicitDerivedKeys(true);
                }
                if (DOMUtils.getFirstChildWithName((Element)elem, (String)consts.getNamespace(), (String)"RequireExternalUriReference") != null) {
                    conversationToken.setRequireExternalUriRef(true);
                }
                if (DOMUtils.getFirstChildWithName((Element)elem, (String)consts.getNamespace(), (String)"SC10SecurityContextToken") != null) {
                    conversationToken.setSc10SecurityContextToken(true);
                }
                if ((bootstrapPolicyElement = DOMUtils.getFirstChildWithName((Element)elem, (String)consts.getNamespace(), (String)"BootstrapPolicy")) != null) {
                    Policy policy = this.builder.getPolicy((Object)DOMUtils.getFirstElement((Node)bootstrapPolicyElement));
                    conversationToken.setBootstrapPolicy(policy);
                }
            } else if (consts.getNamespace().equals(qn.getNamespaceURI()) && "Issuer".equals(qn.getLocalPart())) {
                conversationToken.setIssuerEpr(DOMUtils.getFirstElement((Node)elem));
            }
            elem = DOMUtils.getNextElement((Element)elem);
        }
        return conversationToken;
    }
}

