/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.trust;

import java.util.List;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.trust.STSClient;
import org.apache.cxf.ws.security.trust.STSSamlAssertionValidator;
import org.apache.cxf.ws.security.trust.STSUtils;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.validate.Credential;
import org.apache.ws.security.validate.Validator;

public class STSTokenValidator
implements Validator {
    private STSSamlAssertionValidator samlValidator = new STSSamlAssertionValidator();
    private boolean alwaysValidateToSts;

    public STSTokenValidator() {
    }

    public STSTokenValidator(boolean alwaysValidateToSts) {
        this.alwaysValidateToSts = alwaysValidateToSts;
    }

    public Credential validate(Credential credential, RequestData data) throws WSSecurityException {
        if (this.isValidatedLocally(credential, data)) {
            return credential;
        }
        return this.validateWithSTS(credential, (Message)((SoapMessage)data.getMsgContext()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Credential validateWithSTS(Credential credential, Message message) throws WSSecurityException {
        SecurityToken token = new SecurityToken();
        try {
            STSClient c;
            if (credential.getAssertion() != null) {
                token.setToken(credential.getAssertion().getElement());
            } else if (credential.getUsernametoken() != null) {
                token.setToken(credential.getUsernametoken().getElement());
            } else if (credential.getBinarySecurityToken() != null) {
                token.setToken(credential.getBinarySecurityToken().getElement());
            }
            STSClient sTSClient = c = STSUtils.getClient(message, "sts");
            synchronized (sTSClient) {
                System.setProperty("noprint", "true");
                List<SecurityToken> tokens = c.validateSecurityToken(token);
                SecurityToken returnedToken = tokens.get(0);
                if (returnedToken != token) {
                    AssertionWrapper assertion = new AssertionWrapper(returnedToken.getToken());
                    credential.setTransformedToken(assertion);
                }
                return credential;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WSSecurityException(0, "invalidSAMLsecurity", null, (Throwable)e);
        }
    }

    protected boolean isValidatedLocally(Credential credential, RequestData data) throws WSSecurityException {
        if (!this.alwaysValidateToSts && credential.getAssertion() != null) {
            try {
                this.samlValidator.validate(credential, data);
                return this.samlValidator.isTrustVerificationSucceeded();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new WSSecurityException(0, "invalidSAMLsecurity", null, (Throwable)e);
            }
        }
        return false;
    }
}

