/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxfbc.interceptors;

import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.service.model.ServiceModelUtil;
import org.apache.cxf.wsdl.EndpointReferenceUtils;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.soap.util.DomUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractSchemaValidationInterceptor
extends AbstractSoapInterceptor {
    private boolean useJBIWrapper = true;
    private boolean useSOAPEnvelope = true;

    public AbstractSchemaValidationInterceptor(String phase, boolean useJBIWrapper, boolean useSOAPEnvelope) {
        super(phase);
        this.useJBIWrapper = useJBIWrapper;
        this.useSOAPEnvelope = useSOAPEnvelope;
    }

    protected void validateMessage(SoapMessage message) throws Fault {
        Schema schema;
        Service service = ServiceModelUtil.getService((Exchange)message.getExchange());
        if (service != null && (schema = EndpointReferenceUtils.getSchema((ServiceInfo)((ServiceInfo)service.getServiceInfos().get(0)))) != null) {
            Validator validator = schema.newValidator();
            try {
                Element sourceMessage = new SourceTransformer().toDOMElement((Source)message.getContent(Source.class));
                message.setContent(Source.class, (Object)new DOMSource(sourceMessage));
                if (!this.useJBIWrapper && !this.useSOAPEnvelope) {
                    validator.validate(new DOMSource(sourceMessage));
                } else {
                    Element partWrapper = DomUtil.getFirstChildElement((Node)sourceMessage);
                    while (partWrapper != null) {
                        Element partContent = DomUtil.getFirstChildElement((Node)partWrapper);
                        validator.validate(new DOMSource(partContent));
                        partWrapper = DomUtil.getNextSiblingElement((Element)partWrapper);
                    }
                }
            }
            catch (Exception e) {
                throw new Fault((Throwable)e);
            }
        }
    }
}

