/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxfbc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOptionalOut;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.MustUnderstandInterceptor;
import org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor;
import org.apache.cxf.binding.soap.interceptor.StartBodyInterceptor;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.AttachmentInInterceptor;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.interceptor.StaxInInterceptor;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.phase.PhaseManager;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.RelatesToType;
import org.apache.cxf.ws.addressing.soap.MAPCodec;
import org.apache.servicemix.cxfbc.CxfBcProvider;
import org.apache.servicemix.cxfbc.interceptors.JbiInWsdl1Interceptor;
import org.apache.servicemix.cxfbc.interceptors.SchemaValidationInInterceptor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class CxfBcProviderMessageObserver
implements MessageObserver {
    ByteArrayOutputStream response = new ByteArrayOutputStream();
    boolean written;
    String contentType;
    private CxfBcProvider providerEndpoint;
    private MessageObserver sharedMessageObserver;

    public CxfBcProviderMessageObserver(CxfBcProvider providerEndpoint) {
        this.providerEndpoint = providerEndpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayOutputStream getResponseStream() throws Exception {
        CxfBcProviderMessageObserver cxfBcProviderMessageObserver = this;
        synchronized (cxfBcProviderMessageObserver) {
            if (!this.written) {
                this.wait(1000000000L);
            }
        }
        return this.response;
    }

    public String getResponseContentType() {
        return this.contentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        try {
            boolean txSync;
            NormalizedMessage msg;
            Object pm = (PhaseManager)this.providerEndpoint.getBus().getExtension(PhaseManager.class);
            ArrayList<Object> inList = new ArrayList<Object>();
            inList.add(new ReadHeadersInterceptor(this.providerEndpoint.getBus()));
            inList.add(new StartBodyInterceptor());
            inList.add(new MustUnderstandInterceptor());
            inList.add(new StaxInInterceptor());
            inList.add((Object)new JbiInWsdl1Interceptor(this.providerEndpoint.isUseJBIWrapper(), this.providerEndpoint.isUseSOAPEnvelope()));
            if (this.providerEndpoint.isSchemaValidationEnabled()) {
                inList.add((Object)new SchemaValidationInInterceptor(this.providerEndpoint.isUseJBIWrapper(), this.providerEndpoint.isUseSOAPEnvelope()));
            }
            inList.add(new AttachmentInInterceptor());
            PhaseInterceptorChain inChain = new PhaseInterceptorChain(pm.getInPhases());
            inChain.add((Collection)this.providerEndpoint.getBus().getInInterceptors());
            inChain.add(inList);
            inChain.add(this.providerEndpoint.getInInterceptors());
            this.contentType = (String)message.get((Object)"Content-Type");
            SoapMessage soapMessage = (SoapMessage)this.providerEndpoint.getCxfEndpoint().getBinding().createMessage(message);
            soapMessage.put("org.apache.cxf.client", (Object)true);
            soapMessage.setInterceptorChain((InterceptorChain)inChain);
            MessageExchange messageExchange = (MessageExchange)soapMessage.getExchange().get(MessageExchange.class);
            if (messageExchange == null) {
                MessageObserver messageObserver = (MessageObserver)message.getExchange().get(MessageObserver.class);
                if (messageObserver != null) {
                    messageObserver.onMessage(message);
                    return;
                }
                Exchange exchange = this.restoreExchange(soapMessage);
                Node nd = (Node)soapMessage.getContent(Node.class);
                if (nd instanceof Document) {
                    soapMessage.setContent(Node.class, (Object)((Document)nd).getDocumentElement());
                }
                if (exchange != null) {
                    MessageObserver rmMessageObserver = (MessageObserver)exchange.get(MessageObserver.class);
                    if (rmMessageObserver != null) {
                        this.sharedMessageObserver = rmMessageObserver;
                        rmMessageObserver.onMessage((Message)soapMessage);
                        return;
                    }
                } else if (this.sharedMessageObserver != null) {
                    this.sharedMessageObserver.onMessage((Message)soapMessage);
                    return;
                }
            }
            if (messageExchange != null && messageExchange.getStatus() != ExchangeStatus.ACTIVE) {
                return;
            }
            Node nd = (Node)soapMessage.getContent(Node.class);
            if (nd instanceof Document) {
                soapMessage.setContent(Node.class, (Object)((Document)nd).getDocumentElement());
            }
            inChain.doIntercept((Message)soapMessage);
            this.closeConnectionStream(soapMessage);
            if (soapMessage.getContent(Exception.class) != null || soapMessage.getContent(Source.class) == null) {
                Exception ex = (Exception)soapMessage.getContent(Exception.class);
                if (!(soapMessage.getExchange().get(MessageExchange.class) instanceof InOnly) && ex != null) {
                    messageExchange.setStatus(ExchangeStatus.ERROR);
                    messageExchange.setError(ex);
                    this.providerEndpoint.getContext().getDeliveryChannel().send(messageExchange);
                }
                return;
            }
            messageExchange = (MessageExchange)soapMessage.getExchange().get(MessageExchange.class);
            if (MessageUtils.isPartialResponse((Message)soapMessage)) {
                return;
            }
            if (((BindingOperationInfo)soapMessage.getExchange().get(BindingOperationInfo.class)).getOperationInfo().isOneWay()) {
                messageExchange.setStatus(ExchangeStatus.DONE);
            } else if (soapMessage.get((Object)"jbiFault") != null && soapMessage.get((Object)"jbiFault").equals(true)) {
                Fault fault = messageExchange.createFault();
                fault.setContent((Source)soapMessage.getContent(Source.class));
                messageExchange.setFault(fault);
                if (soapMessage.get((Object)"faultstring") != null) {
                    messageExchange.setProperty("faultstring", soapMessage.get((Object)"faultstring"));
                }
                if (soapMessage.get((Object)"faultcode") != null) {
                    messageExchange.setProperty("faultcode", soapMessage.get((Object)"faultcode"));
                }
                if (soapMessage.get((Object)"hasdetail") != null) {
                    messageExchange.setProperty("hasdetail", soapMessage.get((Object)"hasdetail"));
                }
            } else if (messageExchange instanceof InOut) {
                msg = messageExchange.createMessage();
                msg.setContent((Source)soapMessage.getContent(Source.class));
                this.toNMSAttachments(msg, (Message)soapMessage);
                messageExchange.setMessage(msg, "out");
            } else if (messageExchange instanceof InOptionalOut) {
                if (soapMessage.getContent(Source.class) != null) {
                    msg = messageExchange.createMessage();
                    msg.setContent((Source)soapMessage.getContent(Source.class));
                    this.toNMSAttachments(msg, (Message)soapMessage);
                    messageExchange.setMessage(msg, "out");
                } else {
                    messageExchange.setStatus(ExchangeStatus.DONE);
                }
            } else {
                messageExchange.setStatus(ExchangeStatus.DONE);
            }
            boolean bl = txSync = messageExchange.getStatus() == ExchangeStatus.ACTIVE && messageExchange.isTransacted() && Boolean.TRUE.equals(messageExchange.getProperty("javax.jbi.messaging.sendSync"));
            if (txSync) {
                this.providerEndpoint.getContext().getDeliveryChannel().sendSync(messageExchange);
            } else {
                this.providerEndpoint.getContext().getDeliveryChannel().send(messageExchange);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            CxfBcProviderMessageObserver cxfBcProviderMessageObserver = this;
            synchronized (cxfBcProviderMessageObserver) {
                this.written = true;
                this.notifyAll();
            }
        }
    }

    private Exchange restoreExchange(SoapMessage message) throws IOException, SAXException, JAXBException {
        InputStream is = (InputStream)message.getContent(InputStream.class);
        CachedOutputStream bos = new CachedOutputStream();
        IOUtils.copy((InputStream)is, (OutputStream)bos);
        bos.flush();
        is.close();
        message.setContent(InputStream.class, (Object)bos.getInputStream());
        ReadHeadersInterceptor readHeadersInterceptor = new ReadHeadersInterceptor(this.providerEndpoint.getBus());
        readHeadersInterceptor.handleMessage(message);
        for (Interceptor interceptor : this.providerEndpoint.getBus().getOutInterceptors()) {
            MAPCodec mapCodec;
            AddressingProperties maps;
            if (!interceptor.getClass().getName().equals("org.apache.cxf.ws.addressing.soap.MAPCodec") || (maps = (mapCodec = (MAPCodec)interceptor).unmarshalMAPs(message)) == null || maps.getRelatesTo() == null || !this.isRelationshipReply(maps.getRelatesTo())) continue;
            Exchange correlatedExchange = (Exchange)mapCodec.getUncorrelatedExchanges().get(maps.getRelatesTo().getValue());
            message.setContent(InputStream.class, (Object)bos.getInputStream());
            bos.close();
            XMLStreamReader xmlReader = StaxUtils.createXMLStreamReader((InputStream)((InputStream)message.getContent(InputStream.class)));
            message.setContent(XMLStreamReader.class, (Object)xmlReader);
            message.setContent(InputStream.class, (Object)bos.getInputStream());
            return correlatedExchange;
        }
        message.setContent(InputStream.class, (Object)bos.getInputStream());
        bos.close();
        XMLStreamReader xmlReader = StaxUtils.createXMLStreamReader((InputStream)((InputStream)message.getContent(InputStream.class)));
        message.setContent(XMLStreamReader.class, (Object)xmlReader);
        message.setContent(InputStream.class, (Object)bos.getInputStream());
        return null;
    }

    private void closeConnectionStream(SoapMessage soapMessage) throws IOException {
        InputStream is = (InputStream)soapMessage.getContent(InputStream.class);
        if (is != null) {
            CachedOutputStream bos = new CachedOutputStream();
            try {
                IOUtils.copy((InputStream)is, (OutputStream)bos);
            }
            catch (IOException e) {
                // empty catch block
            }
            bos.flush();
            is.close();
            soapMessage.setContent(InputStream.class, (Object)bos.getInputStream());
            bos.close();
        }
    }

    private void toNMSAttachments(NormalizedMessage normalizedMessage, Message soapMessage) throws MessagingException {
        if (soapMessage.getAttachments() != null) {
            for (Attachment att : soapMessage.getAttachments()) {
                normalizedMessage.addAttachment(att.getId(), att.getDataHandler());
            }
        }
    }

    private boolean isRelationshipReply(RelatesToType relatesTo) {
        return "http://www.w3.org/2005/08/addressing/reply".equals(relatesTo.getRelationshipType());
    }
}

