/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxfbc.interceptors;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.security.auth.Subject;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.UsernameTokenInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.servicemix.common.security.AuthenticationService;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.apache.ws.security.handler.WSHandlerResult;

public class JbiJAASInterceptor
extends AbstractWSS4JInterceptor {
    private String domain;
    private AuthenticationService authenticationService;
    private ThreadLocal<Subject> currentSubject = new ThreadLocal();
    private boolean x509;
    private boolean delegateToJaas;

    public JbiJAASInterceptor(AuthenticationService authenticationService, boolean x509, boolean delegateToJaas, String jaasDomain) {
        this.setPhase("pre-protocol");
        this.getAfter().add(WSS4JInInterceptor.class.getName());
        this.getAfter().add(PolicyBasedWSS4JInInterceptor.class.getName());
        this.getAfter().add(UsernameTokenInterceptor.class.getName());
        this.authenticationService = authenticationService;
        this.x509 = x509;
        this.delegateToJaas = delegateToJaas;
        this.domain = jaasDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(SoapMessage message) throws Fault {
        try {
            List results;
            if (!this.delegateToJaas) {
                return;
            }
            Subject subject = this.currentSubject.get();
            if (subject == null) {
                subject = new Subject();
                this.currentSubject.set(subject);
            }
            if ((results = (List)message.get((Object)"RECV_RESULTS")) == null) {
                return;
            }
            for (WSHandlerResult hr : results) {
                if (hr == null || hr.getResults() == null) {
                    return;
                }
                boolean authenticated = false;
                for (WSSecurityEngineResult er : hr.getResults()) {
                    if (er == null || !(er.get((Object)"principal") instanceof WSUsernameTokenPrincipal)) continue;
                    WSUsernameTokenPrincipal p = (WSUsernameTokenPrincipal)er.get((Object)"principal");
                    subject.getPrincipals().add((Principal)p);
                    this.authenticationService.authenticate(subject, this.domain, p.getName(), (Object)p.getPassword());
                    authenticated = true;
                }
                if (authenticated || !this.x509) continue;
                for (WSSecurityEngineResult er : hr.getResults()) {
                    if (er == null || !(er.get((Object)"x509-certificates") instanceof X509Certificate)) continue;
                    X509Certificate cert = (X509Certificate)er.get((Object)"x509-certificates");
                    this.authenticationService.authenticate(subject, this.domain, cert.getIssuerX500Principal().getName(), (Object)cert);
                }
            }
            message.put(Subject.class, (Object)subject);
        }
        catch (GeneralSecurityException e) {
            throw new Fault((Throwable)e);
        }
        catch (UndeclaredThrowableException e) {
            Throwable undeclared = e.getUndeclaredThrowable();
            if (undeclared != null && undeclared instanceof InvocationTargetException) {
                throw new Fault(((InvocationTargetException)undeclared).getTargetException());
            }
        }
        finally {
            this.currentSubject.set(null);
        }
    }
}

