/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.util.storage;

import java.util.Iterator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.opensaml.util.storage.ExpiringObject;
import org.opensaml.util.storage.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpiringObjectStorageServiceSweeper
extends TimerTask {
    private final Logger log = LoggerFactory.getLogger(ExpiringObjectStorageServiceSweeper.class);
    private long sweepInterval;
    private StorageService store;
    private Set<String> partitions;

    public ExpiringObjectStorageServiceSweeper(Timer taskTimer, long interval, StorageService sweptStore) {
        this.store = sweptStore;
        this.sweepInterval = interval;
        taskTimer.schedule((TimerTask)this, interval, interval);
        this.partitions = null;
    }

    public ExpiringObjectStorageServiceSweeper(Timer taskTimer, long interval, StorageService sweptStore, Set<String> sweptPartitions) {
        this.store = sweptStore;
        this.partitions = sweptPartitions != null || sweptPartitions.isEmpty() ? sweptPartitions : null;
        this.sweepInterval = interval;
        taskTimer.schedule((TimerTask)this, interval, interval);
    }

    @Override
    public void run() {
        try {
            Iterator<String> sweepPartitions = this.partitions != null && !this.partitions.isEmpty() ? this.partitions.iterator() : this.store.getPartitions();
            while (sweepPartitions.hasNext()) {
                String currentParition = sweepPartitions.next();
                this.log.trace("Sweeping storage service partition {}", (Object)currentParition);
                Iterator partitionKeys = this.store.getKeys(currentParition);
                if (partitionKeys == null) continue;
                while (partitionKeys.hasNext()) {
                    Object partitionKey = partitionKeys.next();
                    Object partitionValue = this.store.get(currentParition, partitionKey);
                    if (!(partitionValue instanceof ExpiringObject) || !((ExpiringObject)partitionValue).isExpired()) continue;
                    this.log.trace("Removing expired object from storage service partition {}", (Object)currentParition);
                    partitionKeys.remove();
                }
            }
        }
        catch (Throwable t) {
            this.log.error("Caught unexpected error, sweeper will execute again in " + this.sweepInterval + "ms", t);
        }
    }
}

