/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import javax.xml.namespace.QName;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.Header;
import org.apache.cxf.ws.security.policy.model.SignedEncryptedParts;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.builders.AssertionBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SignedPartsBuilder
implements AssertionBuilder<Element> {
    public QName[] getKnownElements() {
        return new QName[]{SP11Constants.SIGNED_PARTS, SP12Constants.SIGNED_PARTS};
    }

    public Assertion build(Element element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        SPConstants consts = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        SignedEncryptedParts signedEncryptedParts = new SignedEncryptedParts(true, consts);
        for (Node nd = element.getFirstChild(); nd != null; nd = nd.getNextSibling()) {
            if (!(nd instanceof Element)) continue;
            this.processElement((Element)nd, signedEncryptedParts);
        }
        if (!signedEncryptedParts.isBody() && !signedEncryptedParts.isAttachments() && signedEncryptedParts.getHeaders().isEmpty()) {
            signedEncryptedParts.setBody(true);
        }
        return signedEncryptedParts;
    }

    private void processElement(Element element, SignedEncryptedParts parent) {
        if ("Header".equals(element.getLocalName())) {
            String namespaceAttribute;
            String nameAttribute = element.getAttributeNS(null, "Name");
            if (nameAttribute == null) {
                nameAttribute = "";
            }
            if ("".equals(namespaceAttribute = element.getAttributeNS(null, "Namespace"))) {
                throw new IllegalArgumentException("sp:SignedParts/sp:Header@Namespace must have a value");
            }
            parent.addHeader(new Header(nameAttribute, namespaceAttribute));
        } else if ("Body".equals(element.getLocalName())) {
            parent.setBody(true);
        }
    }
}

