/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.builders.AlgorithmSuiteBuilder;
import org.apache.cxf.ws.security.policy.builders.LayoutBuilder;
import org.apache.cxf.ws.security.policy.builders.SupportingTokens12Builder;
import org.apache.cxf.ws.security.policy.builders.SupportingTokensBuilder;
import org.apache.cxf.ws.security.policy.builders.TransportTokenBuilder;
import org.apache.cxf.ws.security.policy.model.AlgorithmSuite;
import org.apache.cxf.ws.security.policy.model.Layout;
import org.apache.cxf.ws.security.policy.model.SupportingToken;
import org.apache.cxf.ws.security.policy.model.TransportBinding;
import org.apache.cxf.ws.security.policy.model.TransportToken;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.Constants;
import org.apache.neethi.builders.AssertionBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TransportBindingBuilder
implements AssertionBuilder<Element> {
    PolicyBuilder builder;
    Bus bus;

    public TransportBindingBuilder(PolicyBuilder b, Bus bus) {
        this.builder = b;
        this.bus = bus;
    }

    public Assertion build(Element element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        SPConstants consts = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        TransportBinding transportBinding = new TransportBinding(consts, this.builder);
        this.processAlternative(element, transportBinding, consts, factory);
        return transportBinding;
    }

    public QName[] getKnownElements() {
        return new QName[]{SP11Constants.TRANSPORT_BINDING, SP12Constants.TRANSPORT_BINDING};
    }

    private void processAlternative(Element element, TransportBinding parent, SPConstants consts, AssertionBuilderFactory factory) {
        Element polEl = DOMUtils.getFirstElement((Node)element);
        boolean foundTransportToken = false;
        boolean foundAlgorithmSuite = false;
        while (polEl != null) {
            if (Constants.isPolicyElement((QName)new QName(polEl.getNamespaceURI(), polEl.getLocalName()))) {
                Element child = DOMUtils.getFirstElement((Node)polEl);
                while (child != null) {
                    String name = child.getLocalName();
                    if (name.equals("AlgorithmSuite")) {
                        foundAlgorithmSuite = true;
                        parent.setAlgorithmSuite((AlgorithmSuite)new AlgorithmSuiteBuilder(this.bus).build(child, factory));
                    } else if (name.equals("TransportToken")) {
                        foundTransportToken = true;
                        parent.setTransportToken((TransportToken)new TransportTokenBuilder(this.builder).build(child, factory));
                    } else if (name.equals("IncludeTimestamp")) {
                        parent.setIncludeTimestamp(true);
                    } else if (name.equals("Layout")) {
                        parent.setLayout((Layout)new LayoutBuilder().build(child, factory));
                    } else if (name.equals("SignedSupportingTokens") || name.equals("SignedEndorsingSupportingTokens")) {
                        if (consts.getVersion() == SPConstants.Version.SP_V11) {
                            parent.setSignedSupportingToken((SupportingToken)new SupportingTokensBuilder(this.builder).build(child, factory));
                        } else {
                            parent.setSignedSupportingToken((SupportingToken)new SupportingTokens12Builder(this.builder).build(child, factory));
                        }
                    }
                    child = DOMUtils.getNextElement((Element)child);
                }
            }
            polEl = DOMUtils.getNextElement((Element)polEl);
        }
        if (!foundTransportToken && consts != SP11Constants.INSTANCE) {
            throw new IllegalArgumentException("sp:TransportBinding/wsp:Policy/sp:TransportToken must have a value");
        }
        if (!foundAlgorithmSuite && consts != SP11Constants.INSTANCE) {
            throw new IllegalArgumentException("sp:TransportBinding/wsp:Policy/sp:AlgorithmSuite must have a value");
        }
    }
}

