/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.util.Collection;
import java.util.List;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.SymmetricBinding;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AbstractBindingPolicyValidator;
import org.apache.ws.security.WSSecurityEngineResult;
import org.w3c.dom.Element;

public class SymmetricBindingPolicyValidator
extends AbstractBindingPolicyValidator {
    @Override
    public boolean validatePolicy(AssertionInfoMap aim, Message message, Element soapBody, List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults, List<WSSecurityEngineResult> encryptedResults) {
        Collection ais = (Collection)aim.get((Object)SP12Constants.SYMMETRIC_BINDING);
        if (ais == null || ais.isEmpty()) {
            return true;
        }
        boolean hasDerivedKeys = false;
        for (WSSecurityEngineResult result : results) {
            Integer actInt = (Integer)result.get((Object)"action");
            if (actInt != 2048) continue;
            hasDerivedKeys = true;
            break;
        }
        for (AssertionInfo ai : ais) {
            SymmetricBinding binding = (SymmetricBinding)ai.getAssertion();
            ai.setAsserted(true);
            if (this.checkProtectionOrder(binding, ai, results) && this.checkProperties(binding, ai, aim, results, signedResults, message) && this.checkTokens(binding, ai, aim, hasDerivedKeys, signedResults, encryptedResults)) continue;
        }
        return true;
    }

    private boolean checkTokens(SymmetricBinding binding, AssertionInfo ai, AssertionInfoMap aim, boolean hasDerivedKeys, List<WSSecurityEngineResult> signedResults, List<WSSecurityEngineResult> encryptedResults) {
        if (binding.getEncryptionToken() != null) {
            this.assertPolicy(aim, binding.getEncryptionToken());
            if (!this.checkDerivedKeys(binding.getEncryptionToken(), hasDerivedKeys, signedResults, encryptedResults)) {
                ai.setNotAsserted("Message fails the DerivedKeys requirement");
                return false;
            }
        }
        if (binding.getSignatureToken() != null) {
            this.assertPolicy(aim, binding.getSignatureToken());
            if (!this.checkDerivedKeys(binding.getSignatureToken(), hasDerivedKeys, signedResults, encryptedResults)) {
                ai.setNotAsserted("Message fails the DerivedKeys requirement");
                return false;
            }
        }
        if (binding.getProtectionToken() != null) {
            this.assertPolicy(aim, binding.getProtectionToken());
            if (!this.checkDerivedKeys(binding.getProtectionToken(), hasDerivedKeys, signedResults, encryptedResults)) {
                ai.setNotAsserted("Message fails the DerivedKeys requirement");
                return false;
            }
        }
        return true;
    }
}

