/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxfbc.interceptors;

import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.model.SoapBindingInfo;
import org.apache.cxf.binding.soap.model.SoapHeaderInfo;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.headers.Header;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.soap.util.DomUtil;
import org.apache.servicemix.soap.util.QNameUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractHeaderPartIntercepor
extends AbstractPhaseInterceptor<Message> {
    public ExtractHeaderPartIntercepor() {
        super("pre-stream");
    }

    public void handleMessage(Message message) {
        this.extractHeaderFromMessagePart(message);
    }

    private void extractHeaderFromMessagePart(Message message) {
        Element element;
        Source source = (Source)message.getContent(Source.class);
        if (source == null) {
            return;
        }
        try {
            element = new SourceTransformer().toDOMElement(source);
        }
        catch (Exception e) {
            throw new Fault((Throwable)e);
        }
        if (!"http://java.sun.com/xml/ns/jbi/wsdl-11-wrapper".equals(element.getNamespaceURI()) || !"message".equals(element.getLocalName())) {
            message.setContent(Source.class, (Object)new DOMSource(element));
            return;
        }
        BindingOperationInfo bop = (BindingOperationInfo)message.getExchange().get(BindingOperationInfo.class);
        if (bop == null) {
            throw new Fault((Throwable)new Exception("Operation not bound on this message"));
        }
        BindingMessageInfo msg = this.isRequestor(message) ? bop.getInput() : bop.getOutput();
        SoapBindingInfo binding = (SoapBindingInfo)((Endpoint)message.getExchange().get(Endpoint.class)).getEndpointInfo().getBinding();
        String style = binding.getStyle(bop.getOperationInfo());
        if (style == null) {
            style = binding.getStyle();
        }
        Element partWrapper = DomUtil.getFirstChildElement((Node)element);
        while (partWrapper != null) {
            this.extractHeaderParts((SoapMessage)message, element, partWrapper, msg);
            partWrapper = DomUtil.getNextSiblingElement((Element)partWrapper);
        }
        message.setContent(Source.class, (Object)new DOMSource(element));
    }

    private void extractHeaderParts(SoapMessage message, Element element, Element partWrapper, BindingMessageInfo msg) {
        ArrayList<NodeList> partsContent = new ArrayList<NodeList>();
        if (partWrapper != null) {
            if (!"http://java.sun.com/xml/ns/jbi/wsdl-11-wrapper".equals(element.getNamespaceURI()) || !"part".equals(partWrapper.getLocalName())) {
                throw new Fault((Throwable)new Exception("Unexpected part wrapper element '" + QNameUtil.toString((Element)element) + "' expected '{" + "http://java.sun.com/xml/ns/jbi/wsdl-11-wrapper" + "}part'"));
            }
            NodeList nodes = partWrapper.getChildNodes();
            partsContent.add(nodes);
        }
        List headerList = message.getHeaders();
        List headers = msg.getExtensors(SoapHeaderInfo.class);
        for (SoapHeaderInfo header : headers) {
            if (partsContent.size() == 0) break;
            NodeList nl = (NodeList)partsContent.get(0);
            if (!header.getPart().getConcreteName().getNamespaceURI().equals(nl.item(0).getNamespaceURI()) || !header.getPart().getConcreteName().getLocalPart().equals(nl.item(0).getLocalName())) continue;
            headerList.add(new Header(header.getPart().getConcreteName(), (Object)nl.item(0)));
            partsContent.remove(0);
        }
    }
}

