/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.service.invoker;

import org.apache.cxf.common.util.factory.AbstractPool;
import org.apache.cxf.common.util.factory.Factory;
import org.apache.cxf.common.util.factory.Pool;
import org.apache.cxf.common.util.factory.PooledFactory;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.invoker.ScopePolicy;
import org.apache.cxf.transport.Session;

public class SessionScopePolicy
implements ScopePolicy {
    private static SessionScopePolicy singleton = new SessionScopePolicy();

    protected Object getServiceKey(Service service) {
        return service.getName();
    }

    public Factory applyScope(Factory f, Exchange ex) {
        Service s = (Service)ex.get(Service.class);
        return new PooledFactory(f, SessionScopePolicy.getSessionScope(this.getServiceKey(s), ex.getSession()));
    }

    public String toString() {
        return "session scope";
    }

    private static Pool getSessionScope(final Object key, final Session session) {
        return new AbstractPool(){

            public Object get() {
                return session.get(key);
            }

            public void set(Object val) {
                session.put(key, val);
            }

            public String toString() {
                return "session scope";
            }

            protected Object getMutex() {
                return Service.class;
            }
        };
    }

    public static ScopePolicy instance() {
        return singleton;
    }
}

