/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.wsdl11;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.extensions.AttributeExtensible;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.binding.BindingFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.service.model.AbstractMessageContainer;
import org.apache.cxf.service.model.AbstractPropertiesHolder;
import org.apache.cxf.service.model.BindingFaultInfo;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.DescriptionInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.service.model.ServiceSchemaInfo;
import org.apache.cxf.service.model.UnwrappedOperationInfo;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.cxf.wsdl11.SchemaUtil;
import org.apache.cxf.wsdl11.WSDLBindingFactory;
import org.apache.cxf.wsdl11.WSDLEndpointFactory;
import org.apache.cxf.wsdl11.WSDLServiceUtils;
import org.apache.ws.commons.schema.XmlSchemaAnnotated;
import org.apache.ws.commons.schema.XmlSchemaComplexContentExtension;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLServiceBuilder {
    public static final String WSDL_SCHEMA_LIST = WSDLServiceBuilder.class.getName() + ".SCHEMA";
    public static final String WSDL_DEFINITION = WSDLServiceBuilder.class.getName() + ".DEFINITION";
    public static final String WSDL_SERVICE = WSDLServiceBuilder.class.getName() + ".SERVICE";
    public static final String WSDL_PORTTYPE = WSDLServiceBuilder.class.getName() + ".WSDL_PORTTYPE";
    public static final String WSDL_PORT = WSDLServiceBuilder.class.getName() + ".PORT";
    public static final String WSDL_BINDING = WSDLServiceBuilder.class.getName() + ".BINDING";
    public static final String WSDL_SCHEMA_ELEMENT_LIST = WSDLServiceBuilder.class.getName() + ".SCHEMA_ELEMENTS";
    public static final String WSDL_OPERATION = WSDLServiceBuilder.class.getName() + ".OPERATION";
    public static final String WSDL_BINDING_OPERATION = WSDLServiceBuilder.class.getName() + ".BINDING_OPERATION";
    private static final Logger LOG = LogUtils.getL7dLogger(WSDLServiceBuilder.class);
    private Bus bus;
    private Map<String, Element> schemaList = new HashMap<String, Element>();
    private boolean recordOriginal = true;

    public WSDLServiceBuilder(Bus bus) {
        this.bus = bus;
    }

    public WSDLServiceBuilder(Bus bus, boolean record) {
        this.bus = bus;
        this.recordOriginal = record;
    }

    private void copyExtensors(AbstractPropertiesHolder info, List<?> extList) {
        if (info != null) {
            for (ExtensibilityElement ext : CastUtils.cast(extList, ExtensibilityElement.class)) {
                info.addExtensor((Object)ext);
            }
        }
    }

    private void copyExtensionAttributes(AbstractPropertiesHolder info, AttributeExtensible ae) {
        Map attrs = CastUtils.cast((Map)ae.getExtensionAttributes());
        if (!attrs.isEmpty()) {
            info.setExtensionAttributes(attrs);
        }
    }

    public List<ServiceInfo> buildServices(Definition d) {
        DescriptionInfo description = new DescriptionInfo();
        if (this.recordOriginal) {
            description.setProperty(WSDL_DEFINITION, (Object)d);
        }
        description.setName(d.getQName());
        description.setBaseURI(d.getDocumentBaseURI());
        this.copyExtensors((AbstractPropertiesHolder)description, d.getExtensibilityElements());
        this.copyExtensionAttributes((AbstractPropertiesHolder)description, (AttributeExtensible)d);
        ArrayList<ServiceInfo> serviceList = new ArrayList<ServiceInfo>();
        Iterator ite = CastUtils.cast(d.getServices().keySet().iterator());
        while (ite.hasNext()) {
            QName qn = (QName)ite.next();
            serviceList.addAll(this.buildServices(d, qn, description));
        }
        return serviceList;
    }

    public List<ServiceInfo> buildServices(Definition d, QName name) {
        return this.buildServices(d, name, null);
    }

    private List<ServiceInfo> buildServices(Definition d, QName name, DescriptionInfo description) {
        Service service = d.getService(name);
        return this.buildServices(d, service, description);
    }

    public List<ServiceInfo> buildServices(Definition def, Service serv) {
        return this.buildServices(def, serv, null);
    }

    public List<ServiceInfo> buildMockServices(Definition d) {
        ArrayList<ServiceInfo> serviceList = new ArrayList<ServiceInfo>();
        ArrayList<Definition> defList = new ArrayList<Definition>();
        defList.add(d);
        this.parseImports(d, defList);
        for (Definition def : defList) {
            for (Map.Entry entry : def.getPortTypes().entrySet()) {
                PortType portType = def.getPortType((QName)entry.getKey());
                ServiceInfo serviceInfo = this.buildMockService(def, portType);
                serviceList.add(serviceInfo);
            }
            if (def.getPortTypes().size() != 0) continue;
            DescriptionInfo description = new DescriptionInfo();
            if (this.recordOriginal) {
                description.setProperty(WSDL_DEFINITION, (Object)def);
            }
            description.setName(def.getQName());
            description.setBaseURI(def.getDocumentBaseURI());
            this.copyExtensors((AbstractPropertiesHolder)description, def.getExtensibilityElements());
            this.copyExtensionAttributes((AbstractPropertiesHolder)description, (AttributeExtensible)def);
            ServiceInfo service = new ServiceInfo();
            service.setDescription(description);
            if (this.recordOriginal) {
                service.setProperty(WSDL_DEFINITION, (Object)def);
            }
            this.getSchemas(def, service);
            service.setProperty(WSDL_SCHEMA_ELEMENT_LIST, this.schemaList);
            serviceList.add(service);
        }
        return serviceList;
    }

    public ServiceInfo buildMockService(Definition def, PortType p) {
        DescriptionInfo description = new DescriptionInfo();
        if (this.recordOriginal) {
            description.setProperty(WSDL_DEFINITION, (Object)def);
        }
        description.setName(def.getQName());
        description.setBaseURI(def.getDocumentBaseURI());
        this.copyExtensors((AbstractPropertiesHolder)description, def.getExtensibilityElements());
        this.copyExtensionAttributes((AbstractPropertiesHolder)description, (AttributeExtensible)def);
        ServiceInfo service = new ServiceInfo();
        service.setDescription(description);
        if (this.recordOriginal) {
            service.setProperty(WSDL_DEFINITION, (Object)def);
        }
        this.getSchemas(def, service);
        service.setProperty(WSDL_SCHEMA_ELEMENT_LIST, this.schemaList);
        this.buildInterface(service, p);
        return service;
    }

    private List<ServiceInfo> buildServices(Definition def, Service serv, DescriptionInfo d) {
        LinkedHashMap<QName, ServiceInfo> services = new LinkedHashMap<QName, ServiceInfo>();
        DescriptionInfo description = d;
        if (null == description) {
            description = new DescriptionInfo();
            if (this.recordOriginal) {
                description.setProperty(WSDL_DEFINITION, (Object)def);
            }
            description.setName(def.getQName());
            description.setBaseURI(def.getDocumentBaseURI());
            this.copyExtensors((AbstractPropertiesHolder)description, def.getExtensibilityElements());
            this.copyExtensionAttributes((AbstractPropertiesHolder)description, (AttributeExtensible)def);
        }
        for (Port port : CastUtils.cast(serv.getPorts().values(), Port.class)) {
            BindingInfo bi;
            ServiceInfo service;
            Binding binding = port.getBinding();
            PortType bindingPt = binding.getPortType();
            PortType pt = def.getPortType(bindingPt.getQName());
            if (pt == null) {
                pt = bindingPt;
            }
            if ((service = (ServiceInfo)services.get(pt.getQName())) == null) {
                service = new ServiceInfo();
                service.setDescription(description);
                description.getDescribed().add(service);
                if (this.recordOriginal) {
                    service.setProperty(WSDL_DEFINITION, (Object)def);
                    service.setProperty(WSDL_SERVICE, (Object)serv);
                }
                this.getSchemas(def, service);
                service.setProperty(WSDL_SCHEMA_ELEMENT_LIST, this.schemaList);
                service.setTargetNamespace(def.getTargetNamespace());
                service.setName(serv.getQName());
                this.copyExtensors((AbstractPropertiesHolder)service, serv.getExtensibilityElements());
                this.copyExtensionAttributes((AbstractPropertiesHolder)service, (AttributeExtensible)serv);
                this.buildInterface(service, pt);
                services.put(pt.getQName(), service);
            }
            if ((bi = service.getBinding(binding.getQName())) == null) {
                bi = this.buildBinding(service, binding);
            }
            this.buildEndpoint(service, bi, port);
        }
        return new ArrayList<ServiceInfo>(services.values());
    }

    private void getSchemas(Definition def, ServiceInfo serviceInfo) {
        ServiceSchemaInfo serviceSchemaInfo = null;
        WSDLManager wsdlManager = (WSDLManager)this.bus.getExtension(WSDLManager.class);
        if (wsdlManager != null) {
            serviceSchemaInfo = wsdlManager.getSchemasForDefinition(def);
        }
        if (serviceSchemaInfo == null) {
            SchemaUtil schemaUtil = new SchemaUtil(this.bus, this.schemaList);
            schemaUtil.getSchemas(def, serviceInfo);
            serviceSchemaInfo = new ServiceSchemaInfo();
            serviceSchemaInfo.setSchemaElementList(this.schemaList);
            serviceSchemaInfo.setSchemaCollection(serviceInfo.getXmlSchemaCollection());
            serviceSchemaInfo.setSchemaInfoList(serviceInfo.getSchemas());
            if (wsdlManager != null) {
                wsdlManager.putSchemasForDefinition(def, serviceSchemaInfo);
            }
        } else {
            serviceInfo.setServiceSchemaInfo(serviceSchemaInfo);
            this.schemaList.putAll(serviceSchemaInfo.getSchemaElementList());
        }
    }

    private void parseImports(Definition def, List<Definition> defList) {
        ArrayList importList = new ArrayList();
        Collection ilist = CastUtils.cast(def.getImports().values());
        for (List list : ilist) {
            importList.addAll(list);
        }
        for (Import impt : importList) {
            if (defList.contains(impt.getDefinition())) continue;
            defList.add(impt.getDefinition());
            this.parseImports(impt.getDefinition(), defList);
        }
    }

    public EndpointInfo buildEndpoint(ServiceInfo service, BindingInfo bi, Port port) {
        List elements = port.getExtensibilityElements();
        String ns = null;
        DestinationFactory factory = null;
        EndpointInfo ei = null;
        if (null != elements && elements.size() > 0) {
            for (ExtensibilityElement el : CastUtils.cast((List)elements, ExtensibilityElement.class)) {
                ns = el.getElementType().getNamespaceURI();
                try {
                    factory = ((DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class)).getDestinationFactory(ns);
                }
                catch (BusException e) {
                    // empty catch block
                }
                if (factory == null) continue;
                break;
            }
            if (factory == null) {
                ns = ((ExtensibilityElement)elements.get(0)).getElementType().getNamespaceURI();
            }
        }
        if (factory == null) {
            elements = port.getBinding().getExtensibilityElements();
            if (null != elements && elements.size() > 0) {
                for (ExtensibilityElement el : CastUtils.cast((List)elements, ExtensibilityElement.class)) {
                    if (el instanceof SOAPBinding) {
                        ns = ((SOAPBinding)el).getTransportURI();
                        break;
                    }
                    if (el instanceof SOAP12Binding) {
                        ns = ((SOAP12Binding)el).getTransportURI();
                        break;
                    }
                    if (!"http://cxf.apache.org/bindings/jbi".equals(el.getElementType().getNamespaceURI())) continue;
                    ns = "http://cxf.apache.org/transports/jbi";
                    break;
                }
            }
            if (ns == null) {
                throw new RuntimeException("Can non find the destination factory, check the port  //wsdl:port[@name='" + port.getName() + "']");
            }
            try {
                factory = ((DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class)).getDestinationFactory(ns);
            }
            catch (BusException e) {
                // empty catch block
            }
        }
        if (factory instanceof WSDLEndpointFactory) {
            WSDLEndpointFactory wFactory = (WSDLEndpointFactory)factory;
            ei = wFactory.createEndpointInfo(service, bi, port);
        }
        if (ei == null) {
            ei = new EndpointInfo(service, ns);
        }
        ei.setName(new QName(service.getName().getNamespaceURI(), port.getName()));
        ei.setBinding(bi);
        this.copyExtensors((AbstractPropertiesHolder)ei, port.getExtensibilityElements());
        this.copyExtensionAttributes((AbstractPropertiesHolder)ei, (AttributeExtensible)port);
        service.addEndpoint(ei);
        DescriptionInfo d = service.getDescription();
        if (null != d) {
            ei.setDescription(d);
            d.getDescribed().add(ei);
        }
        return ei;
    }

    public BindingInfo buildBinding(ServiceInfo service, Binding binding) {
        BindingInfo bi = null;
        StringBuffer ns = new StringBuffer(100);
        BindingFactory factory = WSDLServiceUtils.getBindingFactory(binding, this.bus, ns);
        if (factory instanceof WSDLBindingFactory) {
            WSDLBindingFactory wFactory = (WSDLBindingFactory)factory;
            bi = wFactory.createBindingInfo(service, binding, ns.toString());
            this.copyExtensors((AbstractPropertiesHolder)bi, binding.getExtensibilityElements());
            this.copyExtensionAttributes((AbstractPropertiesHolder)bi, (AttributeExtensible)binding);
        }
        if (bi == null) {
            bi = new BindingInfo(service, ns.toString());
            bi.setName(binding.getQName());
            this.copyExtensors((AbstractPropertiesHolder)bi, binding.getExtensibilityElements());
            this.copyExtensionAttributes((AbstractPropertiesHolder)bi, (AttributeExtensible)binding);
            for (BindingOperation bop : CastUtils.cast((List)binding.getBindingOperations(), BindingOperation.class)) {
                BindingOperationInfo bop2;
                LOG.fine("binding operation name is " + bop.getName());
                String inName = null;
                String outName = null;
                if (bop.getBindingInput() != null) {
                    inName = bop.getBindingInput().getName();
                }
                if (bop.getBindingOutput() != null) {
                    outName = bop.getBindingOutput().getName();
                }
                if ((bop2 = bi.buildOperation(new QName(service.getName().getNamespaceURI(), bop.getName()), inName, outName)) == null) continue;
                this.copyExtensors((AbstractPropertiesHolder)bop2, bop.getExtensibilityElements());
                this.copyExtensionAttributes((AbstractPropertiesHolder)bop2, (AttributeExtensible)bop);
                bi.addOperation(bop2);
                if (bop.getBindingInput() != null) {
                    this.copyExtensors((AbstractPropertiesHolder)bop2.getInput(), bop.getBindingInput().getExtensibilityElements());
                    this.copyExtensionAttributes((AbstractPropertiesHolder)bop2.getInput(), (AttributeExtensible)bop.getBindingInput());
                    this.handleHeader(bop2.getInput());
                }
                if (bop.getBindingOutput() != null) {
                    this.copyExtensors((AbstractPropertiesHolder)bop2.getOutput(), bop.getBindingOutput().getExtensibilityElements());
                    this.copyExtensionAttributes((AbstractPropertiesHolder)bop2.getOutput(), (AttributeExtensible)bop.getBindingOutput());
                    this.handleHeader(bop2.getOutput());
                }
                for (BindingFault f : CastUtils.cast(bop.getBindingFaults().values(), BindingFault.class)) {
                    BindingFaultInfo bif = bop2.getFault(new QName(service.getTargetNamespace(), f.getName()));
                    this.copyExtensors((AbstractPropertiesHolder)bif, bop.getBindingFault(f.getName()).getExtensibilityElements());
                    this.copyExtensionAttributes((AbstractPropertiesHolder)bif, (AttributeExtensible)bop.getBindingFault(f.getName()));
                }
            }
        }
        service.addBinding(bi);
        DescriptionInfo d = service.getDescription();
        if (null != d) {
            bi.setDescription(d);
            d.getDescribed().add(bi);
        }
        return bi;
    }

    private void handleHeader(BindingMessageInfo bindingMessageInfo) {
        List extensiblilityElement = bindingMessageInfo.getExtensors(ExtensibilityElement.class);
        if (extensiblilityElement == null) {
            return;
        }
    }

    public void buildInterface(ServiceInfo si, PortType p) {
        InterfaceInfo inf = si.createInterface(p.getQName());
        DescriptionInfo d = si.getDescription();
        if (null != d) {
            inf.setDescription(si.getDescription());
            d.getDescribed().add(inf);
        }
        this.copyExtensors((AbstractPropertiesHolder)inf, p.getExtensibilityElements());
        this.copyExtensionAttributes((AbstractPropertiesHolder)inf, (AttributeExtensible)p);
        if (this.recordOriginal) {
            inf.setProperty(WSDL_PORTTYPE, (Object)p);
        }
        for (Operation op : CastUtils.cast((List)p.getOperations(), Operation.class)) {
            this.buildInterfaceOperation(inf, op);
        }
    }

    private void buildInterfaceOperation(InterfaceInfo inf, Operation op) {
        Output output;
        OperationInfo opInfo = inf.addOperation(new QName(inf.getName().getNamespaceURI(), op.getName()));
        if (this.recordOriginal) {
            opInfo.setProperty(WSDL_OPERATION, (Object)op);
        }
        List porderList = CastUtils.cast((List)op.getParameterOrdering());
        opInfo.setParameterOrdering(porderList);
        this.copyExtensors((AbstractPropertiesHolder)opInfo, op.getExtensibilityElements());
        this.copyExtensionAttributes((AbstractPropertiesHolder)opInfo, (AttributeExtensible)op);
        Input input = op.getInput();
        if (input != null) {
            MessageInfo minfo = opInfo.createMessage(input.getMessage().getQName());
            opInfo.setInput(input.getName(), minfo);
            this.buildMessage((AbstractMessageContainer)minfo, input.getMessage());
            this.copyExtensors((AbstractPropertiesHolder)minfo, input.getExtensibilityElements());
            this.copyExtensionAttributes((AbstractPropertiesHolder)minfo, (AttributeExtensible)input);
        }
        if ((output = op.getOutput()) != null) {
            MessageInfo minfo = opInfo.createMessage(output.getMessage().getQName());
            opInfo.setOutput(output.getName(), minfo);
            this.buildMessage((AbstractMessageContainer)minfo, output.getMessage());
            this.copyExtensors((AbstractPropertiesHolder)minfo, output.getExtensibilityElements());
            this.copyExtensionAttributes((AbstractPropertiesHolder)minfo, (AttributeExtensible)output);
        }
        Map m = op.getFaults();
        for (Map.Entry rawentry : m.entrySet()) {
            Map.Entry entry = CastUtils.cast(rawentry, String.class, Fault.class);
            FaultInfo finfo = opInfo.addFault(new QName(inf.getName().getNamespaceURI(), (String)entry.getKey()), ((Fault)entry.getValue()).getMessage().getQName());
            this.buildMessage((AbstractMessageContainer)finfo, ((Fault)entry.getValue()).getMessage());
            this.copyExtensors((AbstractPropertiesHolder)finfo, ((Fault)entry.getValue()).getExtensibilityElements());
            this.copyExtensionAttributes((AbstractPropertiesHolder)finfo, (AttributeExtensible)entry.getValue());
        }
        WSDLServiceBuilder.checkForWrapped(opInfo, false);
    }

    public static void checkForWrapped(OperationInfo opInfo, boolean relaxed) {
        MessageInfo inputMessage = opInfo.getInput();
        MessageInfo outputMessage = opInfo.getOutput();
        boolean passedRule = true;
        if (inputMessage == null || inputMessage.size() != 1 || outputMessage != null && outputMessage.size() > 1) {
            passedRule = false;
        }
        if (!passedRule) {
            return;
        }
        SchemaCollection schemas = opInfo.getInterface().getService().getXmlSchemaCollection();
        XmlSchemaElement inputEl = null;
        XmlSchemaElement outputEl = null;
        MessagePartInfo inputPart = inputMessage.getMessagePartByIndex(0);
        if (!inputPart.isElement()) {
            passedRule = false;
        } else {
            QName inputElementName = inputPart.getElementQName();
            inputEl = schemas.getElementByQName(inputElementName);
            if (inputEl == null) {
                passedRule = false;
            } else if (!opInfo.getName().getLocalPart().equals(inputElementName.getLocalPart())) {
                passedRule = relaxed;
            }
        }
        if (!passedRule) {
            return;
        }
        MessagePartInfo outputPart = null;
        if (outputMessage != null && outputMessage.size() == 1 && (outputPart = outputMessage.getMessagePartByIndex(0)) != null) {
            if (!outputPart.isElement() || schemas.getElementByQName(outputPart.getElementQName()) == null) {
                passedRule = false;
            } else {
                outputEl = schemas.getElementByQName(outputPart.getElementQName());
            }
        }
        if (!passedRule) {
            return;
        }
        UnwrappedOperationInfo unwrapped = new UnwrappedOperationInfo(opInfo);
        MessageInfo unwrappedInput = new MessageInfo((OperationInfo)unwrapped, inputMessage.getName());
        MessageInfo unwrappedOutput = null;
        XmlSchemaComplexType xsct = null;
        if (inputEl.getSchemaType() instanceof XmlSchemaComplexType) {
            xsct = (XmlSchemaComplexType)inputEl.getSchemaType();
            if (WSDLServiceBuilder.hasAttributes(xsct) || inputEl.isNillable() && !relaxed || !WSDLServiceBuilder.isWrappableSequence(xsct, inputEl.getQName().getNamespaceURI(), unwrappedInput, relaxed)) {
                passedRule = false;
            }
        } else {
            passedRule = false;
        }
        if (!passedRule) {
            return;
        }
        if (outputMessage != null) {
            unwrappedOutput = new MessageInfo((OperationInfo)unwrapped, outputMessage.getName());
            if (outputEl != null && outputEl.getSchemaType() instanceof XmlSchemaComplexType) {
                xsct = (XmlSchemaComplexType)outputEl.getSchemaType();
                if (WSDLServiceBuilder.hasAttributes(xsct) || outputEl.isNillable() && !relaxed || !WSDLServiceBuilder.isWrappableSequence(xsct, outputEl.getQName().getNamespaceURI(), unwrappedOutput, relaxed)) {
                    passedRule = false;
                }
            } else {
                passedRule = false;
            }
        }
        if (!passedRule) {
            return;
        }
        opInfo.setUnwrappedOperation((OperationInfo)unwrapped);
        unwrapped.setInput(opInfo.getInputName(), unwrappedInput);
        if (outputMessage != null) {
            unwrapped.setOutput(opInfo.getOutputName(), unwrappedOutput);
        }
    }

    private static boolean hasAttributes(XmlSchemaComplexType complexType) {
        return complexType.getAnyAttribute() != null || complexType.getAttributes().getCount() > 0;
    }

    private static boolean isWrappableSequence(XmlSchemaComplexType type, String namespaceURI, MessageInfo wrapper, boolean allowRefs) {
        if (type.getParticle() instanceof XmlSchemaSequence) {
            XmlSchemaSequence seq = (XmlSchemaSequence)type.getParticle();
            XmlSchemaObjectCollection items = seq.getItems();
            boolean ret = true;
            for (int x = 0; x < items.getCount(); ++x) {
                MessagePartInfo mpi;
                XmlSchemaObject o = items.getItem(x);
                if (!(o instanceof XmlSchemaElement)) {
                    return false;
                }
                XmlSchemaElement el = (XmlSchemaElement)o;
                if (el.getSchemaTypeName() != null) {
                    mpi = wrapper.addMessagePart(new QName(namespaceURI, el.getName()));
                    mpi.setTypeQName(el.getSchemaTypeName());
                    mpi.setConcreteName(el.getQName());
                    mpi.setElement(true);
                    mpi.setElementQName(el.getQName());
                    mpi.setXmlSchema((XmlSchemaAnnotated)el);
                    continue;
                }
                if (el.getRefName() != null) {
                    mpi = wrapper.addMessagePart(el.getRefName());
                    mpi.setTypeQName(el.getRefName());
                    mpi.setElementQName(el.getRefName());
                    mpi.setElement(true);
                    mpi.setXmlSchema((XmlSchemaAnnotated)el);
                    if (allowRefs) continue;
                    ret = false;
                    continue;
                }
                mpi = wrapper.addMessagePart(new QName(namespaceURI, el.getName()));
                mpi.setConcreteName(el.getQName());
                mpi.setElementQName(mpi.getName());
                mpi.setElement(true);
                mpi.setXmlSchema((XmlSchemaAnnotated)el);
            }
            return ret;
        }
        if (type.getParticle() == null) {
            if (type.getContentModel() == null) {
                return true;
            }
            return !(type.getContentModel().getContent() instanceof XmlSchemaComplexContentExtension);
        }
        return false;
    }

    private void buildMessage(AbstractMessageContainer minfo, Message msg) {
        SchemaCollection schemas = minfo.getOperation().getInterface().getService().getXmlSchemaCollection();
        List orderedParam = msg.getOrderedParts(null);
        for (Part part : CastUtils.cast((List)orderedParam, Part.class)) {
            MessagePartInfo pi = minfo.addMessagePart(new QName(minfo.getName().getNamespaceURI(), part.getName()));
            if (part.getTypeName() != null) {
                pi.setTypeQName(part.getTypeName());
                pi.setElement(false);
                pi.setXmlSchema((XmlSchemaAnnotated)schemas.getTypeByQName(part.getTypeName()));
                continue;
            }
            pi.setElementQName(part.getElementName());
            pi.setElement(true);
            pi.setXmlSchema((XmlSchemaAnnotated)schemas.getElementByQName(part.getElementName()));
        }
    }
}

