/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms.continuations;

import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.continuations.ContinuationWrapper;
import org.apache.cxf.continuations.SuspendedInvocationException;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.MessageObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSContinuationWrapper
implements ContinuationWrapper {
    private Bus bus;
    private Message inMessage;
    private MessageObserver incomingObserver;
    private List<JMSContinuationWrapper> continuations;
    private Object userObject;
    private boolean isNew = true;
    private boolean isPending;
    private boolean isResumed;
    private Timer timer = new Timer();

    public JMSContinuationWrapper(Bus b, Message m, MessageObserver observer, List<JMSContinuationWrapper> cList) {
        this.bus = b;
        this.inMessage = m;
        this.incomingObserver = observer;
        this.continuations = cList;
    }

    public Object getObject() {
        return this.userObject;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public boolean isPending() {
        return this.isPending;
    }

    public boolean isResumed() {
        return this.isResumed;
    }

    public void reset() {
        this.cancelTimerTask();
        this.isNew = true;
        this.isPending = false;
        this.isResumed = false;
    }

    public void resume() {
        this.cancelTimerTask();
        this.doResume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doResume() {
        if (this.isResumed) {
            return;
        }
        List<JMSContinuationWrapper> list = this.continuations;
        synchronized (list) {
            this.continuations.remove(this);
        }
        this.isResumed = true;
        this.isPending = false;
        this.isNew = false;
        BusFactory.setThreadDefaultBus((Bus)this.bus);
        try {
            this.incomingObserver.onMessage(this.inMessage);
        }
        finally {
            BusFactory.setThreadDefaultBus(null);
        }
    }

    public void setObject(Object o) {
        this.userObject = o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean suspend(long timeout) {
        if (this.isPending) {
            return false;
        }
        List<JMSContinuationWrapper> list = this.continuations;
        synchronized (list) {
            this.continuations.add(this);
        }
        this.isNew = false;
        this.isResumed = false;
        this.isPending = true;
        if (timeout > 0L) {
            this.createTimerTask(timeout);
        }
        throw new SuspendedInvocationException();
    }

    protected void createTimerTask(long timeout) {
        this.timer.schedule(new TimerTask(){

            public void run() {
                JMSContinuationWrapper.this.doResume();
            }
        }, timeout);
    }

    protected void cancelTimerTask() {
        this.timer.cancel();
    }
}

