/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.attachment;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Random;
import java.util.UUID;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.message.Attachment;

public final class AttachmentUtil {
    private static volatile int counter;
    private static final String ATT_UUID;
    private static final Random BOUND_RANDOM;

    private AttachmentUtil() {
    }

    public static String createContentID(String ns) throws UnsupportedEncodingException {
        String cid = "http://cxf.apache.org/";
        String name = ATT_UUID + "-" + String.valueOf(++counter);
        if (ns != null && ns.length() > 0) {
            try {
                String host;
                URI uri = new URI(ns);
                cid = host = uri.toURL().getHost();
            }
            catch (URISyntaxException e) {
                cid = ns;
            }
            catch (MalformedURLException e) {
                cid = ns;
            }
        }
        return URLEncoder.encode(name, "UTF-8") + "@" + URLEncoder.encode(cid, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUniqueBoundaryValue() {
        long leastSigBits = 0L;
        long mostSigBits = 0L;
        Random random = BOUND_RANDOM;
        synchronized (random) {
            mostSigBits = BOUND_RANDOM.nextLong();
            leastSigBits = BOUND_RANDOM.nextLong();
        }
        mostSigBits &= 0xFFFFFFFFFFFF0FFFL;
        leastSigBits &= 0x3FFFFFFFFFFFFFFFL;
        UUID result = new UUID(mostSigBits |= 0x4000L, leastSigBits |= Long.MIN_VALUE);
        return "uuid:" + result.toString();
    }

    public static String getAttchmentPartHeader(Attachment att) {
        String id;
        StringBuffer buffer = new StringBuffer(200);
        buffer.append(HttpHeaderHelper.getHeaderKey((String)"Content-Type") + ": " + att.getDataHandler().getContentType() + ";\r\n");
        if (att.isXOP()) {
            buffer.append("Content-Transfer-Encoding: binary\r\n");
        }
        if ((id = att.getId()).charAt(0) == '<') {
            id = id.substring(1, id.length() - 1);
        }
        buffer.append("Content-ID: <" + id + ">\r\n\r\n");
        return buffer.toString();
    }

    static {
        ATT_UUID = UUID.randomUUID().toString();
        BOUND_RANDOM = new Random();
    }
}

