/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.ws.policy.AbstractPolicyInterceptor;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.EndpointPolicy;
import org.apache.cxf.ws.policy.PolicyEngine;

public class ServerPolicyInInterceptor
extends AbstractPolicyInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(ServerPolicyInInterceptor.class);

    public ServerPolicyInInterceptor() {
        super("org.apache.cxf.ws.policy.ServerPolicyInInterceptor", "receive");
    }

    protected void handle(Message msg) {
        if (MessageUtils.isRequestor((Message)msg)) {
            LOG.fine("Is a requestor.");
            return;
        }
        Exchange exchange = msg.getExchange();
        assert (null != exchange);
        Endpoint e = (Endpoint)exchange.get(Endpoint.class);
        if (null == e) {
            LOG.fine("No endpoint.");
            return;
        }
        EndpointInfo ei = e.getEndpointInfo();
        PolicyEngine pe = (PolicyEngine)this.bus.getExtension(PolicyEngine.class);
        if (null == pe) {
            return;
        }
        Destination destination = exchange.getDestination();
        EndpointPolicy ep = pe.getServerEndpointPolicy(ei, destination);
        List interceptors = ep.getInterceptors();
        for (Interceptor i : interceptors) {
            msg.getInterceptorChain().add(i);
            LOG.log(Level.INFO, "Added interceptor of type {0}", i.getClass().getSimpleName());
        }
        Collection assertions = ep.getVocabulary();
        if (null != assertions) {
            msg.put(AssertionInfoMap.class, (Object)new AssertionInfoMap(assertions));
        }
    }
}

