/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy.attachment.external;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.service.model.BindingFaultInfo;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.policy.PolicyException;
import org.apache.cxf.ws.policy.PolicyProvider;
import org.apache.cxf.ws.policy.attachment.AbstractPolicyProvider;
import org.apache.cxf.ws.policy.attachment.external.DomainExpression;
import org.apache.cxf.ws.policy.attachment.external.DomainExpressionBuilderRegistry;
import org.apache.cxf.ws.policy.attachment.external.PolicyAttachment;
import org.apache.cxf.ws.policy.attachment.reference.LocalDocumentReferenceResolver;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyReference;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalAttachmentProvider
extends AbstractPolicyProvider
implements PolicyProvider {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(ExternalAttachmentProvider.class);
    private Resource location;
    private Collection<PolicyAttachment> attachments;

    ExternalAttachmentProvider() {
    }

    ExternalAttachmentProvider(Bus b) {
        super(b);
    }

    public void setLocation(Resource u) {
        this.location = u;
    }

    public Resource getLocation() {
        return this.location;
    }

    public Policy getEffectivePolicy(BindingFaultInfo bfi) {
        this.readDocument();
        Policy p = new Policy();
        for (PolicyAttachment pa : this.attachments) {
            if (!pa.appliesTo(bfi)) continue;
            p = p.merge(pa.getPolicy());
        }
        return p;
    }

    public Policy getEffectivePolicy(BindingMessageInfo bmi) {
        this.readDocument();
        Policy p = new Policy();
        for (PolicyAttachment pa : this.attachments) {
            if (!pa.appliesTo(bmi)) continue;
            p = p.merge(pa.getPolicy());
        }
        return p;
    }

    public Policy getEffectivePolicy(BindingOperationInfo boi) {
        this.readDocument();
        Policy p = new Policy();
        for (PolicyAttachment pa : this.attachments) {
            if (!pa.appliesTo(boi)) continue;
            p = p.merge(pa.getPolicy());
        }
        return p;
    }

    public Policy getEffectivePolicy(EndpointInfo ei) {
        this.readDocument();
        Policy p = new Policy();
        for (PolicyAttachment pa : this.attachments) {
            if (!pa.appliesTo(ei)) continue;
            p = p.merge(pa.getPolicy());
        }
        return p;
    }

    public Policy getEffectivePolicy(ServiceInfo si) {
        this.readDocument();
        Policy p = new Policy();
        for (PolicyAttachment pa : this.attachments) {
            if (!pa.appliesTo(si)) continue;
            p = p.merge(pa.getPolicy());
        }
        return p;
    }

    void readDocument() {
        if (null != this.attachments) {
            return;
        }
        this.attachments = new ArrayList<PolicyAttachment>();
        Document doc = null;
        try {
            InputStream is = this.location.getInputStream();
            if (null == is) {
                throw new PolicyException(new Message("COULD_NOT_OPEN_ATTACHMENT_DOC_EXC", BUNDLE, new Object[]{this.location}));
            }
            doc = DOMUtils.readXml((InputStream)is);
        }
        catch (Exception ex) {
            throw new PolicyException((Throwable)ex);
        }
        PolicyConstants constants = null;
        if (null != this.bus) {
            constants = (PolicyConstants)this.bus.getExtension(PolicyConstants.class);
        }
        if (null == constants) {
            constants = new PolicyConstants();
        }
        NodeList nl = doc.getElementsByTagNameNS(constants.getNamespace(), constants.getPolicyAttachmentElemName());
        for (int i = 0; i < nl.getLength(); ++i) {
            PolicyAttachment attachment = new PolicyAttachment();
            Element ae = (Element)nl.item(i);
            for (Node nd = ae.getFirstChild(); nd != null; nd = nd.getNextSibling()) {
                PolicyReference ref;
                if (1 != nd.getNodeType()) continue;
                QName qn = new QName(nd.getNamespaceURI(), nd.getLocalName());
                if (constants.getAppliesToElemQName().equals(qn)) {
                    Collection<DomainExpression> des = this.readDomainExpressions((Element)nd);
                    if (des.isEmpty()) continue;
                    attachment.setDomainExpressions(des);
                    continue;
                }
                if (constants.getPolicyElemQName().equals(qn)) {
                    Policy p = this.builder.getPolicy((Element)nd);
                    if (null != attachment.getPolicy()) {
                        p = p.merge(attachment.getPolicy());
                    }
                    attachment.setPolicy(p);
                    continue;
                }
                if (!constants.getPolicyReferenceElemQName().equals(qn) || null == (ref = this.builder.getPolicyReference((Element)nd))) continue;
                Policy p = this.resolveReference(ref, doc);
                if (null != attachment.getPolicy()) {
                    p = p.merge(attachment.getPolicy());
                }
                attachment.setPolicy(p);
            }
            if (null == attachment.getPolicy() || null == attachment.getDomainExpressions()) continue;
            this.attachments.add(attachment);
        }
    }

    Policy resolveReference(PolicyReference ref, Document doc) {
        Policy p = null;
        p = this.isExternal(ref) ? this.resolveExternal(ref, doc.getBaseURI()) : this.resolveLocal(ref, doc);
        this.checkResolved(ref, p);
        return p;
    }

    Policy resolveLocal(PolicyReference ref, Document doc) {
        String relativeURI = ref.getURI().substring(1);
        String absoluteURI = doc.getBaseURI() + ref.getURI();
        Policy resolved = this.registry.lookup(absoluteURI);
        if (null != resolved) {
            return resolved;
        }
        LocalDocumentReferenceResolver resolver = new LocalDocumentReferenceResolver(doc, this.builder, (PolicyConstants)this.bus.getExtension(PolicyConstants.class));
        resolved = resolver.resolveReference(relativeURI);
        if (null != resolved) {
            ref.setURI(absoluteURI);
            this.registry.register(absoluteURI, resolved);
        }
        return resolved;
    }

    Collection<DomainExpression> readDomainExpressions(Element appliesToElem) {
        ArrayList<DomainExpression> des = new ArrayList<DomainExpression>();
        for (Node nd = appliesToElem.getFirstChild(); nd != null; nd = nd.getNextSibling()) {
            if (1 != nd.getNodeType()) continue;
            DomainExpressionBuilderRegistry debr = (DomainExpressionBuilderRegistry)((Object)this.bus.getExtension(DomainExpressionBuilderRegistry.class));
            assert (null != debr);
            DomainExpression de = debr.build((Element)nd);
            des.add(de);
        }
        return des;
    }

    void setAttachments(Collection<PolicyAttachment> a) {
        this.attachments = a;
    }

    Collection<PolicyAttachment> getAttachments() {
        return this.attachments;
    }
}

