/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy.attachment.wsdl11;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.service.model.AbstractDescriptionElement;
import org.apache.cxf.service.model.BindingFaultInfo;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.DescriptionInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.Extensible;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.policy.PolicyProvider;
import org.apache.cxf.ws.policy.attachment.AbstractPolicyProvider;
import org.apache.cxf.ws.policy.attachment.reference.LocalServiceModelReferenceResolver;
import org.apache.cxf.wsdl11.WSDLServiceBuilder;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyReference;

public class Wsdl11AttachmentPolicyProvider
extends AbstractPolicyProvider
implements PolicyProvider {
    public Wsdl11AttachmentPolicyProvider() {
        this(null);
    }

    public Wsdl11AttachmentPolicyProvider(Bus bus) {
        super(bus);
    }

    public Policy getEffectivePolicy(ServiceInfo si) {
        return this.getElementPolicy((AbstractDescriptionElement)si);
    }

    public Policy getEffectivePolicy(EndpointInfo ei) {
        Policy p = this.getElementPolicy((AbstractDescriptionElement)ei);
        p = p.merge(this.getElementPolicy((AbstractDescriptionElement)ei.getBinding()));
        p = p.merge(this.getElementPolicy((AbstractDescriptionElement)ei.getInterface(), true));
        return p;
    }

    public Policy getEffectivePolicy(BindingOperationInfo bi) {
        DescriptionInfo di = bi.getBinding().getDescription();
        Policy p = this.getElementPolicy((Extensible)bi, false, di);
        p = p.merge(this.getElementPolicy((Extensible)bi.getOperationInfo(), false, di));
        return p;
    }

    public Policy getEffectivePolicy(BindingMessageInfo bmi) {
        ServiceInfo si = bmi.getBindingOperation().getBinding().getService();
        DescriptionInfo di = si.getDescription();
        Policy p = this.getElementPolicy((Extensible)bmi, false, di);
        MessageInfo mi = bmi.getMessageInfo();
        p = p.merge(this.getElementPolicy((Extensible)mi, true, di));
        Extensible ex = this.getMessageTypeInfo(mi.getName(), di);
        p = p.merge(this.getElementPolicy(ex, false, di));
        return p;
    }

    public Policy getEffectivePolicy(BindingFaultInfo bfi) {
        ServiceInfo si = bfi.getBindingOperation().getBinding().getService();
        DescriptionInfo di = si.getDescription();
        Policy p = this.getElementPolicy((Extensible)bfi, false, di);
        FaultInfo fi = bfi.getFaultInfo();
        p = p.merge(this.getElementPolicy((Extensible)fi, true, di));
        Extensible ex = this.getMessageTypeInfo(fi.getName(), di);
        p = p.merge(this.getElementPolicy(ex, false, di));
        return p;
    }

    Policy getElementPolicy(AbstractDescriptionElement adh) {
        return this.getElementPolicy(adh, false);
    }

    Policy getElementPolicy(AbstractDescriptionElement adh, boolean includeAttributes) {
        return this.getElementPolicy((Extensible)adh, includeAttributes, adh.getDescription());
    }

    Policy getElementPolicy(Extensible ex, boolean includeAttributes, DescriptionInfo di) {
        Policy elementPolicy = new Policy();
        if (null == ex || null == di) {
            return elementPolicy;
        }
        List extensions = ex.getExtensors(UnknownExtensibilityElement.class);
        PolicyConstants constants = (PolicyConstants)this.bus.getExtension(PolicyConstants.class);
        if (null != extensions) {
            for (UnknownExtensibilityElement e : extensions) {
                PolicyReference ref;
                Policy p = null;
                if (constants.getPolicyElemQName().equals(e.getElementType())) {
                    p = this.builder.getPolicy(e.getElement());
                } else if (constants.getPolicyReferenceElemQName().equals(e.getElementType()) && null != (ref = this.builder.getPolicyReference(e.getElement()))) {
                    p = this.resolveReference(ref, di);
                }
                if (null == p) continue;
                elementPolicy = elementPolicy.merge(p);
            }
        }
        if (includeAttributes) {
            Object attr = ex.getExtensionAttribute(constants.getPolicyURIsAttrQName());
            String uris = null;
            if (attr instanceof QName) {
                uris = ((QName)attr).getLocalPart();
            } else if (attr instanceof String) {
                uris = (String)attr;
            }
            if (null != uris) {
                StringTokenizer st = new StringTokenizer(uris);
                while (st.hasMoreTokens()) {
                    String uri = st.nextToken();
                    PolicyReference ref = new PolicyReference();
                    ref.setURI(uri);
                    Policy p = this.resolveReference(ref, di);
                    if (null == p) continue;
                    elementPolicy = elementPolicy.merge(p);
                }
            }
        }
        return elementPolicy;
    }

    Policy resolveReference(PolicyReference ref, DescriptionInfo di) {
        Policy p = null;
        p = this.isExternal(ref) ? this.resolveExternal(ref, di.getBaseURI()) : this.resolveLocal(ref, di);
        this.checkResolved(ref, p);
        return p;
    }

    Policy resolveLocal(PolicyReference ref, DescriptionInfo di) {
        String uri = ref.getURI().substring(1);
        String absoluteURI = di.getBaseURI() + uri;
        Policy resolved = this.registry.lookup(absoluteURI);
        if (null != resolved) {
            return resolved;
        }
        LocalServiceModelReferenceResolver resolver = new LocalServiceModelReferenceResolver(di, this.builder, (PolicyConstants)this.bus.getExtension(PolicyConstants.class));
        resolved = resolver.resolveReference(uri);
        if (null != resolved) {
            ref.setURI(absoluteURI);
            this.registry.register(absoluteURI, resolved);
        }
        return resolved;
    }

    private Extensible getMessageTypeInfo(QName name, DescriptionInfo di) {
        List extensors;
        if (null == di) {
            return null;
        }
        Definition def = (Definition)di.getProperty(WSDLServiceBuilder.WSDL_DEFINITION);
        if (null == def) {
            return null;
        }
        Message m = def.getMessage(name);
        if (null != m && null != (extensors = CastUtils.cast((List)m.getExtensibilityElements(), ExtensibilityElement.class))) {
            return new ExtensibleInfo(extensors);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExtensibleInfo
    implements Extensible {
        private List<ExtensibilityElement> extensors;

        ExtensibleInfo(List<ExtensibilityElement> e) {
            this.extensors = e;
        }

        public <T> T getExtensor(Class<T> cls) {
            for (ExtensibilityElement e : this.extensors) {
                if (!cls.isInstance(e)) continue;
                return cls.cast(e);
            }
            return null;
        }

        public <T> List<T> getExtensors(Class<T> cls) {
            if (null == this.extensors) {
                return null;
            }
            ArrayList<T> list = new ArrayList<T>(this.extensors.size());
            for (ExtensibilityElement e : this.extensors) {
                if (!cls.isInstance(e)) continue;
                list.add(cls.cast(e));
            }
            return list;
        }

        public void addExtensionAttribute(QName arg0, Object arg1) {
        }

        public void addExtensor(Object arg0) {
        }

        public Object getExtensionAttribute(QName arg0) {
            return null;
        }

        public Map<QName, Object> getExtensionAttributes() {
            return null;
        }

        public void setExtensionAttributes(Map<QName, Object> arg0) {
        }
    }
}

