/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.saaj.SAAJInInterceptor;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.token.Timestamp;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSS4JInInterceptor
extends AbstractWSS4JInterceptor {
    public static final String TIMESTAMP_RESULT = "wss4j.timestamp.result";
    public static final String SIGNATURE_RESULT = "wss4j.signature.result";
    public static final String PRINCIPAL_RESULT = "wss4j.principal.result";
    public static final String PROCESSOR_MAP = "wss4j.processor.map";
    private static final Logger LOG = LogUtils.getL7dLogger(WSS4JInInterceptor.class);
    private static final Logger TIME_LOG = LogUtils.getL7dLogger(WSS4JInInterceptor.class, null, (String)(WSS4JInInterceptor.class.getName() + "-Time"));
    private WSSecurityEngine secEngineOverride;

    public WSS4JInInterceptor() {
        this.setPhase("pre-protocol");
        this.getAfter().add(SAAJInInterceptor.class.getName());
    }

    public WSS4JInInterceptor(Map<String, Object> properties) {
        this();
        this.setProperties(properties);
        Map map = CastUtils.cast((Map)((Map)properties.get(PROCESSOR_MAP)));
        if (map != null) {
            this.secEngineOverride = this.createSecurityEngine(map);
        }
    }

    public void handleMessage(SoapMessage msg) throws Fault {
        boolean doDebug = LOG.isLoggable(Level.FINE);
        boolean doTimeLog = TIME_LOG.isLoggable(Level.FINE);
        SoapVersion version = msg.getVersion();
        if (doDebug) {
            LOG.fine("WSS4JInInterceptor: enter handleMessage()");
        }
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        long t3 = 0L;
        if (doTimeLog) {
            t0 = System.currentTimeMillis();
        }
        RequestData reqData = new RequestData();
        try {
            reqData.setMsgContext((Object)msg);
            Vector actions = new Vector();
            String action = this.getAction(msg, version);
            int doAction = WSSecurityUtil.decodeAction((String)action, actions);
            String actor = (String)this.getOption("actor");
            SOAPMessage doc = (SOAPMessage)msg.getContent(SOAPMessage.class);
            if (doc == null) {
                throw new SoapFault(new Message("NO_SAAJ_DOC", LOG, new Object[0]), version.getReceiver());
            }
            CallbackHandler cbHandler = this.getCallback(reqData, doAction);
            this.doReceiverAction(doAction, reqData);
            Vector wsResult = null;
            if (doTimeLog) {
                t1 = System.currentTimeMillis();
            }
            wsResult = this.getSecurityEngine().processSecurityHeader((Document)doc.getSOAPPart(), actor, cbHandler, reqData.getSigCrypto(), reqData.getDecCrypto());
            if (doTimeLog) {
                t2 = System.currentTimeMillis();
            }
            if (wsResult == null) {
                if (doAction == 0) {
                    return;
                }
                if (doc.getSOAPPart().getEnvelope().getBody().hasFault()) {
                    LOG.warning("Request does not contain required Security header, but it's a fault.");
                    return;
                }
                LOG.warning("Request does not contain required Security header");
                throw new WSSecurityException(3);
            }
            if (reqData.getWssConfig().isEnableSignatureConfirmation()) {
                this.checkSignatureConfirmation(reqData, wsResult);
            }
            Vector signatureResults = new Vector();
            if (!(signatureResults = WSSecurityUtil.fetchAllActionResults((Vector)wsResult, (int)2, signatureResults)).isEmpty()) {
                for (int i = 0; i < signatureResults.size(); ++i) {
                    WSSecurityEngineResult result = (WSSecurityEngineResult)signatureResults.get(i);
                    X509Certificate returnCert = (X509Certificate)result.get((Object)"x509-certificate");
                    if (returnCert != null && !this.verifyTrust(returnCert, reqData)) {
                        LOG.warning("The certificate used for the signature is not trusted");
                        throw new WSSecurityException(6);
                    }
                    msg.put(SIGNATURE_RESULT, (Object)result);
                }
            }
            Vector timestampResults = new Vector();
            if (!(timestampResults = WSSecurityUtil.fetchAllActionResults((Vector)wsResult, (int)32, timestampResults)).isEmpty()) {
                for (int i = 0; i < timestampResults.size(); ++i) {
                    WSSecurityEngineResult result = (WSSecurityEngineResult)timestampResults.get(i);
                    Timestamp timestamp = (Timestamp)result.get((Object)"timestamp");
                    if (timestamp != null && !this.verifyTimestamp(timestamp, this.decodeTimeToLive(reqData))) {
                        LOG.warning("The timestamp could not be validated");
                        throw new WSSecurityException(8);
                    }
                    msg.put(TIMESTAMP_RESULT, (Object)result);
                }
            }
            if (!this.checkReceiverResultsAnyOrder(wsResult, actions)) {
                LOG.warning("Security processing failed (actions mismatch)");
                throw new WSSecurityException(3);
            }
            this.doResults(msg, actor, doc, wsResult);
            if (doTimeLog) {
                t3 = System.currentTimeMillis();
                TIME_LOG.fine("Receive request: total= " + (t3 - t0) + " request preparation= " + (t1 - t0) + " request processing= " + (t2 - t1) + " header, cert verify, timestamp= " + (t3 - t2) + "\n");
            }
            if (doDebug) {
                LOG.fine("WSS4JInInterceptor: exit handleMessage()");
            }
        }
        catch (WSSecurityException e) {
            LOG.log(Level.WARNING, "", e);
            SoapFault fault = this.createSoapFault(version, e);
            throw fault;
        }
        catch (XMLStreamException e) {
            throw new SoapFault(new Message("STAX_EX", LOG, new Object[0]), (Throwable)e, version.getSender());
        }
        catch (SOAPException e) {
            throw new SoapFault(new Message("SAAJ_EX", LOG, new Object[0]), (Throwable)e, version.getSender());
        }
        finally {
            reqData.clear();
            reqData = null;
        }
    }

    private void doResults(SoapMessage msg, String actor, SOAPMessage doc, Vector wsResult) throws SOAPException, XMLStreamException {
        Vector<WSHandlerResult> results = CastUtils.cast((List)((List)msg.get((Object)"RECV_RESULTS")));
        if (results == null) {
            results = new Vector<WSHandlerResult>();
            msg.put("RECV_RESULTS", results);
        }
        WSHandlerResult rResult = new WSHandlerResult(actor, wsResult);
        results.add(0, rResult);
        SOAPBody body = doc.getSOAPBody();
        XMLStreamReader reader = StaxUtils.createXMLStreamReader((Source)new DOMSource((Node)body));
        int evt = reader.next();
        for (int i = 0; reader.hasNext() && i < 1 && (evt != 2 || evt != 1); ++i) {
            reader.next();
        }
        msg.setContent(XMLStreamReader.class, (Object)reader);
        for (WSSecurityEngineResult o : CastUtils.cast((List)wsResult, WSSecurityEngineResult.class)) {
            final Principal p = (Principal)o.get((Object)"principal");
            if (p == null) continue;
            msg.put(PRINCIPAL_RESULT, (Object)p);
            SecurityContext sc = (SecurityContext)msg.get(SecurityContext.class);
            if (sc != null && sc.getUserPrincipal() != null) continue;
            SecurityContext c = new SecurityContext(){

                public Principal getUserPrincipal() {
                    return p;
                }

                public boolean isUserInRole(String role) {
                    return false;
                }
            };
            msg.put(SecurityContext.class, (Object)c);
            break;
        }
    }

    private String getAction(SoapMessage msg, SoapVersion version) {
        String action = (String)this.getOption("action");
        if (action == null) {
            action = (String)msg.get((Object)"action");
        }
        if (action == null) {
            LOG.warning("No security action was defined!");
            throw new SoapFault("No security action was defined!", version.getReceiver());
        }
        return action;
    }

    private CallbackHandler getCallback(RequestData reqData, int doAction) throws WSSecurityException {
        CallbackHandler cbHandler = null;
        if ((doAction & 5) != 0) {
            cbHandler = this.getPasswordCB(reqData);
        }
        return cbHandler;
    }

    private WSSecurityEngine getSecurityEngine() {
        if (this.secEngineOverride != null) {
            return this.secEngineOverride;
        }
        return secEngine;
    }

    private WSSecurityEngine createSecurityEngine(Map<QName, Object> map) {
        assert (map != null);
        WSSConfig config = WSSConfig.getNewInstance();
        for (Map.Entry<QName, Object> entry : map.entrySet()) {
            QName key = entry.getKey();
            Object val = entry.getValue();
            if (val instanceof String) {
                String valStr = ((String)val).trim();
                if ("null".equals(valStr) || valStr.length() == 0) {
                    valStr = null;
                }
                config.setProcessor(key, valStr);
                continue;
            }
            if (val instanceof Processor) {
                config.setProcessor(key, (Processor)val);
                continue;
            }
            if (val != null) continue;
            config.setProcessor(key, (String)val);
        }
        WSSecurityEngine ret = new WSSecurityEngine();
        ret.setWssConfig(config);
        return ret;
    }

    private SoapFault createSoapFault(SoapVersion version, WSSecurityException e) {
        SoapFault fault;
        QName faultCode = e.getFaultCode();
        if (version.getVersion() == 1.1 && faultCode != null) {
            fault = new SoapFault(e.getMessage(), (Throwable)e, faultCode);
        } else {
            fault = new SoapFault(e.getMessage(), (Throwable)e, version.getSender());
            if (version.getVersion() != 1.1 && faultCode != null) {
                fault.setSubCode(faultCode);
            }
        }
        return fault;
    }
}

