/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.Soap12;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.interceptor.EndpointSelectionInterceptor;
import org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor;
import org.apache.cxf.binding.soap.model.SoapOperationInfo;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.OperationInfo;

public class SoapActionInInterceptor
extends AbstractSoapInterceptor {
    public SoapActionInInterceptor() {
        super("read");
        this.addAfter(ReadHeadersInterceptor.class.getName());
        this.addAfter(EndpointSelectionInterceptor.class.getName());
    }

    public void handleMessage(SoapMessage message) throws Fault {
        if (message.getVersion() instanceof Soap11) {
            List sa;
            Map headers = CastUtils.cast((Map)((Map)message.get(Message.PROTOCOL_HEADERS)));
            if (headers != null && (sa = (List)headers.get("SOAPAction")) != null && sa.size() > 0) {
                String action = (String)sa.get(0);
                if (action.startsWith("\"")) {
                    action = action.substring(1, action.length() - 1);
                }
                this.getAndSetOperation(message, action);
            }
        } else if (message.getVersion() instanceof Soap12) {
            String ct = (String)message.get("Content-Type");
            if (ct == null) {
                return;
            }
            int start = ct.indexOf("action=");
            if (start != -1) {
                int end;
                if (ct.charAt(start + 7) == '\"') {
                    end = ct.indexOf(34, start += 8);
                } else {
                    end = ct.indexOf(59, start += 7);
                    if (end == -1) {
                        end = ct.length();
                    }
                }
                this.getAndSetOperation(message, ct.substring(start, end));
            }
        }
    }

    private void getAndSetOperation(SoapMessage message, String action) {
        if (StringUtils.isEmpty((String)action)) {
            return;
        }
        Exchange ex = message.getExchange();
        Endpoint ep = (Endpoint)ex.get(Endpoint.class);
        BindingOperationInfo bindingOp = null;
        Collection bops = ep.getBinding().getBindingInfo().getOperations();
        if (bops == null) {
            return;
        }
        for (BindingOperationInfo boi : bops) {
            SoapOperationInfo soi = (SoapOperationInfo)boi.getExtensor(SoapOperationInfo.class);
            if (soi == null || !action.equals(soi.getAction())) continue;
            if (bindingOp != null) {
                return;
            }
            bindingOp = boi;
        }
        if (bindingOp != null) {
            ex.put(BindingOperationInfo.class, bindingOp);
            ex.put(OperationInfo.class, (Object)bindingOp.getOperationInfo());
        }
    }
}

