/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxfse;

import java.util.List;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.jbi.JBITransportFactory;
import org.apache.servicemix.id.IdGenerator;
import org.apache.servicemix.jbi.api.ClientFactory;
import org.apache.servicemix.jbi.api.Container;
import org.apache.servicemix.jbi.api.ServiceMixClient;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfSeProxyFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    private String name = "java:comp/env/jbi/ClientFactory";
    private Container container;
    private ClientFactory factory;
    private ComponentContext context;
    private Class type;
    private Object proxy;
    private QName service;
    private QName interfaceName;
    private String endpoint;
    private boolean propagateSecuritySubject;
    private ServiceMixClient client;
    private boolean useJBIWrapper = true;
    private boolean useSOAPEnvelope = true;

    public Object getObject() throws Exception {
        if (this.proxy == null) {
            this.proxy = this.createProxy();
        }
        return this.proxy;
    }

    private Object createProxy() throws Exception {
        DeliveryChannel dc;
        JaxWsProxyFactoryBean cf = new JaxWsProxyFactoryBean();
        cf.setServiceName(this.getService());
        if (this.getEndpoint() != null) {
            cf.setEndpointName(new QName(this.getService().getNamespaceURI(), this.getEndpoint()));
        }
        cf.setServiceClass(this.type);
        cf.setAddress("jbi://" + new IdGenerator().generateSanitizedId());
        if (this.isUseJBIWrapper()) {
            cf.setBindingId("http://cxf.apache.org/bindings/jbi");
        }
        Bus bus = BusFactory.getDefaultBus();
        JBITransportFactory jbiTransportFactory = (JBITransportFactory)((ConduitInitiatorManager)bus.getExtension(ConduitInitiatorManager.class)).getConduitInitiator("http://cxf.apache.org/transports/jbi");
        if (this.getInternalContext() != null && (dc = this.getInternalContext().getDeliveryChannel()) != null) {
            jbiTransportFactory.setDeliveryChannel(dc);
        }
        Object proxy = cf.create();
        if (!this.isUseJBIWrapper() && !this.isUseSOAPEnvelope()) {
            this.removeInterceptor(ClientProxy.getClient((Object)proxy).getEndpoint().getBinding().getInInterceptors(), "ReadHeadersInterceptor");
            this.removeInterceptor(ClientProxy.getClient((Object)proxy).getEndpoint().getBinding().getInFaultInterceptors(), "ReadHeadersInterceptor");
            this.removeInterceptor(ClientProxy.getClient((Object)proxy).getEndpoint().getBinding().getOutInterceptors(), "SoapOutInterceptor");
            this.removeInterceptor(ClientProxy.getClient((Object)proxy).getEndpoint().getBinding().getOutFaultInterceptors(), "SoapOutInterceptor");
            this.removeInterceptor(ClientProxy.getClient((Object)proxy).getEndpoint().getBinding().getOutInterceptors(), "StaxOutInterceptor");
        }
        return proxy;
    }

    private void removeInterceptor(List<Interceptor> interceptors, String whichInterceptor) {
        for (Interceptor interceptor : interceptors) {
            if (!interceptor.getClass().getName().endsWith(whichInterceptor)) continue;
            interceptors.remove(interceptor);
        }
    }

    public Class getObjectType() {
        return this.type;
    }

    public boolean isSingleton() {
        return true;
    }

    protected ComponentContext getInternalContext() throws Exception {
        if (this.context == null) {
            if (this.factory == null) {
                this.factory = this.container != null ? this.container.getClientFactory() : (ClientFactory)new InitialContext().lookup(this.name);
            }
            this.client = this.factory.createClient();
            this.context = this.client.getContext();
        }
        return this.context;
    }

    public Class getType() {
        return this.type;
    }

    public void setType(Class type) {
        this.type = type;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpointName) {
        this.endpoint = endpointName;
    }

    public QName getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(QName interfaceName) {
        this.interfaceName = interfaceName;
    }

    public QName getService() {
        return this.service;
    }

    public void setService(QName service) {
        this.service = service;
    }

    public ComponentContext getContext() {
        return this.context;
    }

    public void setContext(ComponentContext context) {
        this.context = context;
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public ClientFactory getFactory() {
        return this.factory;
    }

    public void setFactory(ClientFactory factory) {
        this.factory = factory;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isPropagateSecuritySubject() {
        return this.propagateSecuritySubject;
    }

    public void setPropagateSecuritySubject(boolean propagateSecuritySubject) {
        this.propagateSecuritySubject = propagateSecuritySubject;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.type == null) {
            throw new IllegalArgumentException("type must be set");
        }
    }

    public void destroy() throws Exception {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    public void setUseJBIWrapper(boolean useJBIWrapper) {
        this.useJBIWrapper = useJBIWrapper;
    }

    public boolean isUseJBIWrapper() {
        return this.useJBIWrapper;
    }

    public void setUseSOAPEnvelope(boolean useSOAPEnvelope) {
        this.useSOAPEnvelope = useSOAPEnvelope;
    }

    public boolean isUseSOAPEnvelope() {
        return this.useSOAPEnvelope;
    }
}

