/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxfse;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class CxfSeConfiguration {
    public static final String CONFIG_FILE = "component.properties";
    private String rootDir;
    private String componentName = "servicemix-cxf-se";
    private Properties properties = new Properties();
    private String busCfg;

    public boolean load() {
        File f = null;
        InputStream in = null;
        if (this.rootDir != null && !(f = new File(this.rootDir, CONFIG_FILE)).exists()) {
            f = null;
        }
        if (f == null && (in = this.getClass().getClassLoader().getResourceAsStream(CONFIG_FILE)) == null) {
            return false;
        }
        try {
            if (f != null) {
                this.properties.load(new FileInputStream(f));
            } else {
                this.properties.load(in);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load component configuration", e);
        }
        if (this.properties.getProperty(this.componentName + ".busCfg") != null) {
            this.setBusCfg(this.properties.getProperty(this.componentName + ".busCfg"));
        }
        return true;
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public void setRootDir(String rootDir) {
        this.rootDir = rootDir;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public void setBusCfg(String busCfg) {
        this.busCfg = busCfg;
    }

    public String getBusCfg() {
        return this.busCfg;
    }
}

