/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.clustering;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.clustering.FailoverStrategy;
import org.apache.cxf.clustering.SequentialStrategy;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.AbstractConduitSelector;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.Retryable;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.transport.Conduit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FailoverTargetSelector
extends AbstractConduitSelector {
    private static final Logger LOG = LogUtils.getL7dLogger(FailoverTargetSelector.class);
    private Map<InvocationKey, InvocationContext> inProgress = new HashMap<InvocationKey, InvocationContext>();
    private FailoverStrategy failoverStrategy;

    public FailoverTargetSelector() {
        this(null);
    }

    public FailoverTargetSelector(Conduit c) {
        super(c);
    }

    public synchronized void prepare(Message message) {
        Exchange exchange = message.getExchange();
        InvocationKey key = new InvocationKey(exchange);
        if (!this.inProgress.containsKey(key)) {
            Endpoint endpoint = (Endpoint)exchange.get(Endpoint.class);
            BindingOperationInfo bindingOperationInfo = (BindingOperationInfo)exchange.get(BindingOperationInfo.class);
            Object[] params = ((List)message.getContent(List.class)).toArray();
            Map context = CastUtils.cast((Map)((Map)message.get((Object)"org.apache.cxf.invocation.context")));
            InvocationContext invocation = new InvocationContext(endpoint, bindingOperationInfo, params, context);
            this.inProgress.put(key, invocation);
        }
    }

    public Conduit selectConduit(Message message) {
        return this.getSelectedConduit(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(Exchange exchange) {
        InvocationKey key = new InvocationKey(exchange);
        InvocationContext invocation = null;
        FailoverTargetSelector failoverTargetSelector = this;
        synchronized (failoverTargetSelector) {
            invocation = this.inProgress.get(key);
        }
        boolean failover = false;
        if (this.requiresFailover(exchange)) {
            Endpoint failoverTarget = this.getFailoverTarget(exchange, invocation);
            if (failoverTarget != null) {
                this.setEndpoint(failoverTarget);
                this.selectedConduit.close();
                this.selectedConduit = null;
                Exception prevExchangeFault = (Exception)exchange.remove((Object)Exception.class.getName());
                Message outMessage = exchange.getOutMessage();
                Exception prevMessageFault = (Exception)outMessage.getContent(Exception.class);
                outMessage.setContent(Exception.class, null);
                this.overrideAddressProperty(invocation.getContext());
                Retryable retry = (Retryable)exchange.get(Retryable.class);
                exchange.clear();
                if (retry != null) {
                    try {
                        failover = true;
                        retry.invoke(invocation.getBindingOperationInfo(), invocation.getParams(), invocation.getContext(), exchange);
                    }
                    catch (Exception e) {
                        if (exchange.get(Exception.class) != null) {
                            exchange.put(Exception.class, (Object)prevExchangeFault);
                        }
                        if (outMessage.getContent(Exception.class) != null) {
                            outMessage.setContent(Exception.class, (Object)prevMessageFault);
                        }
                    }
                }
            } else {
                this.setEndpoint(invocation.retrieveOriginalEndpoint(this.endpoint));
            }
        }
        if (!failover) {
            this.getLogger().info("FAILOVER_NOT_REQUIRED");
            FailoverTargetSelector failoverTargetSelector2 = this;
            synchronized (failoverTargetSelector2) {
                this.inProgress.remove(key);
            }
            super.complete(exchange);
        }
    }

    public synchronized void setStrategy(FailoverStrategy strategy) {
        this.getLogger().log(Level.INFO, "USING_STRATEGY", new Object[]{strategy});
        this.failoverStrategy = strategy;
    }

    public synchronized FailoverStrategy getStrategy() {
        if (this.failoverStrategy == null) {
            this.failoverStrategy = new SequentialStrategy();
            this.getLogger().log(Level.INFO, "USING_STRATEGY", new Object[]{this.failoverStrategy});
        }
        return this.failoverStrategy;
    }

    protected Logger getLogger() {
        return LOG;
    }

    private boolean requiresFailover(Exchange exchange) {
        Message outMessage = exchange.getOutMessage();
        Exception ex = outMessage.get(Exception.class) != null ? (Exception)outMessage.get(Exception.class) : (Exception)exchange.get(Exception.class);
        this.getLogger().log(Level.INFO, "CHECK_LAST_INVOKE_FAILED", new Object[]{ex != null});
        boolean failover = false;
        for (Throwable curr = ex; curr != null; curr = curr.getCause()) {
            this.getLogger().log(Level.WARNING, "CHECK_FAILURE_IN_TRANSPORT", new Object[]{ex, curr instanceof IOException});
            failover = curr instanceof IOException;
        }
        return failover;
    }

    private Endpoint getFailoverTarget(Exchange exchange, InvocationContext invocation) {
        List alternateAddresses = null;
        if (!invocation.hasAlternates()) {
            alternateAddresses = this.getStrategy().getAlternateAddresses(exchange);
            if (alternateAddresses != null) {
                invocation.setAlternateAddresses(alternateAddresses);
            } else {
                invocation.setAlternateEndpoints(this.getStrategy().getAlternateEndpoints(exchange));
            }
        } else {
            alternateAddresses = invocation.getAlternateAddresses();
        }
        Endpoint failoverTarget = null;
        if (alternateAddresses != null) {
            String alternateAddress = this.getStrategy().selectAlternateAddress(alternateAddresses);
            if (alternateAddress != null) {
                failoverTarget = this.getEndpoint();
                failoverTarget.getEndpointInfo().setAddress(alternateAddress);
            }
        } else {
            failoverTarget = this.getStrategy().selectAlternateEndpoint(invocation.getAlternateEndpoints());
        }
        return failoverTarget;
    }

    private void overrideAddressProperty(Map<String, Object> context) {
        Map requestContext = CastUtils.cast((Map)((Map)context.get("RequestContext")));
        if (requestContext != null) {
            requestContext.put(Message.ENDPOINT_ADDRESS, this.getEndpoint().getEndpointInfo().getAddress());
            requestContext.put("javax.xml.ws.service.endpoint.address", this.getEndpoint().getEndpointInfo().getAddress());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InvocationContext {
        private Endpoint originalEndpoint;
        private String originalAddress;
        private BindingOperationInfo bindingOperationInfo;
        private Object[] params;
        private Map<String, Object> context;
        private List<Endpoint> alternateEndpoints;
        private List<String> alternateAddresses;

        InvocationContext(Endpoint endpoint, BindingOperationInfo boi, Object[] prms, Map<String, Object> ctx) {
            this.originalEndpoint = endpoint;
            this.originalAddress = endpoint.getEndpointInfo().getAddress();
            this.bindingOperationInfo = boi;
            this.params = prms;
            this.context = ctx;
        }

        Endpoint retrieveOriginalEndpoint(Endpoint endpoint) {
            if (endpoint != this.originalEndpoint) {
                FailoverTargetSelector.this.getLogger().log(Level.INFO, "REVERT_TO_ORIGINAL_TARGET", endpoint.getEndpointInfo().getName());
            }
            if (!endpoint.getEndpointInfo().getAddress().equals(this.originalAddress)) {
                endpoint.getEndpointInfo().setAddress(this.originalAddress);
                FailoverTargetSelector.this.getLogger().log(Level.INFO, "REVERT_TO_ORIGINAL_ADDRESS", endpoint.getEndpointInfo().getAddress());
            }
            return this.originalEndpoint;
        }

        BindingOperationInfo getBindingOperationInfo() {
            return this.bindingOperationInfo;
        }

        Object[] getParams() {
            return this.params;
        }

        Map<String, Object> getContext() {
            return this.context;
        }

        List<Endpoint> getAlternateEndpoints() {
            return this.alternateEndpoints;
        }

        List<String> getAlternateAddresses() {
            return this.alternateAddresses;
        }

        void setAlternateEndpoints(List<Endpoint> alternates) {
            this.alternateEndpoints = alternates;
        }

        void setAlternateAddresses(List<String> alternates) {
            this.alternateAddresses = alternates;
        }

        boolean hasAlternates() {
            return this.alternateEndpoints != null || this.alternateAddresses != null;
        }
    }

    private static class InvocationKey {
        private Exchange exchange;

        InvocationKey(Exchange ex) {
            this.exchange = ex;
        }

        public int hashCode() {
            return System.identityHashCode(this.exchange);
        }

        public boolean equals(Object o) {
            return o instanceof InvocationKey && this.exchange == ((InvocationKey)o).exchange;
        }
    }
}

