/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.endpoint;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.binding.BindingFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.ManagedEndpoint;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerLifeCycleListener;
import org.apache.cxf.endpoint.ServerLifeCycleManager;
import org.apache.cxf.endpoint.ServerRegistry;
import org.apache.cxf.management.InstrumentationManager;
import org.apache.cxf.management.ManagedComponent;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.MultipleEndpointObserver;

public class ServerImpl
implements Server {
    private static final Logger LOG = LogUtils.getL7dLogger(ServerImpl.class);
    private Destination destination;
    private Endpoint endpoint;
    private ServerRegistry serverRegistry;
    private Bus bus;
    private ServerLifeCycleManager mgr;
    private BindingFactory bindingFactory;
    private MessageObserver messageObserver;

    public ServerImpl(Bus bus, Endpoint endpoint, DestinationFactory destinationFactory, MessageObserver observer) throws BusException, IOException {
        this.endpoint = endpoint;
        this.bus = bus;
        this.messageObserver = observer;
        this.initDestination(destinationFactory);
    }

    public ServerImpl(Bus bus, Endpoint endpoint, DestinationFactory destinationFactory, BindingFactory bindingFactory) throws BusException, IOException {
        this.endpoint = endpoint;
        this.bus = bus;
        this.bindingFactory = bindingFactory;
        this.initDestination(destinationFactory);
    }

    private void initDestination(DestinationFactory destinationFactory) throws BusException, IOException {
        InstrumentationManager manager;
        EndpointInfo ei = this.endpoint.getEndpointInfo();
        if (destinationFactory == null) {
            if (ei.getAddress() != null && ei.getAddress().indexOf("local://") != -1) {
                destinationFactory = ((DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class)).getDestinationFactoryForUri(ei.getAddress());
            }
            if (destinationFactory == null) {
                destinationFactory = ((DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class)).getDestinationFactory(ei.getTransportId());
            }
        }
        this.destination = destinationFactory.getDestination(ei);
        LOG.info("Setting the server's publish address to be " + ei.getAddress());
        this.serverRegistry = (ServerRegistry)this.bus.getExtension(ServerRegistry.class);
        ManagedEndpoint mep = new ManagedEndpoint(this.bus, this.endpoint, this);
        this.mgr = (ServerLifeCycleManager)this.bus.getExtension(ServerLifeCycleManager.class);
        if (this.mgr != null) {
            this.mgr.registerListener((ServerLifeCycleListener)mep);
        }
        if ((manager = (InstrumentationManager)this.bus.getExtension(InstrumentationManager.class)) != null) {
            try {
                manager.register((ManagedComponent)mep);
            }
            catch (JMException jmex) {
                LOG.log(Level.WARNING, "Registering ManagedEndpoint failed.", jmex);
            }
        }
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public void start() {
        if (this.messageObserver != null) {
            this.destination.setMessageObserver(this.messageObserver);
        } else {
            this.bindingFactory.addListener(this.destination, this.endpoint);
        }
        if (null != this.serverRegistry) {
            LOG.fine("register the server to serverRegistry ");
            this.serverRegistry.register((Server)this);
        }
        this.mgr = (ServerLifeCycleManager)this.bus.getExtension(ServerLifeCycleManager.class);
        if (this.mgr != null) {
            this.mgr.startServer((Server)this);
        }
    }

    public void stop() {
        MessageObserver mo;
        LOG.fine("Server is stopping.");
        if (this.mgr != null) {
            this.mgr.stopServer((Server)this);
        }
        if ((mo = this.getDestination().getMessageObserver()) instanceof MultipleEndpointObserver) {
            ((MultipleEndpointObserver)mo).getEndpoints().remove(this.endpoint);
            if (!((MultipleEndpointObserver)mo).getEndpoints().isEmpty()) {
                return;
            }
        }
        this.getDestination().setMessageObserver(null);
        this.getDestination().shutdown();
        if (null != this.serverRegistry) {
            LOG.fine("unregister the server to serverRegistry ");
            this.serverRegistry.unregister((Server)this);
        }
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public MessageObserver getMessageObserver() {
        return this.messageObserver;
    }

    public void setMessageObserver(MessageObserver messageObserver) {
        this.messageObserver = messageObserver;
    }
}

