/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxfse;

import java.util.List;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.interceptor.OneWayProcessorInterceptor;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.cxfse.CxfSeConfiguration;
import org.apache.servicemix.cxfse.CxfSeEndpoint;

public class CxfSeComponent
extends DefaultComponent {
    public static final String JBI_TRANSPORT_ID = "http://cxf.apache.org/transports/jbi";
    private static final String[] CXF_CONFIG = new String[]{"META-INF/cxf/cxf.xml", "META-INF/cxf/cxf-extension-soap.xml", "META-INF/cxf/transport/jbi/cxf-transport-jbi.xml", "META-INF/cxf/binding/jbi/cxf-binding-jbi.xml"};
    private CxfSeEndpoint[] endpoints;
    private Bus bus;
    private CxfSeConfiguration configuration = new CxfSeConfiguration();
    private static Object componentRegistry;

    public CxfSeEndpoint[] getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(CxfSeEndpoint[] endpoints) {
        this.endpoints = endpoints;
    }

    protected List getConfiguredEndpoints() {
        return CxfSeComponent.asList((Object[])this.endpoints);
    }

    protected Class[] getEndpointClasses() {
        return new Class[]{CxfSeEndpoint.class};
    }

    protected void doInit() throws Exception {
        this.configuration.setRootDir(this.context.getWorkspaceRoot());
        this.configuration.setComponentName(this.context.getComponentName());
        this.configuration.load();
        if (this.configuration.getBusCfg() != null && this.configuration.getBusCfg().length() > 0) {
            CxfSeComponent.CXF_CONFIG[0] = this.configuration.getBusCfg();
        }
        if (this.bus == null) {
            this.bus = new SpringBusFactory().createBus(CXF_CONFIG);
            this.bus.getProperties().put(OneWayProcessorInterceptor.USE_ORIGINAL_THREAD, "true");
        }
        super.doInit();
    }

    protected void doShutDown() throws Exception {
        if (this.bus != null) {
            BusFactory.setThreadDefaultBus(null);
        }
        super.doShutDown();
    }

    public Bus getBus() {
        return this.bus;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public void setComponentRegistry(Object componentRegistry) {
        CxfSeComponent.componentRegistry = componentRegistry;
    }

    public static Object getComponentRegistry() {
        return componentRegistry;
    }
}

