/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.interceptor.AttachmentOutInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.StaxInInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.staxutils.StaxUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaxOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final String OUTPUT_STREAM_HOLDER = StaxOutInterceptor.class.getName() + ".outputstream";
    public static final String FORCE_START_DOCUMENT = "org.apache.cxf.stax.force-start-document";
    public static final StaxOutEndingInterceptor ENDING = new StaxOutEndingInterceptor();
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(StaxOutInterceptor.class);
    private static Map<Object, XMLOutputFactory> factories = new HashMap<Object, XMLOutputFactory>();

    public StaxOutInterceptor() {
        super("pre-stream");
        this.addAfter(AttachmentOutInterceptor.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Message message) {
        OutputStream os = (OutputStream)message.getContent(OutputStream.class);
        XMLStreamWriter writer = (XMLStreamWriter)message.getContent(XMLStreamWriter.class);
        if (os == null || writer != null) {
            return;
        }
        String encoding = this.getEncoding(message);
        try {
            XMLOutputFactory factory = StaxOutInterceptor.getXMLOutputFactory(message);
            if (factory == null) {
                writer = StaxUtils.createXMLStreamWriter((OutputStream)os, (String)encoding);
            } else {
                XMLOutputFactory xMLOutputFactory = factory;
                synchronized (xMLOutputFactory) {
                    writer = factory.createXMLStreamWriter(os, encoding);
                }
            }
            if (MessageUtils.getContextualBoolean((Message)message, (String)FORCE_START_DOCUMENT, (boolean)false)) {
                writer.writeStartDocument(encoding, "1.0");
                message.removeContent(OutputStream.class);
                message.put((Object)OUTPUT_STREAM_HOLDER, (Object)os);
            }
        }
        catch (XMLStreamException e) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("STREAM_CREATE_EXC", BUNDLE, new Object[0]), (Throwable)e);
        }
        message.setContent(XMLStreamWriter.class, (Object)writer);
        message.getInterceptorChain().add((Interceptor)ENDING);
    }

    public void handleFault(Message message) {
        super.handleFault(message);
        OutputStream os = (OutputStream)message.get((Object)OUTPUT_STREAM_HOLDER);
        if (os != null) {
            message.setContent(OutputStream.class, (Object)os);
        }
    }

    private String getEncoding(Message message) {
        Exchange ex = message.getExchange();
        String encoding = (String)message.get((Object)Message.ENCODING);
        if (encoding == null && ex.getInMessage() != null) {
            encoding = (String)ex.getInMessage().get((Object)Message.ENCODING);
            message.put((Object)Message.ENCODING, (Object)encoding);
        }
        if (encoding == null) {
            encoding = "UTF-8";
            message.put((Object)Message.ENCODING, (Object)encoding);
        }
        return encoding;
    }

    public static XMLOutputFactory getXMLOutputFactory(Message m) throws Fault {
        Object o = m.getContextualProperty(XMLOutputFactory.class.getName());
        if (o instanceof XMLOutputFactory) {
            m.put((Object)"disable.outputstream.optimization", (Object)Boolean.TRUE);
            m.put((Object)FORCE_START_DOCUMENT, (Object)Boolean.TRUE);
            return (XMLOutputFactory)o;
        }
        if (o != null) {
            XMLOutputFactory xif = factories.get(o);
            if (xif == null) {
                Class cls;
                if (o instanceof Class) {
                    cls = (Class)o;
                } else if (o instanceof String) {
                    try {
                        cls = ClassLoaderUtils.loadClass((String)((String)o), StaxInInterceptor.class);
                    }
                    catch (ClassNotFoundException e) {
                        throw new Fault((Throwable)e);
                    }
                } else {
                    throw new Fault(new org.apache.cxf.common.i18n.Message("INVALID_INPUT_FACTORY", BUNDLE, new Object[]{o}));
                }
                try {
                    xif = (XMLOutputFactory)cls.newInstance();
                    factories.put(o, xif);
                }
                catch (InstantiationException e) {
                    throw new Fault((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new Fault((Throwable)e);
                }
            }
            m.put((Object)"disable.outputstream.optimization", (Object)Boolean.TRUE);
            m.put((Object)FORCE_START_DOCUMENT, (Object)Boolean.TRUE);
            return xif;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StaxOutEndingInterceptor
    extends AbstractPhaseInterceptor<Message> {
        public StaxOutEndingInterceptor() {
            super("pre-stream-ending");
            this.getAfter().add(AttachmentOutInterceptor.AttachmentOutEndingInterceptor.class.getName());
        }

        public void handleMessage(Message message) throws Fault {
            try {
                OutputStream os;
                XMLStreamWriter xtw = (XMLStreamWriter)message.getContent(XMLStreamWriter.class);
                if (xtw != null) {
                    xtw.writeEndDocument();
                    xtw.flush();
                    xtw.close();
                }
                if ((os = (OutputStream)message.get((Object)OUTPUT_STREAM_HOLDER)) != null) {
                    message.setContent(OutputStream.class, (Object)os);
                }
                message.removeContent(XMLStreamWriter.class);
            }
            catch (XMLStreamException e) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("STAX_WRITE_EXC", BUNDLE, new Object[0]), (Throwable)e);
            }
        }
    }
}

