/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxfse;

import java.lang.reflect.Method;
import java.util.List;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.jbi.JBITransportFactory;
import org.apache.servicemix.cxfse.CxfSeComponent;
import org.apache.servicemix.cxfse.JBIContext;
import org.apache.servicemix.cxfse.interceptors.AttachmentInInterceptor;
import org.apache.servicemix.id.IdGenerator;
import org.apache.servicemix.jbi.api.ClientFactory;
import org.apache.servicemix.jbi.api.Container;
import org.apache.servicemix.jbi.api.ServiceMixClient;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfSeProxyFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    private static final String[] CXF_CONFIG = new String[]{"META-INF/cxf/cxf.xml", "META-INF/cxf/cxf-extension-soap.xml", "META-INF/cxf/transport/jbi/cxf-transport-jbi.xml", "META-INF/cxf/binding/jbi/cxf-binding-jbi.xml"};
    private String name = "org.apache.servicemix.jbi.ClientFactory";
    private Container container;
    private ClientFactory factory;
    private ComponentContext context;
    private Class type;
    private Object proxy;
    private QName service;
    private QName interfaceName;
    private String endpoint;
    private boolean propagateSecuritySubject;
    private ServiceMixClient client;
    private boolean useJBIWrapper = true;
    private boolean useSOAPEnvelope = true;
    private boolean mtomEnabled;
    private Object componentRegistry;
    private boolean clearClientResponseContext = true;

    public Object getObject() throws Exception {
        if (this.proxy == null) {
            this.proxy = this.createProxy();
        }
        return this.proxy;
    }

    private Object createProxy() throws Exception {
        DeliveryChannel dc;
        JaxWsProxyFactoryBean cf = new JaxWsProxyFactoryBean();
        cf.setServiceName(this.getService());
        if (this.getEndpoint() != null) {
            cf.setEndpointName(new QName(this.getService().getNamespaceURI(), this.getEndpoint()));
        }
        cf.setServiceClass(this.type);
        cf.setAddress("jbi://" + new IdGenerator().generateSanitizedId());
        if (this.isUseJBIWrapper()) {
            cf.setBindingId("http://cxf.apache.org/bindings/jbi");
        }
        ComponentContext internalContext = this.getInternalContext();
        Bus bus = new SpringBusFactory().createBus();
        JBITransportFactory jbiTransportFactory = (JBITransportFactory)((ConduitInitiatorManager)bus.getExtension(ConduitInitiatorManager.class)).getConduitInitiator("http://cxf.apache.org/transports/jbi");
        if (internalContext != null && (dc = internalContext.getDeliveryChannel()) != null) {
            jbiTransportFactory.setDeliveryChannel(dc);
        }
        cf.setBus(bus);
        Object proxy = cf.create();
        if (!this.isUseJBIWrapper() && !this.isUseSOAPEnvelope()) {
            this.removeInterceptor(ClientProxy.getClient((Object)proxy).getEndpoint().getBinding().getInInterceptors(), "ReadHeadersInterceptor");
            this.removeInterceptor(ClientProxy.getClient((Object)proxy).getEndpoint().getBinding().getInFaultInterceptors(), "ReadHeadersInterceptor");
            this.removeInterceptor(ClientProxy.getClient((Object)proxy).getEndpoint().getBinding().getOutInterceptors(), "SoapOutInterceptor");
            this.removeInterceptor(ClientProxy.getClient((Object)proxy).getEndpoint().getBinding().getOutFaultInterceptors(), "SoapOutInterceptor");
            this.removeInterceptor(ClientProxy.getClient((Object)proxy).getEndpoint().getBinding().getOutInterceptors(), "StaxOutInterceptor");
        }
        if (this.isMtomEnabled()) {
            ClientProxy.getClient((Object)proxy).getEndpoint().getBinding().getInInterceptors().add(new AttachmentInInterceptor());
        }
        if (this.isClearClientResponseContext()) {
            ClearClientResponseContextInterceptor clearClientResponseContextInterceptor = new ClearClientResponseContextInterceptor(ClientProxy.getClient((Object)proxy));
            ClientProxy.getClient((Object)proxy).getEndpoint().getBinding().getOutInterceptors().add(clearClientResponseContextInterceptor);
            ClientProxy.getClient((Object)proxy).getEndpoint().getBinding().getOutFaultInterceptors().add(clearClientResponseContextInterceptor);
        }
        ClientProxy.getClient((Object)proxy).setThreadLocalRequestContext(true);
        if (this.isPropagateSecuritySubject()) {
            jbiTransportFactory.setDeliveryChannel((DeliveryChannel)new PropagateSecuritySubjectDeliveryChannel(jbiTransportFactory.getDeliveryChannel()));
        }
        return proxy;
    }

    private void removeInterceptor(List<Interceptor<? extends Message>> interceptors, String whichInterceptor) {
        for (Interceptor<? extends Message> interceptor : interceptors) {
            if (!interceptor.getClass().getName().endsWith(whichInterceptor)) continue;
            interceptors.remove(interceptor);
        }
    }

    public Class getObjectType() {
        return this.type;
    }

    public boolean isSingleton() {
        return true;
    }

    protected ComponentContext getInternalContext() throws Exception {
        Object componentRegistry;
        Method mth;
        if (CxfSeComponent.getComponentRegistry() != null) {
            Object componentRegistry2 = CxfSeComponent.getComponentRegistry();
            Method mth2 = componentRegistry2.getClass().getMethod("createComponentContext", new Class[0]);
            if (mth2 != null) {
                this.context = (ComponentContext)mth2.invoke(componentRegistry2, new Object[0]);
            }
        } else if (this.getComponentRegistry() != null && (mth = (componentRegistry = this.getComponentRegistry()).getClass().getMethod("createComponentContext", new Class[0])) != null) {
            this.context = (ComponentContext)mth.invoke(componentRegistry, new Object[0]);
        }
        if (this.context == null) {
            if (this.factory == null) {
                this.factory = this.container != null ? this.container.getClientFactory() : (ClientFactory)new InitialContext().lookup(this.name);
            }
            this.client = this.factory.createClient();
            this.context = this.client.getContext();
        }
        return this.context;
    }

    public Class getType() {
        return this.type;
    }

    public void setType(Class type) {
        this.type = type;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpointName) {
        this.endpoint = endpointName;
    }

    public QName getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(QName interfaceName) {
        this.interfaceName = interfaceName;
    }

    public QName getService() {
        return this.service;
    }

    public void setService(QName service) {
        this.service = service;
    }

    public ComponentContext getContext() {
        return this.context;
    }

    public void setContext(ComponentContext context) {
        this.context = context;
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public ClientFactory getFactory() {
        return this.factory;
    }

    public void setFactory(ClientFactory factory) {
        this.factory = factory;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isPropagateSecuritySubject() {
        return this.propagateSecuritySubject;
    }

    public void setPropagateSecuritySubject(boolean propagateSecuritySubject) {
        this.propagateSecuritySubject = propagateSecuritySubject;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.type == null) {
            throw new IllegalArgumentException("type must be set");
        }
    }

    public void destroy() throws Exception {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    public void setUseJBIWrapper(boolean useJBIWrapper) {
        this.useJBIWrapper = useJBIWrapper;
    }

    public boolean isUseJBIWrapper() {
        return this.useJBIWrapper;
    }

    public void setUseSOAPEnvelope(boolean useSOAPEnvelope) {
        this.useSOAPEnvelope = useSOAPEnvelope;
    }

    public boolean isUseSOAPEnvelope() {
        return this.useSOAPEnvelope;
    }

    public void setMtomEnabled(boolean mtomEnabled) {
        this.mtomEnabled = mtomEnabled;
    }

    public boolean isMtomEnabled() {
        return this.mtomEnabled;
    }

    public void setComponentRegistry(Object componentRegistry) {
        this.componentRegistry = componentRegistry;
    }

    public Object getComponentRegistry() {
        return this.componentRegistry;
    }

    public void setClearClientResponseContext(boolean clearClientResponseContext) {
        this.clearClientResponseContext = clearClientResponseContext;
    }

    public boolean isClearClientResponseContext() {
        return this.clearClientResponseContext;
    }

    public class PropagateSecuritySubjectDeliveryChannel
    implements DeliveryChannel {
        private DeliveryChannel delegate;

        public PropagateSecuritySubjectDeliveryChannel(DeliveryChannel dc) {
            this.delegate = dc;
        }

        public void close() throws MessagingException {
            this.delegate.close();
        }

        public MessageExchangeFactory createExchangeFactory() {
            return this.delegate.createExchangeFactory();
        }

        public MessageExchangeFactory createExchangeFactory(QName interfaceName) {
            return this.delegate.createExchangeFactory(interfaceName);
        }

        public MessageExchangeFactory createExchangeFactoryForService(QName serviceName) {
            return this.delegate.createExchangeFactoryForService(serviceName);
        }

        public MessageExchangeFactory createExchangeFactory(ServiceEndpoint endpoint) {
            return this.delegate.createExchangeFactory(endpoint);
        }

        public MessageExchange accept() throws MessagingException {
            return this.delegate.accept();
        }

        public MessageExchange accept(long timeout) throws MessagingException {
            return this.delegate.accept(timeout);
        }

        public void send(MessageExchange exchange) throws MessagingException {
            this.propagateSubject(exchange);
            this.delegate.send(exchange);
        }

        public boolean sendSync(MessageExchange exchange) throws MessagingException {
            this.propagateSubject(exchange);
            return this.delegate.sendSync(exchange);
        }

        public boolean sendSync(MessageExchange exchange, long timeout) throws MessagingException {
            this.propagateSubject(exchange);
            return this.delegate.sendSync(exchange, timeout);
        }

        private void propagateSubject(MessageExchange exchange) {
            NormalizedMessage msg;
            if (exchange instanceof InOnly) {
                msg = ((InOnly)exchange).getInMessage();
            } else if (exchange instanceof InOut) {
                msg = ((InOut)exchange).getInMessage();
            } else {
                throw new RuntimeException("Unable to determine message type to propagate subject: " + exchange.getClass().getName());
            }
            if (msg.getSecuritySubject() == null && JBIContext.getMessageExchange() != null && JBIContext.getMessageExchange().getMessage("in") != null) {
                msg.setSecuritySubject(JBIContext.getMessageExchange().getMessage("in").getSecuritySubject());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClearClientResponseContextInterceptor
    extends AbstractPhaseInterceptor<Message> {
        private final Client client;

        public ClearClientResponseContextInterceptor(Client client) {
            super("post-logical-ending");
            this.client = client;
        }

        public void handleMessage(Message message) throws Fault {
            this.client.getResponseContext().clear();
        }

        public void handleFault(Message message) {
            this.client.getResponseContext().clear();
        }
    }
}

